;;; KOI8 staff

(define-ccl-program ccl-read-koi8
  '(3
    ((read r0)
     (loop
	 (write-read-repeat
	  r0
          [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
	   16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31
	   32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47
	   48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63
	   64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79
	   80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95
	   96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111
	   112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127
	   128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143
	   144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159
	   160 160 160 ?,Lq(B  160 160 160 160 160 160 160 160 160 160 160 160
	   160 160 160 ?,L!(B  160 160 160 160 160 160 160 160 160 160 160 160
	   ?,Ln(B  ?,LP(B  ?,LQ(B  ?,Lf(B  ?,LT(B  ?,LU(B  ?,Ld(B  ?,LS(B  ?,Le(B  ?,LX(B  ?,LY(B  ?,LZ(B  ?,L[(B  ?,L\(B  ?,L](B  ?,L^(B 
	   ?,L_(B  ?,Lo(B  ?,L`(B  ?,La(B  ?,Lb(B  ?,Lc(B  ?,LV(B  ?,LR(B  ?,Ll(B  ?,Lk(B  ?,LW(B  ?,Lh(B  ?,Lm(B  ?,Li(B  ?,Lg(B  ?,Lj(B 
	   ?,LN(B  ?,L0(B  ?,L1(B  ?,LF(B  ?,L4(B  ?,L5(B  ?,LD(B  ?,L3(B  ?,LE(B  ?,L8(B  ?,L9(B  ?,L:(B  ?,L;(B  ?,L<(B  ?,L=(B  ?,L>(B 
	   ?,L?(B  ?,LO(B  ?,L@(B  ?,LA(B  ?,LB(B  ?,LC(B  ?,L6(B  ?,L2(B  ?,LL(B  ?,LK(B  ?,L7(B  ?,LH(B  ?,LM(B  ?,LI(B  ?,LG(B  ?,LJ(B ]))))
  "CCL program to read KOI8.")

(define-ccl-program ccl-write-koi8
  '(1
    ((read r0)
     (loop
	 (if (r0 != 140)		; lc-crl == 140
	     (write-read-repeat r0)
	   ((read r0)
	    (r0 -= 160)
	    (write-read-repeat
	     r0
	     [160 179 160 160 160 160 160 160 160 160 160 160 160 160 160 160
	      225 226 247 231 228 229 246 250 233 234 235 236 237 238 239 240
	      242 243 244 245 230 232 227 254 251 253 255 249 248 252 224 241
	      193 194 215 199 196 197 214 218 201 202 203 204 205 206 207 208
	      210 211 212 213 198 200 195 222 219 221 223 217 216 220 192 209
	      160 163 160 160 160 160 160 160 160 160 160 160 160 160 160 160])
	    )))))
  "CCL program to write KOI8.")
	     
(make-coding-system
 '*koi8* 4
 ?K "Coding-system used for KOI8."
 t
 (cons ccl-read-koi8 ccl-write-koi8))

(define-ccl-program ccl-x-koi8
  '(0
    ((r1 -= 160)
     (r1 = r1
      [160 179 160 160 160 160 160 160 160 160 160 160 160 160 160 160
       225 226 247 231 228 229 246 250 233 234 235 236 237 238 239 240
       242 243 244 245 230 232 227 254 251 253 255 249 248 252 224 241
       193 194 215 199 196 197 214 218 201 202 203 204 205 206 207 208
       210 211 212 213 198 200 195 222 219 221 223 217 216 220 192 209
       160 163 160 160 160 160 160 160 160 160 160 160 160 160 160 160
       ])))
  "CCL program to convert chars of lc-crl to KOI font.")

(defun set-cyrillic-environment-koi8 ()
  "Make KOI8 the default character set for cyrillic."
  (setq *coding-category-iso-8-1* '*koi8*)

  (set-coding-priority
   '(*coding-category-iso-8-1*
     *coding-category-iso-8-2*))

  (set-default-file-coding-system '*koi8*)
  (set-display-coding-system '*koi8*)

  (setq-default quail-current-package (assoc "yawerty" quail-package-alist))

  (if (fboundp 'x-synchronize)
      (x-set-ccl lc-crl ccl-x-koi8))
  )
