;; Loaded while creating/installing Mule.
;; Copyright (C) 1992 Free Software Foundation, Inc.
;; This file is part of Mule (MULtilingual Enhancement of GNU Emacs).

;; Mule is free software distributed in the form of patches to GNU Emacs.
;; You can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 1, or (at your option)
;; any later version.

;; Mule is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; 92.3.16  created for Mule Ver.0.9.0 by K.Handa <handa@etl.go.jp>
;;; 92.4.6   modified for Mule Ver.0.9.3 by K.Handa <handa@etl.go.jp>
;;;	Files to be byte-compiled are supplied by command line args.
;;;	Load .el file instead of .elc file if it is patched.
;;; 92.7.27  modified for Mule Ver.0.9.5 by K.Handa <handa@etl.go.jp>
;;;	purify-flag is set to nil.
;;; 92.11.22 modified for Mule Ver.0.9.7 by K.Handa <handa@etl.go.jp>
;;;	Original mule-bytecomp.el and dump-charsets (in mult-util.el)
;;;	is merged into this file.
;;; 93.2.11  modified for Mule Ver.0.9.7.1 by S.Tatsukawa <tatsu_s@ch.hp.com>
;;;	version.el is loaded for bytecompe 2.05.

;; Byte compile all files which are patched or created for Mule

(defun load-necessary-files ()
  (message "Loading necessary files for byte-compile...")
  (load "subr")
  (load "version")
  (load "byte-run")
  (load "loaddefs.el")
  (garbage-collect)
  (setq purify-flag nil)
  (load "mule.el")
  (load "mule-conf.el")
  (load "simple.el")
  (load "files.el")
  (garbage-collect)
  (load "replace.el")
  (load "lisp" nil)
  (load "page" nil)
  (load "paragraphs" nil)
  (load "lisp-mode" nil)
  (load "bytecomp.el" nil)
  (garbage-collect)
  )

;(setq purify-flag nil)

(let ((args command-line-args)
      (command-line-args-left nil))
  (while (and args (null (string-match "mule-inst" (car args))))
    (setq args (cdr args)))
  (setq args (cdr args))
  (while args
    (if (string-match "\\.elc$" (car args))
	(let ((el (substring (car args) 0 -1)))
	  (if (file-newer-than-file-p el (car args))
	      (setq command-line-args-left
		    (cons el command-line-args-left))))
      (if (string-match "quail/.*\\.el$" (car args))
	  (let ((elc (concat (car args) "c")))
	    (if (file-newer-than-file-p (car args) elc)
		(setq command-line-args-left
		      (cons (car args) command-line-args-left))))))
    (setq args (cdr args)))
  (if (null command-line-args-left)
      (kill-emacs 0)
    (load-necessary-files)
    (setq command-line-args-left (nreverse command-line-args-left))
    (batch-byte-compile)))
