/*
 * $Id: jllib.h,v 2.19 1995/03/20 09:43:53 kaneda Exp $
 */

/***************************************************************
 *   (C) Copyright OMRON Corporation 1995, all rights reserved *
 ***************************************************************/
/*
 *    ܥեȥϡʳˤWnnȤ˺
 *  Wnn6(ȯFI-Wnn)ȤʳˤʪǤ
 *   äơʲWnn˴ؤ˹餺ʳˤ
 * ˤʤˤϡܥեȥʣݰơۤʤɤΤä
 * ԰٤ϹԤޤ
 */

/* Wnn Software :
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that all of the following conditions are satisfied:
 *
 * 1) Both the above copyright notices and this permission notice appear
 *    in all supporting documentation and in all copies of this software.
 * 2) The name of "Wnn" isn't changed unless substantial modifications
 *    are made, or
 * 2') Following words followed by the above copyright notices appear
 *    in all supporting documentation of software based on "Wnn" and in all
 *    copies of software based on "Wnn":
 *
 *   "This software is based on the original version of Wnn developed by
 *    Kyoto University Research Institute for Mathematical Sciences (KURIMS),
 *    OMRON Corporation and ASTEC Inc."
 *
 * 3) The names KURIMS, OMRON and ASTEC not be used in advertising or
 *    publicity pertaining to distribution of the software without
 *    specific, written prior permission
 *
 * KURIMS, OMRON and ASTEC make no representations about the suitability
 * of this software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * Wnn consortium is one of distributors of the official Wnn source code
 * release.  Wnn consortium also makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * KURIMS, OMRON, ASTEC AND WNN CONSORTIUM DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LMITATION, ALL IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL 
 * KURIMS, OMRON, ASTEC OR WNN CONSORTIUM BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * The above whole terms and conditions are based on the agreement by
 * KURIMS, OMRON and ASTEC.
 *
 * END OF PERMISSION NOTICE
 */

/*	Version 4.0
 */
/*
	Nihongo	Henkan	Library Header File
*/

#ifndef _JLLIB_H_
#define _JLLIB_H_

#include "jslib.h"

/*
   桼ץϡľܤι¤ΤƤ򥢥ɬפ̵Ϥ
   饤֥ؿѤ뤳ȡ
*/

#define WNN_YOMI_SIZE 10

typedef struct wnn_jl_bun WNN_BUN;

struct wnn_jl_bun {
	int	jirilen;	/* ʸμΩ */
	int	dic_no;
	int	entry;
	int	kangovect;	/* ³٥ȥơ֥ؤΥݥ */
	int	hinsi;		/* ʻ */
	int	fukugou;	/* ʣͥѴ */
	int     num_hinsi;      /* ʻѴǻѤʻο */
	int	*hinsi_list;	/* ʻѴǻѤʻֹꥹ */
	int	hindo  :16;		/* () */
	int	ref_cnt :4;		/* ʸꥹȤ˻ȤƤ */
	/* BUG FIX signed --> unsigned */
	unsigned int ima :1;		/* Ȥäӥå */
	unsigned int hindo_updated :1;    /* ʸ٤ϹƤ */
	unsigned int nobi_top :1;	/* Ф̤ߤԤä򼨤*/
	/* egg ߤ˿Ф̤ߤ򷫤֤Ԥˡ˸κ
	   Ȥä ӥåȤ ȤƤϤʤʤ*/
	unsigned int dai_top :1;	/* ʸƬ */
	unsigned int dai_end :1; /* ʸsaigo *//*  nomi */
	unsigned int from_zenkouho :3;	/*䤫򤵤줿ʸᤫɤ */
	unsigned int bug :1;			/* BUG FIX Ȥꤢ */
	/* BUG FIX signed --> unsigned */
	int 	hyoka;
	int 	daihyoka;
	short yomilen;
	short kanjilen;
	short real_kanjilen;
	WNN_BUN *down; /* ȤäӥåȤȤоݤʸ */
	w_char   yomi[WNN_YOMI_SIZE];        /* ɤߡ롣ڤʤˤ
				    ˤĤʤ */
	WNN_BUN *next;		/* Υȥ饯ȤؤΥݥ */
	WNN_BUN *free_next;		/* Υȥ饯ȤؤΥݥ */
};
    

struct wnn_buf {
    struct wnn_env *env;	/* Ķ */
    int bun_suu;		/* ʸ */
    int zenkouho_suu;		/* ο */
    WNN_BUN **bun;		/* ʸؤΥݥ */
    WNN_BUN **down_bnst; /* ȤäӥåȤȤоݤʸ */

    WNN_BUN **zenkouho;		/* ؤΥݥ */
    int *zenkouho_dai;		/* daibunsetsu zenkouho */
    int zenkouho_dai_suu;	/* daibunsetsu zenkouho suu */

    short c_zenkouho;		/* 桢ܤƤ */
    short zenkouho_daip;
    int zenkouho_bun;		/* äƤʸ */
    int zenkouho_end_bun;	/* (dai)äƤǸʸ */
    int zenkouho_endvect;	/* ä endvect *//* ADD KURI */
    
    WNN_BUN *free_heap;
    char *heap;		/* linked list of alloced area */
    int msize_bun;
    int msize_zenkouho;
    struct _WnnAutoTune *at;

    /*
     * Hideyuki Kishiba (Sep. 20, 1994)
     * ѣƣɴطѹ¤ΤФ˲ä
     */
    struct wnn_fi_rel_buf fi_rb;

    /* 
     * Hideyuki Kishiba (Nov. 24, 1994)
     * ľ˳ꤷʸФƤ
     */
   struct wnn_prev_bun prev_bun[WNN_PREV_BUN_SUU];
};


#define WNN_SHO 0
#define WNN_DAI 1
#define WNN_IKEIJI 2

#define WNN_ZIP 1
#define WNN_TEL 2
#define WNN_TANKAN 3

#define WNN_NO_USE    0
#define WNN_USE_MAE   1
#define WNN_USE_ATO   2
#define WNN_USE_ZENGO (WNN_USE_MAE | WNN_USE_ATO)
/* #define WNN_ZENGO_YUUSEN 4 */

#define WNN_UNIQ_KNJ 2
#define WNN_UNIQ 1
#define WNN_NO_UNIQ  0

#define WNN_NO_CREATE 0
#define WNN_CREATE (-1)

#define WNN_DIC_PRIO_DEFAULT 5

#define WNN_YOMI 0
#define WNN_KANJI 1

#define WNN_KATAKANA_LEARNING_LEN	3	/* minimum length of auto
						   learning katakana	*/

#define jl_next(buf) jl_set_jikouho((buf), (buf)->c_zenkouho + 1)

#define jl_previous(buf) jl_set_jikouho((buf), (buf)->c_zenkouho - 1)

#define jl_next_dai(buf) jl_set_jikouho_dai((buf), (buf)->c_zenkouho + 1)

#define jl_previous_dai(buf) jl_set_jikouho_dai((buf), (buf)->c_zenkouho - 1)

#define jl_get_kanji(buf, bun_no, bun_no2, area)\
                   wnn_get_area(buf, bun_no, bun_no2, area, WNN_KANJI)

#define jl_get_yomi(buf, bun_no, bun_no2, area)\
                   wnn_get_area(buf, bun_no, bun_no2, area, WNN_YOMI)

#define jl_fuzoku_len(buf, k) \
		(jl_yomi_len((buf), k, k+1) - jl_jiri_len((buf), k))

#define jl_jiri_kanji_len(buf, k) \
		(jl_kanji_len((buf), k, k+1) - jl_fuzoku_len((buf), k))

/* Macros to create library functions from "_e" libraries */

/* for select server by useing $LANG */
#define	jl_open(env_n, server_n, wnnrc_n, error_handler, message_handler, timeout) \
    jl_open_lang(env_n, server_n, NULL, wnnrc_n, error_handler, message_handler, timeout)

#define	jl_connect(env_n, server_n, wnnrc_n, error_handler, message_handler, timeout) \
    jl_connect_lang(env_n, server_n, NULL, wnnrc_n, error_handler, message_handler, timeout)

/* extern function defines */
extern struct wnn_buf *jl_open_lang();
extern struct wnn_env *jl_connect_lang();
extern struct wnn_env *jl_env_get();
extern struct wnn_jdata *jl_word_info_e();
extern w_char *jl_hinsi_name_e();

extern void jl_close();
extern int jl_dic_add_e();
extern int jl_dic_comment_set_e();
extern int jl_dic_delete_e();
extern int jl_dic_list_e();
extern int jl_dic_save_all_e();
extern int jl_dic_save_e();
extern int jl_dic_use_e();
extern void jl_disconnect();
extern void jl_disconnect_if_server_dead();
extern void jl_env_set();
extern int jl_fuzokugo_get_e();
extern int jl_fuzokugo_set_e();
extern void jl_get_zenkouho_kanji();
extern int jl_hinsi_dicts_e();
extern int jl_hinsi_list_e();
extern int jl_hinsi_number_e();
extern int jl_isconnect_e();
extern int jl_kanji_len();
extern int jl_kill();
extern int jl_nobi_conv();
extern int jl_nobi_conv_e2();
extern int jl_param_get_e();
extern int jl_param_set_e();
extern int jl_ren_conv();
extern int jl_set_env_wnnrc();
extern int jl_set_env_wnnrc1();
extern int jl_set_jikouho();
extern int jl_set_jikouho_dai();
extern int jl_tan_conv();
extern int jl_update_hindo();
extern int jl_word_add_e();
extern int jl_word_comment_set_e();
extern int jl_word_delete_e();
extern int jl_word_search_by_env_e();
extern int jl_word_search_e();
extern int jl_word_use_e();
extern int jl_yomi_len();
extern int jl_zenkouho();
extern int jl_zenkouho_dai();
extern int wnn_get_area();

extern int jl_isconnect();
extern int jl_dic_add();
extern int jl_dic_delete();
extern int jl_fuzokugo_set();
extern int jl_fuzokugo_get();
extern int jl_dic_save();
extern int jl_dic_save_all();
extern struct wnn_jdata *jl_word_info();
extern int jl_dic_list();
extern int jl_word_search();
extern int jl_word_search_by_env();
extern int jl_word_use();
extern int jl_param_set();
extern int jl_param_get();
extern int jl_dic_use();
extern int jl_word_add();
extern int jl_word_delete();
extern int jl_hinsi_number();
extern w_char *jl_hinsi_name();
extern int jl_hinsi_list();
extern int jl_hinsi_dicts();
extern int jl_word_comment_set();
extern int jl_dic_comment_set();
extern struct wnn_jdata *jl_inspect();
extern int jl_env_sticky_e();
extern int jl_env_sticky();
extern int jl_env_un_sticky_e();
extern int jl_env_un_sticky();
extern char *jl_get_lang();
#ifdef nodef
extern int jl_hindo_comment_set();
extern void jl_set_lang();
#endif
extern int jl_bun_suu();
extern int jl_zenkouho_suu();
extern int jl_zenkouho_bun();
extern int jl_c_zenkouho();
extern int jl_zenkouho_daip();
extern int jl_dai_top();
extern int jl_jiri_len();
extern struct wnn_env *jl_env();

extern int jl_get_wnn_errorno_env();
extern int jl_get_wnn_errorno_buf();
extern int jl_tan_conv_hinsi_flag();
extern int jl_nobi_conv_hinsi_flag();
extern int jl_zenkouho_hinsi_flag();
extern int jl_zenkouho_dai_hinsi_flag();
extern int jl_ren_conv_with_hinsi_name();
extern int jl_tan_conv_with_hinsi_name();
extern int jl_nobi_conv_with_hinsi_name();
extern int jl_zenkouho_with_hinsi_name();
extern int jl_zenkouho_dai_with_hinsi_name();

extern int jl_set_henkan_env_e();
extern int jl_set_henkan_env();
extern int jl_get_henkan_env_e();
extern int jl_get_henkan_env();
extern int jl_get_henkan_env_local_e();
extern int jl_get_henkan_env_local();
extern int jl_set_henkan_hinsi_e();
extern int jl_set_henkan_hinsi();
extern int jl_get_henkan_hinsi_e();
extern int jl_get_henkan_hinsi();

extern int jl_autotune_open();
extern int jl_autotune_close();
extern int jl_autotune_load();
extern int jl_autotune_save();
extern int jl_autotune_start();
extern int jl_autotune_end();

/*
 * Hideyuki Kishiba (Jul. 8, 1994)
 * New jl_lib functions for FI-Wnn
 */
extern int jl_fi_dic_add_e();
extern int jl_fi_dic_add();

extern int jl_fi_ren_conv();
extern int jl_fi_nobi_conv();
extern int jl_optimize_fi();
extern int jl_reset_prev_bun();

extern int jl_fi_dic_list_e();
extern int jl_fi_dic_list();
extern int jl_fuzokugo_list_e();
extern int jl_fuzokugo_list();
extern int jl_free();

extern char *wnn_perror();
extern char *wnn_perror_lang();

#ifdef  CONVERT_by_STROKE
extern void jl_get_zenkouho_yomi();
#endif

extern int jl_zenikeiji_dai();
extern int jl_set_ikeiji_dai();

#endif	/* _JLLIB_H_ */
