/*
 * $Id: jslib.h,v 2.26 1995/03/22 02:08:01 kaneda Exp $
 */

/***************************************************************
 *   (C) Copyright OMRON Corporation 1995, all rights reserved *
 ***************************************************************/
/*
 *    ܥեȥϡʳˤWnnȤ˺
 *  Wnn6(ȯFI-Wnn)ȤʳˤʪǤ
 *   äơʲWnn˴ؤ˹餺ʳˤ
 * ˤʤˤϡܥեȥʣݰơۤʤɤΤä
 * ԰٤ϹԤޤ
 */

/* Wnn Software :
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that all of the following conditions are satisfied:
 *
 * 1) Both the above copyright notices and this permission notice appear
 *    in all supporting documentation and in all copies of this software.
 * 2) The name of "Wnn" isn't changed unless substantial modifications
 *    are made, or
 * 2') Following words followed by the above copyright notices appear
 *    in all supporting documentation of software based on "Wnn" and in all
 *    copies of software based on "Wnn":
 *
 *   "This software is based on the original version of Wnn developed by
 *    Kyoto University Research Institute for Mathematical Sciences (KURIMS),
 *    OMRON Corporation and ASTEC Inc."
 *
 * 3) The names KURIMS, OMRON and ASTEC not be used in advertising or
 *    publicity pertaining to distribution of the software without
 *    specific, written prior permission
 *
 * KURIMS, OMRON and ASTEC make no representations about the suitability
 * of this software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * Wnn consortium is one of distributors of the official Wnn source code
 * release.  Wnn consortium also makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * KURIMS, OMRON, ASTEC AND WNN CONSORTIUM DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LMITATION, ALL IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL 
 * KURIMS, OMRON, ASTEC OR WNN CONSORTIUM BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * The above whole terms and conditions are based on the agreement by
 * KURIMS, OMRON and ASTEC.
 *
 * END OF PERMISSION NOTICE
 */

/*	Version 4.0
 */
/*
	Nihongo	Henkan	Library Header File
*/
#ifndef	_JSLIB_H_
#define _JSLIB_H_

#ifndef	_WNN_SETJMP
#define	_WNN_SETJMP
#include <setjmp.h>
#endif

#ifndef	w_char
#define	w_char	unsigned short
#endif	/* w_char */

/* ü٥(ʻֹ) */
#define	WNN_BUN_SENTOU	-1	/* ʸƬˤʤ */
#define	WNN_ALL_HINSI	-2	/* ʤǤ⤨ */
/* ü٥ */
#define	WNN_VECT_KANREN	0	/* ϢʸѴνü٥ */
#define	WNN_VECT_KANTAN	1	/* ñʸѴνü٥ */
#define	WNN_VECT_KANZEN	1	/* Фνü٥ 
				   ñʸѴΤΤ*/ 
#define WNN_VECT_BUNSETSU 2     /* ϢʸѴΡʸνü٥*/
#define	WNN_VECT_NO	-1	/* ü٥1 ̵ */
/* ʸνü³ */
#define	WNN_CONNECT_BK	1	/* ꤵ줿ü٥³Ǥ*/
#define	WNN_NOT_CONNECT_BK	0	/* */
/* ʸü³ */
#define	WNN_CONNECT	1	/* ꤵ줿(ʻ졢°)³Ǥ*/
#define	WNN_SENTOU	2	/* ʸƬ */
#define	WNN_NOT_CONNECT	3	/* Ƭˤʤʤ³Ǥʤ */
#define	WNN_GIJI	4	/* ʸä*/

/* ʸľ򤷤 */
#define WNN_HIRAGANA	-1	/* Ҥ餬 *//* ɤߤΤޤ */
#define WNN_KATAKANA	-11	/*  */
#define WNN_IKEIJI_ENTRY	-50	/* ۷ */
/*  */
#define	WNN_NUM_HAN	-2	/* Ⱦѿ *//* ɤߤΤޤ */
#define	WNN_NUM_ZEN	-12	/* ѿ *//*  */
#define	WNN_NUM_KAN	-13	/*  *//*  */
#define	WNN_NUM_KANSUUJI -15	/*  *//* ɴ󽽻 */
#define	WNN_NUM_KANOLD	-16	/*  *//* ɴ */
#define	WNN_NUM_HANCAN	-17	/* Ⱦѿ *//* 1,234 */
#define	WNN_NUM_ZENCAN	-18	/* ѿ *//*  */
/* ѿ */
#define	WNN_ALP_HAN	-4	/* Ⱦ *//* ɤߤΤޤ */
#define	WNN_ALP_ZEN	-30	/*  */
/*  */
#define	WNN_KIG_HAN	-5	/* Ⱦ *//* ɤߤΤޤ */
#define	WNN_KIG_JIS	-40	/* (JIS) */
#define	WNN_KIG_ASC	-41	/* (ASC) */
/*  */
#define WNN_OKURI_REGULATION -1	/* § */
#define WNN_OKURI_NO 	0	/* ʤ */
#define	WNN_OKURI_YES	1	/*  */
/* Ѵ */
#define WNN_KANA_KOUHO	0	/* Ҥ餬 */
#define WNN_KANJI_KOUHO	1	/*  */
/* Ѵ */
#define WNN_KANREN 0
#define WNN_KANTAN_DAI 1
#define WNN_KANZEN_DAI 2
#define WNN_KANTAN_SHO 3
#define WNN_KANZEN_SHO 4

/* ۷ Ѵ */
#define WNN_IKEIJI_DAI (WNN_KANZEN_SHO+1)

#define WNN_FT_DICT_FILE 1
#define WNN_FT_HINDO_FILE 2
#define WNN_FT_FUZOKUGO_FILE 3
/*
 * Hideyuki Kishiba (Jul. 8, 1994)
 * New file type for FI-Wnn
 */
#define WNN_FT_FI_DICT_FILE 4
#define WNN_FT_FI_HINDO_FILE 5

#define WNN_STATIC_DICT 1		/* static dict */
#define WNN_UD_DICT 2			/* updatable dict */
#define WNN_REV_DICT 3		/* Updatable Dictonary with Reverse Index */
#define WNN_REG_DICT 4		/* Regular Expressino Dictonary */
/*
 * Hideyuki Kishiba (Jul. 8, 1994)
 * New dictionary type for FI-Wnn
 */
#define WNN_COMPACT_DICT 	5	/* ѥȼ */
#define WNN_FI_SYSTEM_DICT 	6	/* ƣɴطƥ༭ */
#define WNN_FI_USER_DICT 	7	/* ƣɴط桼 */
#define WNN_FI_HINDO_FILE 	8	/* ƣɴط */
#define WNN_GROUP_DICT		9	/* 롼׼ */
#define	WNN_MERGE_DICT		10	/* ޡ */

#define WNN_SYSTEM_DICT		0x80000000

/*
 * Seiji KUWARI (Dec. 14, 1994)
 * Numbers of special dictionaries
 */ 
#define WNN_MAEKAKUTEI_DIC	-2
#define WNN_MUHENKAN_DIC	-3
#define WNN_BUNSETSUGIRI_DIC	-4

/* for CHINESE PIN-IN : with Si Sheng () */
#define CWNN_REV_DICT		0x103	/* Updatable with Reverse Index */

/* for CHINESE: Bi Xing (ɮ) */
#define BWNN_REV_DICT		0x203	/* Updatable with Reverse Index */

#define WNN_DIC_MERGE		4	/* for merge dic */
#define WNN_DIC_GROUP		3	/* for group dic */
#define	WNN_DIC_TEMPORARY	2
#define	WNN_DIC_RDONLY	        1
#define	WNN_DIC_RW	        0

#define	WNN_DIC_ADD_REV 1	/* Ѵ */
#define	WNN_DIC_ADD_NOR 0	/* ̾Ѵ */

/* header file for dic_syurui */
#define WNN_FILE_NOT_EXIST -1
#define WNN_NOT_A_JISHO 0
/* KURI
#define WNN_USER_DIC 1
#define WNN_SYSTEM_DIC 3
*/
#define WNN_HINDO_FILE 4
#define WNN_FUZOKUGO_FILE 5

/* set_hindo operation */
#define WNN_HINDO_NOP -2
#define WNN_IMA_ON -3
#define WNN_IMA_OFF -4
#define WNN_HINDO_INC -3
#define WNN_HINDO_DECL -4
#define WNN_ENTRY_NO_USE -1

/* set hindo probability */
#define WNN_HINDO_NOT    0
#define WNN_HINDO_ALWAYS 1
#define WNN_HINDO_HIGH   2
#define WNN_HINDO_NORMAL 3
#define WNN_HINDO_LOW    4

/* Auto learning operation */
#define WNN_MUHENKAN_LEARNING		1
#define WNN_BUNSETSUGIRI_LEARNING	2

#define WNN_NO_LEARNING		-1
#define WNN_TEMPORARY_LEARNING	-2

/*	Wnn constant
*/
#define WNN_HOSTLEN 16
#define WNN_ENVNAME_LEN 32

/*	js_who	*/
#define WNN_MAX_ENV_OF_A_CLIENT 32

struct wnn_jwho {
	int sd;   /* jserver Υåȥǥץ*/
	char user_name[64];   /* 桼̾ */
	char host_name[64];   /* ۥ̾ */
	int  env[WNN_MAX_ENV_OF_A_CLIENT];  /* Υ饤ȤѤƤ
				Ķֹ󡣶ƤȤˤϡ-1  */
};
typedef struct wnn_jwho WNN_JWHO;

/*	js_env_list	*/
#define WNN_MAX_JISHO_OF_AN_ENV 30
#define WNN_MAX_FILE_OF_AN_ENV 60

 struct wnn_env_info {
        int	env_id;		/* Ķֹ */
	char	env_name[WNN_ENVNAME_LEN]; /* Ķ̾ */
	int	ref_count;	/* ȿ */
	/* struct wnn_param; */
	int	fzk_fid;	/* °Υեֹ */
	int jishomax;		/* ѤƤ뼭θĿ */
	int	jisho[WNN_MAX_JISHO_OF_AN_ENV];	/* ѤƤ뼭μֹ档
					   ǽjishomaxḤ̂ */
	int	file[WNN_MAX_FILE_OF_AN_ENV]; /* δĶˤĤʤäƤ
				 եֹ(ƤȤˤϡ-1 ) */
};
typedef struct wnn_env_info WNN_ENV_INFO;

#define WNN_COMMENT_LEN 512     /* jisho no comment no nagasa */
#define WNN_F_NAMELEN 256
#define WNN_PASSWD_LEN 16  /* File Passwd Length */


struct wnn_dic_info {
	int dic_no;		/* ֹ */
	int body;		/* ΤΥեֹ */
	int hindo;		/* ٤Υեֹ */
	int rw;			/* Ͽǽɤ
				   (WNN_DIC_RW, WNN_DIC_RDONLY) */
	int hindo_rw;		/* ٤ǽɤ
				   (WNN_DIC_RW, WNN_DIC_RDONLY) */
	int enablef;		/* 񤬻椫ɤ
				   (1 = , 0 = ) */
	int nice;		/* Ѵͥ */
	int rev;		/* Ѵɤ(1 = Ѵ, 0 = Ѵ) */
/* added H.T */
	w_char comment[WNN_COMMENT_LEN];	/* Υ */
	char fname[WNN_F_NAMELEN]; /* Υե̾ */
	char hfname[WNN_F_NAMELEN]; /* ٤Υե̾ */
	char passwd[WNN_PASSWD_LEN]; /* Υѥ */
	char hpasswd[WNN_PASSWD_LEN]; /* ٤Υѥ */
	int type;		/* μ(WNN_UD_DICT,WNN_STATIC_DICT) */
	int gosuu;		/* θ */
	int localf;
	int hlocalf;
};

typedef struct wnn_dic_info WNN_DIC_INFO;

/* Hideyuki Kishiba (Dec. 1, 1994)
   °եѹ¤ */
struct wnn_fzk_info {
        w_char	comment[WNN_COMMENT_LEN];	/* °Υ */
	char	fname[WNN_F_NAMELEN];		/* °Υե̾ */
};

typedef struct wnn_fzk_info WNN_FZK_INFO;

struct wnn_file_stat {
    int type;			/* եμ
		WNN_STATIC_DICT		
		WNN_UD_DICT		Ͽǽ
		WNN_HINDO_FILE		٥ե
		WNN_FUZOKUGO_FILE	°ե
		WNN_NOT_A_JISHO		¾   */
};

typedef struct wnn_file_stat WNN_FILE_STAT;

/*	*/
extern	int	wnn_errorno;		/* WnnΥ顼Ϥѿ𤵤 */

extern char *wnn_dic_types[];	/* "","Ͽ","Ѵ","" */

extern char *cwnn_dic_types[];	/* "","Ͽ","Ѵ","" */
extern char *bwnn_dic_types[];	/* "","Ͽ","Ѵ","" */

#define FILE_ALREADY_READ -2

/* ι¤Τϡ饤֥Ѥ */
struct wnn_jserver_id {
	int	sd;
	char	js_name[40];
	int	js_dead;
	jmp_buf js_dead_env;	/* ФǤenv */
	int	js_dead_env_flg; /* jd_server_dead_envͭݤ  */
};

typedef struct wnn_jserver_id WNN_JSERVER_ID;

/* ι¤Τϡ饤֥Ѥ */
struct wnn_env {
	int		env_id;
	WNN_JSERVER_ID	*js_id;
	char		lang[16];	/* for exsample "ja_JP" */
	int		muhenkan_mode;
	int		bunsetsugiri_mode;
	int		kutouten_mode;
	int		kakko_mode;
	int		kigou_mode;
	int             autotune;
};

typedef struct wnn_env WNN_ENV;

struct wnn_param {
	int	n;	/* ()ʸϤΣ */
	int	nsho;	/* ʸξʸκ */
	int 	p1;	/* Ω٤Υѥ᡼ */
	int 	p2;	/* ʸĹΥѥ᡼ */
	int 	p3;	/* ΩĹΥѥ᡼ */
	int 	p4;	/* ȤäӥåȤΥѥ᡼ */
	int 	p5;	/* Υѥ᡼ */
	int	p6;	/* ʸɾͤΥѥ᡼ */
	int	p7;	/* ʸĹΥѥ᡼ */
	int	p8;	/* ʸΥѥ᡼ */
	int 	p9;	/* ʻ  */
	int 	p10;	/* ʻ ʤ *//* CWNN:ѿ */
	int 	p11;	/* ʻ ѿ *//* CWNN: */
	int 	p12;	/* ʻ  *//* CWNN:̤ */
	int 	p13;	/* ʻ ĳ̤ *//* CWNN:ĳ̤ */
	int 	p14;	/* ʻ ° *//* BWNN:No of koho */
	int 	p15;	/* ʻ ̤ *//* CWNN:Not used */
};

#define WNN_ENV_LAST_IS_FIRST_MASK      (1<<0)
#define WNN_ENV_COMPLEX_CONV_MASK       (1<<1)
#define WNN_ENV_OKURI_LEARN_MASK        (1<<2)
#define WNN_ENV_OKURI_MASK              (1<<3)
#define WNN_ENV_PREFIX_LEARN_MASK       (1<<4)
#define WNN_ENV_PREFIX_MASK             (1<<5)
#define WNN_ENV_SUFFIX_LEARN_MASK       (1<<6)
#define WNN_ENV_COMMON_LAERN_MASK       (1<<7)
#define WNN_ENV_FREQ_FUNC_MASK          (1<<8)
#define WNN_ENV_NUMERIC_MASK            (1<<9)
#define WNN_ENV_ALPHABET_MASK           (1<<10)
#define WNN_ENV_SYMBOL_MASK             (1<<11)
#define WNN_ENV_YURAGI_MASK		(1<<12)
#define WNN_ENV_RENDAKU_MASK		(1<<13)
#define WNN_ENV_BUNSETSUGIRI_LEARN_MASK (1<<14)
#define WNN_ENV_MUHENKAN_LEARN_MASK     (1<<15)
#define WNN_ENV_FI_RELATION_LEARN_MASK	(1<<16)
#define WNN_ENV_FI_FREQ_FUNC_MASK	(1<<17)
#define WNN_ENV_KUTOUTEN_MASK		(1<<18)
#define WNN_ENV_KAKKO_MASK		(1<<19)
#define WNN_ENV_KIGOU_MASK		(1<<20)

struct wnn_henkan_env {
        int     last_is_first_flag;     /* ǽѺͥ */
        int     complex_flag;           /* ʣͥ */
        int     okuri_learn_flag;       /* ؽ */
        int     okuri_flag;             /*  */
        int     prefix_learn_flag;      /* Ƭؽ */
        int     prefix_flag;            /* Ƭ */
        int     suffix_learn_flag;      /* ؽ */
        int     common_learn_flag;      /* Ѹؽ */
        int     freq_func_flag;         /* پ徺Ψؿ */
        int     numeric_flag;           /* νɽˡ */
        int     alphabet_flag;          /* ե٥åȤνɽˡ */
        int     symbol_flag;            /* νɽˡ */
	/*
	 * FI-Wnn ɲʬ 
	 * WATANABE Yasuhisa (Oct. 14, 1994)
	 */
	int	yuragi_flag;		/* Ĺ餮 */

	int	rendaku_flag;		/* Ϣ */
        int     bunsetsugiri_flag;      /* ʸڤؽ */
        int     muhenkan_flag;          /* ̵Ѵؽ */
	int	fi_relation_learn_flag;	/* ƣɴطؽ */
	int	fi_freq_func_flag;	/* ƣɴطپ徺Ψؿ */
	/*
	 * FI-Wnn ɲʬ
	 * Seiji KUWARI (Nov. 28, 1994)
	 */
	int	kutouten_flag;		/*  */
	int	kakko_flag;		/*  */
	int	kigou_flag;		/*  */
};

/* dictionary type bit mask for js_fi_dic_list[_all] */
#define WNN_DIC_WNN_SYSTEM_MASK	(1<<0)
#define WNN_DIC_WNN_USER_MASK	(1<<1)
#define WNN_DIC_FI_SYSTEM_MASK	(1<<2)
#define WNN_DIC_FI_USER_MASK	(1<<3)
#define WNN_DIC_BUNSETSU_MASK  	(1<<4)
#define WNN_DIC_MUHENKAN_MASK 	(1<<5)
#define WNN_DIC_TEMPORARY_MASK  (1<<6)
#define WNN_DIC_NO_AUTOLEARN_MASK \
    (WNN_DIC_WNN_SYSTEM_MASK | WNN_DIC_WNN_USER_MASK)
#define WNN_DIC_AUTOLEARN_MASK \
    (WNN_DIC_BUNSETSU_MASK | WNN_DIC_MUHENKAN_MASK | WNN_DIC_TEMPORARY_MASK)
#define WNN_DIC_WNN_ALL_MASK \
    (WNN_DIC_NO_AUTOLEARN_MASK | WNN_DIC_AUTOLEARN_MASK)
#define WNN_DIC_FI_ALL_MASK \
    (WNN_DIC_FI_SYSTEM_MASK | WNN_DIC_FI_USER_MASK)
#define WNN_DIC_ALL_MASK \
    (WNN_DIC_WNN_ALL_MASK | WNN_DIC_FI_ALL_MASK)

#ifdef nodef
struct wnn_dic_info_struct {
	int	body_fid;
	int	hindo_fid;
	int	enablef;
	int	rw;
	int     hindo_rw;
	int	nice;
};

typedef struct wnn_dic_info_struct WNN_DIC_INFO_STRUCT;
#endif

struct wnn_file_info_struct {
	int	fid;		/* եֹ */
	char	name[WNN_F_NAMELEN]; /* ե̾ */
	int	localf;		/* СȤΥե뤫ɤ
				   1: С
				   0: 饤ȡ   */
	int	type;		/* եμ */
	int	ref_count;	/* (Ķ)ȿ */
};

typedef struct wnn_file_info_struct WNN_FILE_INFO_STRUCT;

#define WNN_VECT_L	((256+8*4-1)/(8*4) + 5)	/***** !!!!! ****/

struct	wnn_sho_bunsetsu {
	int	end;		/* ʸ end char index */
	int	start;		/* ʸ top char index */
	int	jiriend;	/* ʸμΩ end char index */
	int	dic_no;		/* ΩμΥȥֹ */
	int	entry;		/* ʸμΩ켭 entry */

	int	hinsi;		/* Ωʻ */
	int     status;		/* ʸƬ */
	int	status_bkwd;	/* usiro ʸ³Ǥ뤫 */
	int 	hindo;		/* 伫Ω */ 
	int 	ima;		/* 伫ΩκȤäӥå */ 
	int	kangovect;	/* ³٥ȥơ֥ؤΥݥ */
	int 	hyoka;		/* ʸɾ */
	w_char	*kanji;		/* Ωʸ */
	w_char	*yomi;		/* Ωɤʸ */
	w_char	*fuzoku;	/* °ʸ */
/*
 *٤ˤĤƤϡ٥ե뤬ꤵƤϡ
 *hindo = ٥ե() + ()
 *ima = ٥եκȤäӥå
 *
 *٥ե뤬ꤵƤʤˤϡ
 *hindo = ()͡ima = κȤäӥå
 *Ǥ롣ǡͤȤϡ׻7ӥåȤ˰̤줿ͤǤ롣
 *ͤǤϤʤ֤ͤΤϡѴ̤ΥǥХåΤǤ롣
 */
};

struct	wnn_dai_bunsetsu {
	int	end;		/* ʸ end char index */
	int	start;		/* ʸ top char index */
	struct	wnn_sho_bunsetsu	*sbn;	/* ʸϷ̤ؤΥݥ */
	int 	hyoka;		/* ʸɾ */
	int	sbncnt;		/* ʸ (ξϡ)
				   DSD_SBNϡ*sbn  sbncnt  */
};

struct	wnn_jdata {
	int	dic_no;		/* ֹ */
	int	serial;		/* Υȥֹ */
	int	hinshi;		/* ʻֹ(ʻֹʻ̾бϡmanual/etc
				   β򻲾) */
	int	hindo;		/*  */
	int	ima;		/* Ȥäӥå */
	int	int_hindo;	/*  */
	int	int_ima;	/* ⡢Ȥäӥå */
	w_char   *yomi;		/* ɤߤʸ */
	w_char	*kanji;		/* ʸ */
	w_char	*com;		/* ȥΥʸ */
/*
 *٤ˤĤƤϡ٥ե뤬ꤵƤϡ
 *hindo = ٥ե()͡ima = ٥եκȤäӥå
 *int_hindo = ()͡int_ima = κȤäӥå
 *
 *٥ե뤬ꤵƤʤˤϡ
 *hindo = ()͡ima = κȤäӥå
 *int_hindo = -1int_ima = -1
 *
 *ɤξǤ⡢ȥ꤬ߤξ֤λˤϡ
 *hindo = -1, ima = 0 뤤ϡ
 *int_hindo = -1, int_ima = 0 Ȥʤ롣
 *ǡ()ͤȤϡ׻7ӥåȤ˰̤줿ͤ顢
 *ºݤͤꤷͤǤ롣
 */
};

struct	wnn_ret_buf {
	int	size;		/* buf  alloc Ƥ礭 */
	char	*buf;		/* malloc ʤɤǤȤ줿ΰ */
};

/*
 * Hideyuki Kishiba (Sep. 20, 1994)
 * ѣƣɴطѹ¤Τ
 */
struct  fi_rel_data {
    int		fi_dic_no;	/* ƣɴطμֹ */
    int		dic_no;		/* ³μֹ */
    int		entry;		/* ³Υȥֹ */
    int		offset;		/* ƣɴطǡΥեåֹ */
    int		fi_hindo;	/* ƣɴط³٤ */
    int		fi_ima;		/* ƣɴط³ӥåȤ */
};

typedef struct fi_rel_data FI_PRIO_DATA;

/*
 * Hideyuki Kishiba (Sep. 20, 1994)
 * ѣƣɴطѹ¤Τ
 */
struct wnn_fi_rel_buf {
    int		       size;	 /* alloc Ƥƣɴطǡ */
    int		       num;	 /* ͭƣɴطǡ */
    struct fi_rel_data *fi_buf;  /* ƣɴطǡ¤ؤΥݥ */
};

/*
 * Hideyuki Kishiba (Nov. 24, 1994)
 * ƣѴѹ¤Τ
 */
#define WNN_PREV_BUN_SUU 2  /* ФƤľʸ */

/* ľ˳ꤷʸγƾФƤ¤ */
struct wnn_prev_bun {
    int         dic_no;                 /* Wnn ֹ */
    int         entry;                  /* ȥֹ */
#ifndef JSERVER
    int         real_kanjilen;          /* ʸ°ʤ*/
#endif /* !JSERVER */
    w_char      kouho[256];    		/* ʸ°줢
					   256 == LENGTHKANJI */
    int         jirilen;                /* ΩɤĹ */
    int         hinsi;                  /* ʻ */
};


#define	WNN_F_UNIQ_LEN	(sizeof(struct wnn_file_uniq))

/* hinsi name used in jlib and jserver */
#define WNN_HINSI_MEISI		"̾"
#define WNN_HINSI_TANKAN      	"ñ"
#define WNN_HINSI_SUUSI		""
#define WNN_HINSI_SETTOUO	"Ƭ()"
#define WNN_HINSI_SETSUBI	""
#define WNN_HINSI_RENDAKU	"Ϣ"
#define WNN_HINSI_TELNO		"ֹ"
#define WNN_HINSI_ZIPCODE	"͹ֹ"
#define WNN_ROOT_HINSI_NODE	"/"
#define WNN_UNUSE_HINSI		9


/* ι¤Τϡ饤֥Ѥ */
struct wnn_file_head {
  struct wnn_file_uniq{
    int time;
    int dev;
    int inode;
    char createhost[WNN_HOSTLEN];
  } file_uniq;
  struct wnn_file_uniq file_uniq_org;
  int file_type;
  char file_passwd[WNN_PASSWD_LEN];
};

#define WNN_HINSI_NAME_LEN 64

#define	WNN_FILE_HEADER_LEN	(WNN_PASSWD_LEN + 8 + WNN_FILE_STRING_LEN + \
				 sizeof(struct wnn_file_uniq) * 2 + 4)
				/*
				  8 is for future use 
				  4 is for file_type.
				 */

#ifndef	JSERVER
/*
  JSLIB function declaration
*/
#define	js_open(server, timeout)	js_open_lang(server, "ja_JP", timeout)
#define	js_connect(server,env_name)	js_connect_lang(server, env_name, "ja_JP")

extern	WNN_JSERVER_ID *js_open_lang();
extern	unsigned int	dispname_to_ipaddr();
extern	int		js_close();
extern	WNN_JSERVER_ID *js_change_current_jserver();
extern	struct wnn_env *js_connect_lang();
extern	int		js_disconnect();
extern	int		js_env_list();
extern	int		js_param_set();
extern	int		js_param_get();
extern	char	       *js_get_lang();
/**************************************/
extern int js_access();
extern int js_dic_add();
extern int js_dic_delete();
extern int js_dic_file_create();
extern int js_dic_file_create_client();
extern int js_dic_info();
extern int js_dic_list();
extern int js_dic_list_all();
extern int js_dic_use();
extern int js_env_exist();
extern int js_env_sticky();
extern int js_env_un_sticky();
extern int js_file_comment_set();
extern int js_file_discard();
extern int js_file_info();
extern int js_file_list();
extern int js_file_list_all();
extern int js_file_loaded();
extern int js_file_loaded_local();
extern int js_file_password_set();
extern int js_file_read();
extern int js_file_receive();
extern int js_file_remove();
extern int js_file_remove_client();
extern int js_file_send();
extern int js_file_stat();
extern int js_file_write();
extern void js_flush();
extern int js_fuzokugo_get();
extern int js_fuzokugo_set();
extern int js_hindo_file_create();
extern int js_hindo_file_create_client();
extern int js_hindo_set();
extern int js_hinsi_dicts();
extern int js_hinsi_list();
extern int js_hinsi_name();
extern int js_hinsi_number();
extern int js_hinsi_table_set();
extern int js_isconnect();
extern int js_kanren();
extern int js_kantan_dai();
extern int js_kantan_sho();
extern int js_kanzen_dai();
extern int js_kanzen_sho();
extern int js_kill();
extern int js_mkdir();
extern int js_version();
extern int js_who();
extern int js_word_add();
extern int js_word_comment_set();
extern int js_word_delete();
extern int js_word_info();
extern int js_word_search();
extern int js_word_search_by_env();

extern int js_open_extension();
extern int js_get_extension();
extern int js_send_extension();

extern int js_access_add_host();
extern int js_access_remove_host();
extern int js_access_add_user();
extern int js_access_remove_user();
extern int js_access_enable();
extern int js_access_disable();
extern char **js_access_get_info();

extern int js_is_loaded_temporary_dic();
extern int js_temporary_dic_add();
extern int js_temporary_dic_delete();
extern int js_autolearning_word_add();
extern int js_temporary_word_add();

extern int js_set_autolearning_dic();
extern int js_get_autolearning_dic();

extern int js_set_henkan_env();
extern int js_get_henkan_env();
extern int js_get_henkan_env_local();
extern int js_set_henkan_hinsi();
extern int js_get_henkan_hinsi();
extern int js_henkan_with_data();

extern int js_autotune_param_load();
extern int js_autotune_param_save();

/*
 * Hideyuki Kishiba (Jul. 8, 1994)
 * New js_lib functions for FI-Wnn
 */
extern int js_fi_dic_add();
extern int js_fi_hindo_file_create();
extern int js_fi_hindo_file_create_client();

extern int js_fi_kanren();
extern int js_set_fi_priority();
extern int js_optimize_fi();

extern int js_fi_dic_list();
extern int js_fi_dic_list_all();
extern int js_fuzokugo_list();

#endif /* JSERVER */

#endif	/* _JSLIB_H_ */
