/* Interface definitions for display code.
   Copyright (C) 1985, 1993, 1994 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* 89.2.9   modified for Nemacs Ver.3.0 by K.Handa */
/* 89.11.24 modified for attribute of characters by K.Handa */
/*	Currently supported attributes are underline and inverse. */
/* 91.10.19 modified for Nemaacs Ver.4.0.0 by K.Handa (handa@etl.go.jp) */
/* 92.3.6   modified for Mule Ver.0.9.0 by K.Handa <handa@etl.go.jp> */
/*	Now bold-face is also supported. */
/* 92.4.15  modified for Mule Ver.0.9.3 by K.Handa <handa@etl.go.jp>
	Size of message_buf is widen to (screen_width * 3) + 1. */
/* 92.9.8   modified for Mule Ver.0.9.6 by K.Handa <handa@etl.go.jp>
	Format of matrix->contents changed. */
/* 92.10.19 modified for Mule Ver.0.9.6 by K.Handa <handa@etl.go.jp>
	MTRX_COMPOSE should not directly shift str[n]. */
/* 92.11.9  modified for Mule Ver.0.9.7 by K.Handa <handa@etl.go.jp>
	MTRX_CMPCHAR is used to check a composite character. */
/* 93.1.13  modified for Mule Ver.0.9.7.1 by T.Enami <enami@sys.ptg.sony.co.jp>
	MTRX_CMPCHAR should consern DATA_SEG_BITS. */
/* 93.4.11  modified for Mule Ver.0.9.7.1 by K.Handa <handa@etl.go.jp>
	Add MTRX_REV_DIR to highlight anti-direction characters.  */
/* 93.5.22  modified for Mule Ver.0.9.7.1 by Y.Niibe <gniibe@mri.co.jp>
	Merge highlight and double cursor.
	Change the value of MTRX_CMPPTR_MASK for MTRX_REV_DIR.
	Double cursor support. */
/* 93.6.21  modified for Mule Ver.0.9.8 by K.Handa <handa@etl.go.jp>
	Composite chars are stored in cmp_char_table. */

/* 93.5.22 Y.Niibe for double cursor */
#define CURSOR_LEFT        0x0
#define CURSOR_RIGHT       0x1
#define CURSOR_DOUBLE      0x2
extern int cursor_form;
extern int cursor_hpos_rev;
/* end of patch */

/* Nonzero means last display completed and cursor is really at
   cursX, cursY.  Zero means it was preempted. */
extern int display_completed;

#ifdef HAVE_X_WINDOWS
#include <X11/Xlib.h>
#endif /* HAVE_X_WINDOWS */

#if defined (HAVE_X_WINDOWS) || defined (TERMINAL_FACE)
struct face
  {
#ifdef HAVE_X_WINDOWS
    /* If this is non-zero, it is a GC we can use without modification
       to represent this face.  */
    GC gc;

#endif /* HAVE_X_WINDOWS */

    /* If we have ever called get_cached_face on this face structure,
       here is the index in face_vector of the face it returned.  It
       might not be valid any more, but it's a good place to start
       looking; get_cached_face tries to use this to avoid searching
       all of face_vector.  */
    int cached_index;
  
    /* Pixel value for foreground color.  */
    Lisp_Object_Int foreground;
  
    /* Pixel value for background color.  */
    Lisp_Object_Int background;
  
#ifdef HAVE_X_WINDOWS
    /* Font used for this face.  */
    XFontStruct *font;
  
#ifdef MULE
    /* Table of font used for this face. */
    /* The element `font' is always the same as:
       `font_table[fontset_table[FACE_FONTSET(face)][0]].font'. */
    int fontset_id;
#endif  /* MULE */

    /* Background stipple or bitmap used for this face.  */
    Pixmap stipple;

    /* Pixmap_depth.  */
    unsigned int pixmap_w, pixmap_h;
#else  /* not HAVE_X_WINDOWS */
    /* dummy member for xfaces.c.  */
    int font;
    int stipple;
    int fontset_id;
#endif /* not HAVE_X_WINDOWS */
  
    /* Whether or not to underline text in this face.  */
    char underline;

#ifdef MULE
    /* Whether or not to display text by boldface. */
    char bold;
    /* Whether or not to display text by italicface. */
    char italic;
#endif  /* MULE */
  };

/* Let's stop using this and get rid of it.  */
typedef struct face *FACE;

#define NORMAL_FACE ((struct face *) 0)

#ifdef HAVE_X_WINDOWS
#define FACE_HAS_GC(f) ((f)->gc)
#define FACE_GC(f) ((f)->gc)
#define FACE_STIPPLE(f) ((f)->stipple)
#define FACE_FONT(f) ((f)->font)
#ifdef MULE			/* 94.6.1 by K.Handa */
#define FACE_FONTSET(f) ((f)->fontset_id)
#endif  /* MULE */
#else  /* not HAVE_X_WINDOWS */
#define FACE_HAS_GC(f) (0)
#define FACE_GC(f) (0)
#define FACE_STIPPLE(f) (0)
#endif /* not HAVE_X_WINDOWS */

#define FACE_COLOR_BLACK 0
#define FACE_COLOR_WHITE 1

#define FACE_FOREGROUND(f) ((f)->foreground)
#define FACE_BACKGROUND(f) ((f)->background)

#else  /* Not X nor TERMINAL_FACE */

typedef int FACE;

#define NORMAL_FACE 0x0
#define HIGHLIGHT_FACE 0x1
#define UNDERLINE_FACE 0x2
#define HIGHLIGHT_UNDERLINE_FACE 0x3

#define FACE_HIGHLIGHT(f) ((f) & 0x1)
#define FACE_UNDERLINE(f) ((f) & 0x2)
#endif /* Not X nor TERMINAL_FACE */

/* This structure is used for the actual display of text on a frame.

   There are two instantiations of it:  the glyphs currently displayed,
   and the glyphs we desire to display.  The latter object is generated
   from buffers being displayed.  */

struct frame_glyphs
  {
#ifdef MULTI_FRAME
    struct  frame *frame;	/* Frame these glyphs belong to.  */
#endif /* MULTI_FRAME */
    int height;
    int width;

    /* Contents of the frame.
       glyphs[V][H] is the glyph at position V, H.
       Note that glyphs[V][-1],
                 glyphs[V][used[V]],
	     and glyphs[V][frame_width] are always '\0'.  */
    GLYPH **glyphs;
    /* long vector from which the strings in `glyphs' are taken.  */
    GLYPH *total_contents;

    /* When representing a desired frame,
         enable[n] == 0 means that line n is same as current frame.
	 Between updates, all lines should be disabled.
       When representing current frame contents,
         enable[n] == 0 means that line n is blank.  */
    char *enable;

    /* Everything on line n after column used[n] is considered blank.  */
    int *used;

    /* highlight[n] != 0 iff line n is highlighted.  */
    char *highlight;

    /* Buffer offset of this line's first char.
       This is not really implemented, and cannot be,
       and should be deleted.  */
    Lisp_Object_Int *bufp;

#ifdef HAVE_X_WINDOWS
    /* Pixel position of top left corner of line.  */
    short *top_left_x;
    short *top_left_y;

    /* Pixel width of line.  */
    short *pix_width;

    /* Pixel height of line.  */
    short *pix_height;

    /* Largest font ascent on this line.  */
    short *max_ascent;
#endif	/* HAVE_X_WINDOWS */

    /* Mapping of coordinate pairs to buffer positions.
       This field holds a vector indexed by row number.
       Its elements are vectors indexed by column number.
       Each element of these vectors is a buffer position, 0, or -1.

       For a column where the image of a text character starts,
       the element value is the buffer position of that character.
       When a window's screen line starts in mid character,
       the element for the line's first column (at the window's left margin)
       is that character's position.
       For successive columns within a multicolumn character,
       the element is -1.
       For the column just beyond the last glyph on a line,
       the element is the buffer position of the end of the line.
       For following columns within the same window, the element is 0.
       For rows past the end of the accessible buffer text,
       the window's first column has ZV and other columns have 0.

       Mode lines and vertical separator lines have 0.

       The column of a window's left margin
       always has a positive value (a buffer position), not 0 or -1,
       for each line in that window's interior.  */

    int **charstarts;

    /* This holds all the space in the subvectors of the charstarts field.  */
    int *total_charstarts;
  };

extern void get_display_line ();
extern Lisp_Object sit_for ();

#define MESSAGE_BUFFER_SIZE(frame) (FRAME_WIDTH (frame) * 3)
#define MSG_BUF_SIZE (MESSAGE_BUFFER_SIZE (selected_frame))

/* 93.4.13 K.Handa -- Nonzero means highlight anti-direction characters. */
extern int highlight_reverse_direction;
/* 93.5.22 Y.Niibe -- Nonzero means display double cursor */
extern int r2l_double_cursor;
