#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "exvar.h"

#ifdef KPATHSEA
#include "kp.h"
extern KpathseaSupportInfo kp_ist;
#endif

FILE *fp;

int styread(filename)
/*   read style file   */
char *filename;
{
	int i,j,k,cc;
	char buff[256];

Fprintf("styread()\n");
#ifdef KPATHSEA
	filename = KP_find_file(&kp_ist,filename);
#endif
	fp=fopen(filename,"r");
	if (fp==NULL) {
		fprintf(stderr,"%s does not exist.\n",filename);
		exit(0);
	}

	for (i=0;;i++) {
		if (fgets(buff,255,fp)==NULL) break;
		if (getparam(buff,"keyword",keyword)==1) continue;
		if (getparachar(buff,"arg_open",&arg_open)==1) continue;
		if (getparachar(buff,"arg_close",&arg_close)==1) continue;
		if (getparachar(buff,"range_open",&range_open)==1) continue;
		if (getparachar(buff,"range_close",&range_close)==1) continue;
		if (getparachar(buff,"level",&level)==1) continue;
		if (getparachar(buff,"actual",&actual)==1) continue;
		if (getparachar(buff,"encap",&encap)==1) continue;
		if (getparachar(buff,"quote",&quote)==1) continue;
		if (getparachar(buff,"escape",&quote)==1) continue;
		if (getparam(buff,"preamble",preamble)==1) continue;
		if (getparam(buff,"postamble",postamble)==1) continue;
		if (getparam(buff,"group_skip",group_skip)==1) continue;
		if (getparam(buff,"lethead_prefix",lethead_prefix)==1) continue;
		if (getparam(buff,"lethead_suffix",lethead_suffix)==1) continue;
		cc=scompare(buff,"lethead_flag");
		if (cc!= -1) {
			lethead_flag=atoi(&buff[cc]);
			continue;
		}
		cc=scompare(buff,"priority");
		if (cc!= -1) {
			priority=atoi(&buff[cc]);
			continue;
		}
		if (getparam(buff,"item_0",item_0)==1) continue;
		if (getparam(buff,"item_1",item_1)==1) continue;
		if (getparam(buff,"item_2",item_2)==1) continue;
		if (getparam(buff,"item_2",item_2)==1) continue;
		if (getparam(buff,"item_01",item_01)==1) continue;
		if (getparam(buff,"item_x1",item_x1)==1) continue;
		if (getparam(buff,"item_12",item_12)==1) continue;
		if (getparam(buff,"item_x2",item_x2)==1) continue;
		if (getparam(buff,"delim_0",delim_0)==1) continue;
		if (getparam(buff,"delim_1",delim_1)==1) continue;
		if (getparam(buff,"delim_2",delim_2)==1) continue;
		if (getparam(buff,"delim_n",delim_n)==1) continue;
		if (getparam(buff,"delim_r",delim_r)==1) continue;
		if (getparam(buff,"encap_prefix",encap_prefix)==1) continue;
		if (getparam(buff,"encap_infix",encap_infix)==1) continue;
		if (getparam(buff,"encap_suffix",encap_suffix)==1) continue;
		cc=scompare(buff,"line_max");
		if (cc!= -1) {
			line_max=atoi(&buff[cc]);
			continue;
		}
		if (getparam(buff,"indent_space",indent_space)==1) continue;
		cc=scompare(buff,"indent_length");
		if (cc!= -1) {
			indent_length=atoi(&buff[cc]);
			continue;
		}
		if (getparam(buff,"symbol",symbol)==1) continue;
		cc=scompare(buff,"symbol_flag");
		if (cc!= -1) {
			symbol_flag=atoi(&buff[cc]);
			continue;
		}
		cc=scompare(buff,"letter_head");
		if (cc!= -1) {
			letter_head=atoi(&buff[cc]);
			continue;
		}
		if (getparam(buff,"atama",atama)==1) continue;
		if (getparam(buff,"page_compositor",page_compositor)==1) continue;
		if (getparam(buff,"page_precedence",page_precedence)==1) continue;
		if (getparam(buff,"character_order",character_order)==1) continue;
	}
Fprintf("end of styread()\n");
}

int convline(buff1,start,buff2)
/*   analize string parameter of style file   */
char *buff1,*buff2;
int start;
{
	int i,j,k,cc;

Fprintf("convline()\n");
	for (i=start,j=cc=0;;i++) {
		if (buff1[i]=='\"') {
			if (cc==0) {
				cc=1;
			}
			else {
				buff2[j]='\0';
				break;
			}
		}
		else if ((buff1[i]=='\n')||(buff1[i]=='\0')) {

			if (cc==1) {
				buff2[j++]='\n';
				if (fgets(buff1,255,fp)==NULL) {
					buff2[j]='\0';
					break;
				}
			}
			i= -1;
		}
		else if (cc==1) {
			if ((unsigned char)buff1[i]>0x80) {
				 buff2[j++]=buff1[i++];
				 buff2[j]=buff1[i];
			}
			else if (buff1[i]=='\\') {
				i++;
				if (buff1[i]=='\\') buff2[j]='\\';
				else if (buff1[i]=='n') buff2[j]='\n';
				else if (buff1[i]=='t') buff2[j]='\t';
				else if (buff1[i]=='r') buff2[j]='\r';
				else if (buff1[i]=='\"') buff2[j]='\"';
			}
			else buff2[j]=buff1[i];
			j++;
		}
	}
Fprintf("end of convline()\n");
}

int scompare(buff1,buff2)
/*   compare strings   */
char *buff1,*buff2;
{
	int i,j,k,cc;

Fprintf("scompare()\n");
	for (i=0;i<sstrlen(buff1)-sstrlen(buff2);i++) {
		if (buff1[i]=='\%') {
Fprintf("end of scompare()\n");
			return(-1);
		}
		else if ((sstrncmp(&buff1[i],buff2,sstrlen(buff2))==0)
			&&((buff1[i+strlen(buff2)]==' ')||(buff1[i+strlen(buff2)]=='\t'))) {
Fprintf("end of scompare()\n");
			return(i+strlen(buff2));
		}
	}
Fprintf("end of scompare()\n");
	return(-1);
}

int getparam(buff,paraname,param)
/*   get string of style patameter   */
char *buff,*paraname,*param;
{
	int cc;

Fprintf("getparam()\n");
	cc=scompare(buff,paraname);
	if (cc!=-1) {
		convline(buff,cc,param);
Fprintf("end of getparam()\n");
		return(1);
	}
Fprintf("end of getparam()\n");
	return(0);
}

int getparachar(buff,paraname,param)
/*   get character of style parameter   */
char *buff,*paraname,*param;
{
	int j,cc;

Fprintf("getparachar()\n");
	cc=scompare(buff,paraname);
	if (cc!=-1) {
		for (j=cc;j<strlen(buff);j++) {
			if (buff[j]=='\'') {
				(*param)=buff[j+1];
				break;
			}
			else if (buff[j]=='\n') {
				if (fgets(buff,255,fp)==NULL) {
					break;
				}
				else j= -1;
			}
		}
Fprintf("end of getparachar()\n");
		return(1);
	}
Fprintf("end of getparachar()\n");
	return(0);
}

int sstrlen(buff)
char *buff;
{
	int i;

	if (buff==NULL) return(0);

	for (i=0;;i++) {
		if (buff[i]=='\0') return(i);
	}
}

int sstrncmp(buff1,buff2,len)
char *buff1,*buff2;
int len;
{
	int i;

	if (buff1==NULL) return(-1);
	if (buff2==NULL) return(1);

	for (i=0;i<len;i++) {
		if ((buff1[i]=='\0')&&(buff2[i]=='\0')) return(0);
		if (buff1[i]!=buff2[i]) return(buff1[i]-buff2[i]);
	}
	return(0);
}
