/*
 *	Written by Eric C. Cooper, CMU
 */
/* $Header: xdvi.h,v 10.5 86/02/01 15:45:03 tony Rel $ */

#ifndef X10
#include <X11/Xos.h>	/* same as below */
#else X10
#include <sys/types.h>	/* for sites without X11 */
#endif X10
#include <setjmp.h>

#define	OPEN_MODE	"r"

#define	Printf	(void) printf
#define	Fprintf	(void) fprintf
#define	Sprintf	(void) sprintf
#define	Fseek	(void) fseek
#define	Fread	(void) fread
#define	Fclose	(void) fclose

unsigned long num();
long snum();

#define one(fp)		((unsigned long) getc(fp) & 0xff)
#define sone(fp)	((long) getc(fp))
#define two(fp)		num (fp, 2)
#define stwo(fp)	snum(fp, 2)
#define four(fp)	num (fp, 4)
#define sfour(fp)	snum(fp, 4)

typedef	unsigned char ubyte;
#define	Boolean	char
#define	True	1
#define	False	0

#define	MAXINT		32767

#define	pixel_conv(x)	((int) (((x) / shrink_factor) >> 16))
#define	pixel_round(x)	((int) (((x) / shrink_factor + (1<<15)) >> 16))
#define	spellfour(f)	((long) (sfour(f) * fraction))
#define	spellnum(f,n)	((long) (snum(f,n) * fraction))
#define	pxl2spell(x)	(((long) (x)) * shrink_factor << 16)

#ifdef X10
#undef	MSBITFIRST
#undef	BMLONG
#define	BMSHORT
#endif X10

#ifdef	BMLONG
#define	BMUNIT			unsigned long
#define	BITS_PER_BMUNIT		32
#define	BYTES_PER_BMUNIT	4
#else	BMLONG
#ifdef	BMSHORT
#define	BMUNIT			unsigned short
#define	BITS_PER_BMUNIT		16
#define	BYTES_PER_BMUNIT	2
#else	BMSHORT
#define	BMUNIT			unsigned char
#define	BITS_PER_BMUNIT		8
#define	BYTES_PER_BMUNIT	1
#endif	BMSHORT
#endif	BMLONG

#define	ADD(a, b)	((BMUNIT *) (((char *) a) + b))
#define	SUB(a, b)	((BMUNIT *) (((char *) a) - b))

extern	BMUNIT	bit_masks[BITS_PER_BMUNIT + 1];

struct frame {
	long dvi_h, dvi_v, w, x, y, z;
	int pxl_v;
};

extern	struct frame 	*stack;
extern	int	stackp;

/* entries below with the characters 'dvi' in them are actually stored in
   scaled pixel units */

#define DVI_H   stack[stackp].dvi_h
#define PXL_H   pixel_conv(stack[stackp].dvi_h)
#define DVI_V   stack[stackp].dvi_v
#define PXL_V   stack[stackp].pxl_v
#define WW      stack[stackp].w
#define XX      stack[stackp].x
#define YY      stack[stackp].y
#define ZZ      stack[stackp].z
#define ROUNDUP(x,y) (((x)+(y)-1)/(y))

#define	PAPER_WIDTH	ROUNDUP(17*pixels_per_inch, shrink_factor*2)
#define	PAPER_HEIGHT	ROUNDUP(11*pixels_per_inch, shrink_factor)

extern	int	current_page;
extern	int	total_pages;
extern	double	fraction;
extern	int	maxstack;
extern	int	n_fonts_left;		/* for LRU management of fonts */
extern	time_t	dvi_time;		/* last mod. time for dvi file */
extern	char	*font_path;
extern	int	page_w, page_h;

/*
 * Table of page offsets in DVI file, indexed by page number - 1.
 * Initialized in prepare_pages().
 */
extern	long	*page_offset;

/*
 * Mechanism for reducing repeated warning about specials.
 */
extern	Boolean	spec_warn;


/*
 * Bitmap structure for raster ops.
 */
struct bitmap{
	short w, h;		/* width and height in pixels */
	short bytes_wide;	/* scan-line width in bytes */
	char *bits;		/* pointer to the bits */
};

#ifndef	MAXCHARS
#define	MAXCHARS	256	/* GF and PK both 256 character fonts */
#endif	MAXCHARS

/*
 * Per-character information.
 * There is one of these for each character in a font.
 * All fields are filled in at font definition time,
 * except for the bitmap, which is "faulted in"
 * when the character is first referenced.
 */
struct glyph {
	long addr;		/* address of bitmap in PXL file */
	long dvi_adv;		/* DVI units to move reference point */
	short x, y;		/* x and y offset in pixels */
	struct bitmap bitmap;	/* bitmap for character */
	short x2, y2;		/* x and y offset in pixels (shrunken bitmap) */
	struct bitmap bitmap2;	/* shrunken bitmap for character */
};

/*
 * The layout of a font information block.
 * There is one of these for every loaded font or
 * magnification thereof.
 *
 * Also note the strange units.  The design size is in 1/2^20 point
 * units (also called micro-points), and the individual character widths
 * are in the TFM file in 1/2^20 ems units, i.e. relative to the design size.
 *
 * We then change the sizes to SPELL units (unshrunk pixel / 2^16).
 */

void	alloc_bitmap();

typedef	void (*read_char_proc)();
	/* struct font *fp; */
	/* ubyte ch; */

	/* the corresponding read_font_index procedures occur in pxl_open.c */
typedef	void (*read_font_index_proc)();
	/* struct font *fontp; */

struct font {
	struct font *next;		/* link to next font info block */
	int TeXnumber;			/* font number (in DVI file) */
	int scale;			/* scaled size in SPELL units */
	char *fontname;			/* PXL file name */
	short size;			/* dots per 5 inches */
	FILE *file;			/* open PXL file or NULL */
	char *filename;			/* name of PXL file */
	read_char_proc read_char;	/* function to read bitmap */
	struct glyph glyph[MAXCHARS];
};

extern	struct font	*current_font;

/*
 * Command line flags.
 */

extern	int	debug;

#define DBG_BITMAP	0x1
#define DBG_DVI		0x2
#define DBG_PK          0x4
#define DBG_BATCH       0x8
#define	DBG_EVENT	0x10
#define DBG_ALL		(DBG_BITMAP|DBG_DVI|DBG_PK|DBG_EVENT)

extern	Boolean	list_fonts;

extern	int	pixels_per_inch;
extern	int	density;

extern	char	*dvi_name;
extern	FILE	*dvi_file;				/* user's file */
extern	char	*prog;

extern	struct	WindowRec {
	long	win;		/* type Window is not defined yet */
	int	shrinkfactor;
	int	base_x, base_y;
	int	min_x, max_x, min_y, max_y;	/* for pending expose events */
} mane, alt, curr;

#define	shrink_factor	curr.shrinkfactor

jmp_buf	dvi_env;		/* mechanism to communicate dvi file errors */
