.TH XDVI SIPB "17 January 1989" "X Version 11"
.SH NAME
xdvi \- DVI Previewer for the X Window System
.SH SYNOPSIS
.B xdvi
[+[\fIpage\fP]] [\-s \fIshrink\fP] [\-S \fIdensity\fP] [\-p \fIpixels\fP]
[\-l] [\-rv] [\-fg \fIcolor\fP] [\-bg \fIcolor\fP] [\-hl \fIcolor\fP]
[\-bd \fIcolor\fP] [\-cr \fIcolor\fP] [-thorough] [\-margins \fIinches\fP]
[\-sidemargin \fIinches\fP] [\-topmargin \fIinches\fP]
[\-mgs[\fIn\fP] \fIsize\fP] [\-geometry \fIgeometry\fP | =\fIgeometry\fP]
[%\fIgeometry\fP] [\-display \fIdisplay\fP] file
.SH DESCRIPTION
.I Xdvi
is a program which runs under the X window system. It is used to preview
DVI files, such as are produced by TeX.
.PP
This program has the capability of
showing the file shrunken by various (integer) factors, and also has a
``magnifying glass'' which allows one to see a small part of the unshrunk
image momentarily.
.PP
Also, before displaying any page or part thereof, it checks to see if the dvi
file has changed since the last time it was displayed.  If this is the case,
then \fIxdvi\fR will reinitialize itself for the new dvi file.  For this reason,
exposing parts of the \fIxdvi\fR window while \fITeX\fR is running should be
avoided.  This feature allows you to preview many versions
of the same file while running \fIxdvi\fR only once.
.SH OPTIONS
In addition to specifying the .\fPdvi\fR file (with or without the .\fPdvi\fR),
\fIXdvi\fR supports the following command line options.
If the option begins with a
.RB ` + '
instead of a
.RB ` \- ',
the option is restored to its default value.  By default, these options can
be set via the resource names given in parentheses in the description of
each option.
.TP
.IB + page
Specifies the first page to show.  If \fI+\fR is given without a
number, the last page is assumed; the first page is the default.
.TP
.BI \-s " shrink"
(.shrinkFactor)
Defines the initial shrink factor.  The default value is 4.
.TP
.BI \-S " density"
(.densityPercent)
Determines the density used when shrinking bitmaps for fonts.
A higher value produces a lighter font.  The default value is 40.
.TP
.BI \-p " pixels"
(.pixelsPerInch)
Defines the size of the fonts to use, in pixels per inch.  The
default value is 300.
.TP
.B \-l
(.listFonts)
Causes the names of the fonts used to be listed.
.TP
.B \-rv
(.reverseVideo)
Causes the page to be displayed with white characters on a
black background, instead of vice versa.
.TP
.BI \-bw " width"
(.borderWidth)
Specifies the width of the border of the window.
.TP
.BI \-borderwidth " width"
Same as \fB-bw\fR, above.
.TP
.BI \-fg " color"
(.foreground)
Determines the color of the text (foreground).
.TP
.BI \-foreground " color"
Same as \fB-fg\fR, above.
.TP
.BI \-bg " color"
(.background)
Determines the color of the background.
.TP
.BI \-background " color"
Same as \fB-bg\fR, above.
.TP
.BI \-hl " color"
(.highlight)
Determines the color of the page border.
.TP
.BI \-bd " color"
(.borderColor)
Determines the color of the window border.
.TP
.BI \-cr " color"
(.cursorColor)
Determines the color of the cursor.  The default is the
foreground color.
.TP
.B \-thorough
(.thorough)
\fIXdvi\fR will usually try to ensure that overstrike characters (\fIe.g.\fR
\\notin) are printed correctly.  On monochrome displays, this is always
possible with one logical operation, either \fIand\fR or \fIor\fR.  On
color displays, however, this may take two operations, one to set the
appropriate bits and one to clear other bits.  If this is the case, then
by default \fIxdvi\fR will instead use the \fIcopy\fR operation,
which does not handle overstriking correctly.  The ``thorough'' option
chooses the slower but more correct choice.
.TP
.BI \-margins " inches"
(.margins)
Specifies the size of both the top margin and side margin.  This
can be a decimal number, \fIe.g.\fR, 1.5.  It determines
the ``home'' position of the page within the window as follows.  If the entire
page fits in the window, then the margin settings are ignored.  If, even
after removing the margins from the left, right, top, and bottom, the page
still cannot fit in the window, then the page is put in the window such that
the top and left margins are hidden, and presumably the upper left-hand corner
of the text on the page will be in the upper left-hand corner of the window.
Otherwise, the text is centered in the window.  See also `\fBH\fR' under
the KEY\%STROKES section.
.TP
.BI \-sidemargin " inches"
(.sideMargin)
Specifies the side margin (see above).
.TP
.BI \-topmargin " inches"
(.topMargin)
Specifies the top and bottom margins (see above).
.TP
.BI "\-mgs[n]" " size"
(.magnifierSize[n])
Specifies the size of the window to be used for the ``magnifying glass''
for Button \fIn\fR.  See the MOUSE ACTIONS section.  Defaults are 200,
350, 600, 900, and 1200.
.TP
.BI \-mgs " size"
Same as \fB-mgs1\fR, above.
.TP
.BI = geometry
(*geometry)
Specifies the initial geometry of the window.
.TP
.BI \-geometry " geometry"
Same as above.
.TP
.BI # geometry
(.iconGeometry)
Specifies the initial position for the icon.
.TP
.BI \-display " host:display"
Specifies the host and screen to be used for displaying the dvi file.
This is normally obtained from the environment variable ``DISPLAY.''
.SH KEYSTROKES
\fBXdvi\fR recognizes the following keystrokes when typed in its window.
Each may optionally be preceded by a (positive or negative) number, whose
interpretation will depend on the particular keystroke.
.TP
.B q
Quits the program.  Control-C and control-D will do this, too.
.TP
.B n
Moves to the next page (or to the \fBn\fRth next page if a number is given).
Synonyms are `\fBf\fR', Space, Return, and Line Feed.
.TP
.B p
Moves to the previous page (or back \fBn\fR pages).  Synonyms are
`\fBb\fR', control-H, and Delete.
.TP
.B g
Moves to the page with the given number.  Initially, the first page is assumed
to be page number 1, but this can be changed with the `\fBP\fR' keystroke,
below.  If no page number is given, then it goes to the last page.
.TP
.B P
``This is page number \fBn\fR.''  This can be used to make the `\fBg\fR'
keystroke refer to actual page numbers instead of absolute page numbers.
.TP
.B Control-L
Redisplays the current page.
.TP
.B ^
Move to the ``home'' position of the page.  This is normally the upper
left-hand corner of the page, depending on the margins as described in
the \-margins option, above.
.TP
.B u
Moves up a window-full.
.TP
.B d
Moves down a window-full.
.TP
.B l
Moves left a window-full.
.TP
.B r
Moves right a window-full.
.TP
.B c
Moves the page so that the point currently beneath the cursor is moved to
the middle of the window.  It also (gasp!) warps the cursor to the same place.
.TP
.B M
Sets the margins so that the point currently under the cursor is the upper
left-hand corner of the text in the page.
.TP
.B s
Changes the shrink factor to the given number.  If no number is given, the
smallest factor that makes the entire page fit in the window will be used.
(Margins are ignored in this computation.)
.TP
.B S
Sets the density factor to be used when shrinking bitmaps.  This should
be a number between 0 and 100; higher numbers produce lighter characters.
.TP
.B R
Forces the dvi file to be reread.  This allows you to preview many versions
of the same file while running \fIxdvi\fR only once.
.SH MOUSE ACTIONS
If the shrink factor is set to any number other than one, then clicking
any mouse button will pop up a ``magnifying glass'' which shows the unshrunk
image in the vicinity of the mouse click.  This subwindow disappears when
the mouse button is released.  Different mouse buttons produce different sized
windows, as indicated by the \fB\-mgs\fR option, above.
.PP
Also, the scrollbars (if present) behave in the standard way:  pushing Button 2
in a scrollbar moves the top or left edge of the scrollbar to that point;
pushing Button 1 moves the image up or right by an amount equal to the distance
from the button press to the upper left-hand corner of the window; pushing
Button 3 moves the image down or left by the same amount.
.SH ENVIRONMENT
Uses the environment variable ``DISPLAY'' to specify which bit map display
terminal to use.
.PP
The environment variable ``%%FONT_PATH%%'' determines the path(s) searched for
fonts in the following manner.  The string consists of one or more strings
separated by colons.  In each such string, the substring ``%f'' is
changed to the font name; ``%d'' is changed to the magnification; and
``%p'' is changed to the font family (``gf'', ``pk'', or ``pxl'').  If no
``%f'' appears in the string, then the string ``/%f.%d%p'' is added on
the end.  For example, if the string is ``%%DEFAULT_FONT_PATH%%'' and the font is
cmr10 at 300dpi, then it searches for %%DEFAULT_FONT_PATH%%/cmr10.300gf,
%%DEFAULT_FONT_PATH%%/cmr10.300pk, and %%DEFAULT_FONT_PATH%%/cmr10.1500pxl,
in that order.  If the first character of the ``%%FONT_PATH%%'' variable
is a colon, then the system default paths are tried first.
.SH FILES
.br
%%DEFAULT_FONT_PATH%%   Font raster files.
.SH COMMENTS
On a monochrome screen, and in some cases on a color screen, if the
font characters are displayed as un-activated regions of the phosphor
(black on white, for example), the terminal is acting as a write-white
device.  Write-white fonts give much better readability in this case,
especially for full-page images with the ``normal'' shrink factor of
4 applied to a 300[gf,pk] font.
.SH "SEE ALSO"
X(1).
.SH AUTHORS
Eric Cooper, CMU, did a version for direct output to a QVSS.
Modified for X by
Bob Scheifler, MIT Laboratory for Computer Science.
Modified for X11 by Mark Eichin, MIT SIPB.
Additional enhancements by many others.
