/*
 * dvipage: DVI Previewer Program for Suns
 *
 * Neil Hunt (hunt@spar.slb.com)
 *
 * This program is based, in part, upon the program dvisun,
 * distributed by the UnixTeX group, extensively modified by
 * Neil Hunt at the Schlumberger Palo Alto Research Laboratories
 * of Schlumberger Technologies, Inc.
 *
 * From the dvisun manual page entry:
 *	Mark Senn wrote the early versions of [dvisun] for the
 *	BBN BitGraph. Stephan Bechtolsheim, Bob Brown, Richard
 *	Furuta, James Schaad and Robert Wells improved it. Norm
 *	Hutchinson ported the program to the Sun. Further bug fixes
 *	by Rafael Bracho at Schlumberger.
 *
 * Copyright (c) 1988 Schlumberger Technologies, Inc 1988.
 * Anyone can use this software in any manner they choose,
 * including modification and redistribution, provided they make
 * no charge for it, and these conditions remain unchanged.
 *
 * This program is distributed as is, with all faults (if any), and
 * without any warranty. No author or distributor accepts responsibility
 * to anyone for the consequences of using it, or for whether it serves any
 * particular purpose at all, or any other reason.
 *
 * $Log:	dvipage.h,v $
 * Revision 1.2  88/12/15  17:22:36  hunt
 * Reduced MAXOPEN to 12; leaves enough fds for popups and prompts in worst
 * case: complete set of fonts, message window and popup window.
 * 
 * Revision 1.1  88/11/28  18:42:06  hunt
 * Initial revision
 * 
 */

/*
 * Switches and flags;
 * ==================
 *
 * Some of these constants will be customised for different installations.
 */

/*
 * Define USEGLOBALMAG to see effect of mag changes in previewer;
 * Best left commented out.
 */
/* #define USEGLOBALMAG		1	/* Use dvi global magnification ??? */

/*
 * FONT_PATH is the environment variable searched for a font path spec.
 * FONT_AREA is the default font path; a colon separated list of possible
 *	directories in which pxl and gf files reside.
 */
#define FONT_PATH		"FONT_PATH"

#ifndef FONT_AREA
#ifdef sparc
#define FONT_AREA \
  "/nfs/tex-server/tex/1988/lib/tex/fonts:/fonts/tex/pxl"
#else !sparc
#define FONT_AREA \
  "/usr/local/lib/tex82/fonts/sun:/usr/local/lib/tex82/fonts/sun/pk"
#endif sparc
#endif  FONT_AREA

/*
 * These constants set flag defaults; if the flag is 0, that type of
 *	font file will not be read.
 */
#define USE_GF			1
#define USE_PXL			1
#define USE_PK			1

/*
 * Define a command which will print the whole document.
 */
#ifndef PRINT_SPOOLER
#define PRINT_SPOOLER		"lpr -d %s >/dev/null 2>/dev/null"
#endif  PRINT_SPOOLER

/*
 * Define a command which will print the specified page of the document.
 */
#ifndef PRINT_PAGE_SPOOLER
#define PRINT_PAGE_SPOOLER \
	"texpagefilter -f %d -t %d %s | lpr -d >/dev/null 2>/dev/null"
#endif	PRINT_PAGE_SPOOLER

/*
 * The default size of page which will be used
 */
#define PAGE_WIDTH		(8.5)	/* Inches */
#define PAGE_HEIGHT		(11)	/* Inches */

/*
 * The default origin on the paper; this corresponds to the
 * normal TeX standard; change it only if your printer or dvi processor is
 * broken and you must match
 */
#define DEFAULT_ORIGIN_X	(1)	/* inches */
#define DEFAULT_ORIGIN_Y	(1)	/* inches */

/*
 * default starting display... makes better use of screen.
 */

#define DEFAULT_START_X		(-1) 	/* inches */
#define DEFAULT_START_Y		(-1) 	/* inches */

/*
 * These are the defaults for resolution and sampling factors
 * of fonts for colour and mono screens.
 */
#define DEFAULT_MONO_RES	118
#define DEFAULT_COLOUR_RES	300

#define DEFAULT_MONO_SAMPLING	1	/* Must be 1 */
#define DEFAULT_COLOUR_SAMPLING	4

/*
 * This is the default magnifier size and border width.
 */
#define DEFAULT_MAG_SIZE_X	(256)
#define DEFAULT_MAG_SIZE_Y	(128)
#define DEFAULT_MAG_BORDER	(2)

/*
 * Some limits in the program.  Change for extraordinary TeX files.
 */
#ifdef NOFILE
#define MAXOPEN			NOFILE-6 /* leave room for stdio, */
					 /*  window, message,popup */
#else
#define MAXOPEN			12	/* Max number of open font files. */
#endif
#define STACKSIZE		100	/* dvi stack max length */
#define STRSIZE			MAXPATHLEN	/* Max string length */
#define MAX_SHEETS		512	/* Pages remembered in table */

/*
 * This identifies the version number of the previewer.
 */
#define DVIPAGE_LABEL		"DVI Previewer 3.0"	/* Frame label */

/*
 * Standard definitions.
 * ====================
 */

#ifndef _TYPES_
typedef unsigned int		uint;
typedef unsigned short		ushort;
#endif _TYPES_
typedef unsigned char		uchar;
#ifdef bool
#undef bool
#endif bool
typedef unsigned int		bool;

#define DEL			'\177'
#define ESC			'\033'
#define Control(c)		((c) - 0x40)

#define A_ARG			0
#define A_END			(-1)

#define forward			extern

#define Range(min, x, max)	(((x) < (min))? \
				 (min) : (((x) > (max))? (max) : (x)) \
				)

#define MAXINT			2147483647
#define NEGMAXINT		(-2147483648)

#ifndef TRUE
#define TRUE			1
#define FALSE			0
#endif  TRUE

/*
 * System wide constants.
 * =====================
 */

#define	NONEXISTENT		(-1)	/* Offset when font file not found */
#define NO_FILE			((FILE *)-1)

#define NFNTCHARS      		256

#define PXLID			1001

#define DVIFORMAT		2

#define SKIP			TRUE	/* Flags for process_page() */
#define RASTERISE		FALSE

#define DEBUG_FONTS		1
#define DEBUG_CHARS		2
#define DEBUG_PRINTER		4
#define DEBUG_IMSIZE		8
#define DEBUG_SHEET		16
#define DEBUG_MAGNIFY		32

#define BAD_PAGE		NEGMAXINT
#define LAST_PAGE		MAXINT

/*
 * Macros:
 *	return rounded number of pixels
 */

#define Pix_round(x, conv)	((int)(((x) + ((conv) >> 1)) / (conv)))

/*
 * Data Structures
 * ===============
 */

/*
 * Character information.
 *	Width in pixels.
 *	Height in pixels.
 *	X offset in pixels.
 *	Y offset in pixels.
 *	Location of bits
 *		Flag for bits have been loaded into memory.
 *			offset to position in file.
 *			pointer to the bits.
 *	width.
 */

struct char_entry
{
	ushort		width;
	ushort		height;
	short		xOffset;
	short		yOffset;
	struct
	{
		int		isloaded;
		union
		{
			int		fileOffset;
			struct pixrect	*pixrectptr;
		} address;
		int		flags;
	} where;
	int		tfmw;
};

/*
 * Font information.
 */

struct font_entry
{
	struct font_entry *next;	/* Linked list of fonts in use. */
	FILE		*font_file_fd;  /* FP (0 if not open, -1 if unavail) */
	int		use_count;	/* Count of number of uses of font */
	int		k;		/* Internal font descriptor */
	int		c;		/* checksum from DVI file */
	int		s;		/* space size from DVI file */
	int		d;		/* design size from DVI file */
	int		a;		/* area length for font name */
	int		l;		/* device length */
	char		n[STRSIZE];	/* FNT_DEF command parameters  */
	int		font_space;	/* computed from FNT_DEF s parameter */
	int		font_gf_mag;	/* computed from s and d parameters */
	int		font_pxl_mag;	/* computed from s and d parameters */
	char		psname[STRSIZE];/* ps name of font file */
	char		name[STRSIZE];	/* full name of font file */
	int		type;		/* PXL or GF */
	int		magnification;	/* magnification read from font file */
	int		designsize;	/* design size read from font file */
	struct char_entry ch[NFNTCHARS];/* character information */
};

#define TYPE_PXL	1
#define TYPE_GF		2
#define TYPE_PK		3

/*
 * mem_pixrect:
 *	A statically allocatable pixrect structure.
 *	Contains the pixrect data and the mpr_data.
 */

struct mem_pixrect
{
	struct pixrect		mpr_pr;
	struct mpr_data		mpr_data;
};

/*
 * Globals.
 * =======
 */

extern struct font_entry *fontptr;
extern struct font_entry *hfontptr;

extern bool silent;

extern char pathname[STRSIZE];
extern char directory[STRSIZE];
extern char filename[STRSIZE];

extern char *font_path;
extern bool use_gf;
extern bool use_pxl;
extern bool use_pk;

extern FILE *dvifp;

extern int resolution;
extern int sampling;
extern bool mono;

extern struct mem_pixrect page_mpr;
extern struct pixrect *page_pr;
extern struct mem_pixrect sample_mpr;
extern struct pixrect *sample_pr;

extern int verbose;

/*
 * External Functions.
 * ==================
 */

extern int			abs();
extern char *			getenv();
extern double			atof();

/*
 * Interfaces.
 * ==========
 */

/*
 * In sample.c:
 */
extern void			pw_cover();
extern void			pw_rect();
extern void			pr_rect();
forward struct pixrect *	pr_alloc();
forward struct pixrect *	pr_free();
forward struct pixrect *	pr_check();
forward struct pixrect *	pr_link();
extern void			sample_page();
forward struct pixrect *	pr_sample_4();
forward struct pixrect *	pr_sample_34();
forward struct pixrect *	pr_sample_3();
forward struct pixrect *	pr_sample_2();
extern void			make_cmap();
forward void			pw_cover();
forward void			pr_rect();
forward void			pw_rect();

/*
 * In fonts.c:
 */
extern bool			get_font_def();
extern void			skip_font_def();
extern bool			read_font_def();
extern void			close_fonts();
extern bool			load_char();

/*
 * In findfile.c:
 */
extern bool			find_font_file();

/*
 * In message.c:
 */
extern void			message();
extern bool			strings_prompt();
extern bool			integers_prompt();
extern bool			doubles_prompt();

/*
 * In utils.c:
 */
forward unsigned int		get_unsigned();
forward int			get_signed();
forward double			actual_factor();
forward int			do_convert();

/*
 * In args.c:
 */
extern char *			a_prog_name;
extern char			a_next();
extern char *			a_arg();
extern int			a_integer();
extern double			a_number();
