/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


#include <stdio.h>
#include "defs.h"
#include "char.h"

extern CAFM AfmChar[1];
extern char * SetUpHashTable();
extern CRMP InsertKeyIntoHashTable();

/* Hash table, which maps character names to character codes */
char * MapHashTable;

/*
 * MapChar
 * *******
 * Handle the remapping of characters. This allows us to change
 * the character code assigned to a character. This procedure
 * is called with a (character name, code) pair, when the PFD
 * file is read in.
 *
 * name: name of the character
 * code: its new code;
 */
void
MapChar(name, code)
     char * name;
     int code;
{
  CRMP p;

  CheckCharCode (code, "MapChar(): map char wrong");
  if (AfmChar[code].c_map)
    Fatal2 ("MapChar(): character '%o already mapped", code);
  p = InsertKeyIntoHashTable (MapHashTable, name);
  p->r_code = code;
}

/*
 * MapCharInit
 * ***********
 * Initialize the remapping of characters by setting up a hash table.
 */
void
MapCharInit()
{
  MapHashTable = SetUpHashTable (50, sizeof(CRM),
				   "Map Character Hash Table");
}

