# AWK script which takes token names in a token file
#	generating a C procedure to print those tokens symbolically.
# The source token file may contain comments which
# have a % at the beginning of a line.
BEGIN {val = 1;
	print "/* Print tokens as string */"
	print "/* !!!!!! DO NOT CHANGE THIS FILE !!!!!!!!! */"
	print "/* Generated by an awk script */"
	print "#include <stdio.h>"
	print "PrintToken(fp, t)"
	print "    FILE * fp;"
	print "    int   t;"
	print "{"
	print "  switch  (t) {"
	print "    case 0: fprintf (fp, \"<<END-LEX>>\"); break;"
}

{if ( $1 == "%" ) break; }
{printf "            case %2d: fprintf(fp, \"%s\"); break;\n", val, $1}
{val++}

# At the end terminate the switch statement in the C printoken procedure.
END {
printf "    default: fprintf (fp, \"<<ILLEGAL TOKEN (%%d)>>\", t);\n"
printf "        } /* switch */\n"
printf "    } /* PrintToken(fp, t) */\n"
}
