#include "param.h"
#include <sys/types.h>
#include <sys/dir.h>

#ifndef KYOMAXWORDS
#define KYOMAXWORDS  387000      /* Calculated from Kyocera status page */
#endif
#define MAXKYOHEIGHT    150      /* Max height of a font in pixels */

#define KC_LOADED    0x0001     /* Char has been loaded in the printer */
#define KC_NEEDED    0x0002     /* This char is needed on this page */
#define KC_RASTER    0x0004     /* Char must be sent as raster info */

struct kyochar {
  short kc_info,kc_kyowidth;
  short kc_height,kc_width;
  short kc_xoffset,kc_yoffset;
  long  kc_texwidth,kc_pxlwidth;
  union {long l; unsigned short *p} kc_glyph;
};

#define KF_LOADED    0x0001     /* Font has been loaded into printer */
#define KF_FILE      0x0002     /* Font hasn't been loaded from the file */

#define KF_MIN         2500     /* #words overhead for a font */
#define KF_NUMBASE     1000     /* base for fontnumbers */
#define KF_USED           1

struct kyofont {
  short          kf_info;
  short          kf_kyonumber;
  short          kf_maxheight;
  long           kf_mag;
  long           kf_words_used;
  long           kf_words_needed;
  long           kf_timestamp;
  long           kf_tfm_checksum;
  long           kf_pxl_mag_val;
  long           kf_pxl_design_size;
  long           kf_s;
  char           kf_name[MAXFNTNAMLEN];
  char           kf_filename[MAXNAMLEN];
  struct kyochar  kf_char[MAXCHARS];
} *kyofonts[MAXKYOFONTS];
