%{
#ifndef lint
static char *rcs = "$Header: qmsmap.y,v 1.1 88/01/15 12:19:03 simpson Rel $";
#endif
/*
$Log:	qmsmap.y,v $
 * Revision 1.1  88/01/15  12:19:03  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  17:12:01  simpson
 * beta test
 * 
*/
#include <stdio.h>
#include <setjmp.h>
#include <local/standard.h>
#include "qms.h"

extern FILE	*_Ifp, *_Ofp;
extern Boolean	_FirstChar;
static jmp_buf	Env;
char		*malloc();
static struct qmsmap	*MapList, *P;
static int	ByteCount, CheckSum;
char		S[77];
%}
%union {
    char    s[77];
}
%token <s> MAP MAPEND BYTECOUNT DATA ENDLINE
%%
mapdata : 
    MAP ENDLINE
    datalines
    MAPEND ENDLINE 
    ;

datalines : 
    datalines 
    dataline
	{
	    if (MapList == NULL) {
		MapList = (struct qmsmap *)malloc((unsigned)
		sizeof(struct qmsmap));
		MapList->count = ByteCount;
		MapList->checksum = CheckSum;
		(void)strcpy(MapList->data = malloc((unsigned)(strlen(S) 
		+ 1)), S);
		MapList->next = NULL;
	    } else {
		for (P = MapList; P->next; P = P->next)
		    ;
		P->next = (struct qmsmap *)malloc((unsigned)
		sizeof(struct qmsmap));
		P = P->next;
		P->count = ByteCount;
		P->checksum = CheckSum;
		(void)strcpy(P->data = malloc((unsigned)(strlen(S) + 1)), S);
		P->next = NULL;
	    }
	}
    |
    /* epsilon */
    ;
	    
dataline :
    BYTECOUNT 
	{
	    (void)sscanf(&$1[1], "%X", &ByteCount);
	}
    DATA
	{
	    (void)sscanf(&$3[strlen($3) - 4], "%X", &CheckSum);
	    $3[strlen($3) - 4] = '\0';
	    (void)strcpy(S, $3);
	}
    ENDLINE
    ;
%%
#include "qmsmaplex.c"

struct qmsmap *qmsmap(north, south, west, east)
double north, south, west, east;
{
    _FirstChar = TRUE;
    MapList = NULL;
    fputs(QUICON, _Ofp);
    fprintf(_Ofp, "%s00000", SYNTAX);
    fprintf(_Ofp, "%sMAP%05d%05d%05d%05d%s", INFO, (int)(north * 1000), 
    (int)(south * 1000), (int)(west * 1000), (int)(east * 1000), ENDCMD);
    fputs(QUICOFF, _Ofp);
    (void)fflush(_Ofp);
    if (setjmp(Env)) {
	while (timedgetc(_Ifp) != EOF)	/* Discard remaining input */
	    ;
	return NULL;
    }
    if (yyparse() != 0)
	return NULL;
    yysptr = yysbuf;	    /* Resets lex lookahead buffer */
    return MapList;
}

static yyerror(s)
char	*s;
{
    longjmp(Env, TRUE);
}
