/* "of" filter - prints banner page */
#ifndef lint
static char *rcs = "$Header: of.c,v 1.1 88/01/15 13:04:45 simpson Rel $";
#endif
/*
$Log:	of.c,v $
 * Revision 1.1  88/01/15  13:04:45  simpson
 * initial release
 * 
 * Revision 0.2  87/12/22  15:50:06  simpson
 * added pitch reset
 * 
 * Revision 0.1  87/12/11  18:31:07  simpson
 * beta test
 * 
*/
#include <stdio.h>
#include <signal.h>
#include <sgtty.h>
#include <sys/file.h>
#include <local/standard.h>
#include <local/profile.h>
#include <local/qms.h>

static struct Speeds {
    int	    speed;
    int	    code;
} Speeds[] = {
    50,		B50,
    75,		B75,
    110,	B110,
    134,	B134, 
    300,	B300,
    600,	B600,
    1200,	B1200,
    2400,	B2400,
    4800,	B4800,
    9600,	B9600,
    19200,	EXTA,
    0,		0
};

char *Whoami;

main(argc, argv)
int	    argc;
char	    *argv[];
{
    Boolean	    oinlist(), vinlist();
    struct optnode  *p;
    struct qmsopc   *opc;
    void	    setoption(), qmsopcfree();
    int		    c, fc, fs, xc, xs, br;
    int		    portraitfont = 1204;
    float	    portraitpitch = 12.0;
    FILE	    *f;
    char	    *readline, *queue, bp[1024];
    PROFILE_VALUE   *v, *class1, *class2, *class3, *class4,
		    *getbindingvalue();
    struct sgttyb   sgtty;
		    
    Whoami = argv[0];
    while ((c = getopt(argc, argv, "w:l:")) != EOF)
	switch (c) {
	case 'w':
	case 'l':
	    break;
	case '?':
	    exit(2);
	}
    if ((v = getbindingvalue("portraitfont")) && v->class == PROFILE_INTEGER)
	portraitfont = v->value.i;
    if ((v = getbindingvalue("portraitpitch")) && (v->class == PROFILE_INTEGER
    || v->class == PROFILE_FLOAT))
        if (v->class == PROFILE_INTEGER)
	    portraitpitch = v->value.i;
        else
	    portraitpitch = v->value.f;
    class1 = getbindingvalue("class1");
    class2 = getbindingvalue("class2");
    class3 = getbindingvalue("class3");
    class4 = getbindingvalue("class4");
    if (!(v = getbindingvalue("readline")) || v->class != PROFILE_STRING &&
    v->class != PROFILE_OTHER) {
	fprintf(stderr,
	"%s: missing or invalid readline binding in configuration file\n",
	Whoami);
	exit(2);
    }
#if defined(sun)
    (void)flock(fileno(stdout), LOCK_EX);
#endif
    readline = v->value.s;
    if (!(f = fopen(readline, "r"))) {
	fprintf(stderr, "%s: cannot open read tty %s\n", Whoami, readline);
	exit(2);
    }
    if (!(v = getbindingvalue("queuename")) || v->class != PROFILE_STRING
    && v->class != PROFILE_OTHER) {
	fprintf(stderr, 
	"%s: missing or invalid queuename binding in configuration file\n",
	Whoami);
	exit(2);
    }
    queue = v->value.s;
    (void)ioctl(fileno(f), TIOCGETP, &sgtty);
    if (pgetent(bp, queue) != 1) {
	fprintf(stderr, "%s: can't find queue entry in printcap file!\n",
	Whoami);
	exit(2);
    }
    /* Set up the tty settings on the debugger port to be the same as the */
    /* daughter board port, except use hardware flow control (DTR) on the */
    /* daughter board port and software flow control (XON/XOFF) on the    */
    /* debugger port.  Hardware flow control allows us to send ^S and ^Q  */
    /* to the QMS printer but since the debugger port simply passes	  */
    /* through the data it receives, it cannot use hardware flow control  */
    /* and must use ^S/^Q.  Set up the debugger port tty settings as in	  */
    /* the /etc/printcap file but always turn TANDEM on and LMDMBUF off   */
    /* on the debugger port.						  */
    if ((fc = tgetnum("fc")) != -1)
	sgtty.sg_flags &= ~fc;
    if ((fs = tgetnum("fs")) != -1)
	sgtty.sg_flags |= fs;
    sgtty.sg_flags |= RAW | TANDEM;	    /* Always! */
    if ((br = tgetnum("br")) != -1)
	sgtty.sg_ispeed = sgtty.sg_ospeed = convertspeed(br);
    (void)ioctl(fileno(f), TIOCSETP, &sgtty);
    if ((xs = tgetnum("xs")) != -1)
	(void)ioctl(fileno(f), TIOCLBIS, &xs);
    if ((xc = tgetnum("xc")) != -1)
	(void)ioctl(fileno(f), TIOCLBIC, &xc);
    c = LMDMBUF;
    (void)ioctl(fileno(f), TIOCLBIC, &c);   /* Always! */
#ifdef pyr
    /* Pyramid specific ioctls that must be set to get everything to	*/
    /* really work.							*/
    /* Use hardware flow control for the daughter board port.		*/
#ifdef ASCIILOAD
    c = 1;
    (void)ioctl(fileno(stdout), TIOCHXON, &c);
#else
    c = 1;
    (void)ioctl(fileno(stdout), TIOCHCTS, &c);
#endif
    /* Use software flow control for the debugger port.			*/
    c = 2;
    (void)ioctl(fileno(f), TIOCHXON, &c);
#endif
    if (!qmsopen(fileno(stdout), fileno(f))) {
	fprintf(stderr, "%s: qmsopen() failed\n", Whoami);
	exit(2);
    }
    if (!(opc = qmsopc())) {
	fprintf(stderr, "%s: failed to read option class info\n", Whoami);
	exit(2);
    }
    fputs(QUICON, stdout);
    /* First turn off the option classes that should not be turned on */
    for (p = opc->OC1; p; p = p->next)
	if (!vinlist(class1, p->option))
	    setoption(1, p->option, FALSE);
    for (p = opc->OC2; p; p = p->next)
	if (!vinlist(class2, p->option))
	    setoption(2, p->option, FALSE);
    for (p = opc->OC3; p; p = p->next)
	if (!vinlist(class3, p->option))
	    setoption(3, p->option, FALSE);
    for (p = opc->OC4; p; p = p->next)
	if (!vinlist(class4, p->option))
	    setoption(4, p->option, FALSE);
    /* Now enable the option classes that should be turned on */
    for (v = class1; v; v = v->next)
	if (v->class == PROFILE_INTEGER)
	    if (!oinlist(opc->OC1, (int)v->value.i))
		setoption(1, (int)v->value.i, TRUE);
    for (v = class2; v; v = v->next)
	if (v->class == PROFILE_INTEGER)
	    if (!oinlist(opc->OC2, (int)v->value.i))
		setoption(2, (int)v->value.i, TRUE);
    for (v = class3; v; v = v->next)
	if (v->class == PROFILE_INTEGER)
	    if (!oinlist(opc->OC3, (int)v->value.i))
		setoption(3, (int)v->value.i, TRUE);
    for (v = class4; v; v = v->next)
	if (v->class == PROFILE_INTEGER)
	    if (!oinlist(opc->OC4, (int)v->value.i))
		setoption(4, (int)v->value.i, TRUE);
    fputs(PORTRAIT, stdout);
    printf("%s00000", SYNTAX);
    printf("%s%04d", LINESPACING, (int)(6.02 * 100));
    printf("%s0000011000", INITMARGVERT);
    printf("%s0025008500", INITMARGHORZ);
    printf("%s%d%s", DEFFONT, portraitfont, ENDCMD);
    printf("%s%04d", CHARSPACING, (int)(v->value.f * 100.0));
    fputs(FREEOFF, stdout);
    fputs(QUICOFF, stdout);
    while ((c = getchar()) != EOF) {
	if (c == '\n')
	    printf("\r\n");
	else if (c == 031)
	    if ((c = getchar()) == '\1') {
		fputs(QUICON, stdout);
		printf("%s0000008500", INITMARGHORZ);
		fputs(QUICOFF, stdout);
		(void)fflush(stdout);
		(void)kill(getpid(), SIGSTOP);
		continue;
	    } else {
		(void)putchar(031);
		(void)ungetc(c, stdout);
	    }
	else
	    (void)putchar(c);
    }
    qmsopcfree(opc);
    qmsclose();
#if defined(sun)
    (void)flock(fileno(stdout), LOCK_UN);
#endif
    exit(SUCCEED);
}

/* Returns true if the option class number is set in the passed list */
static Boolean oinlist(list, option)
struct optnode	*list;
int		option;
{
    for (; list; list = list->next)
	if (list->option == option)
	    return TRUE;
    return FALSE;
}

/* Returns true if option class number is set in the passed list */
static Boolean vinlist(list, option)
PROFILE_VALUE	*list;
int		option;
{
    for (; list; list = list->next)
	if (list->class == PROFILE_INTEGER && list->value.i == option)
	    return TRUE;
    return FALSE;
}

/* Enables or disables an option */
static void setoption(class, option, enable)
int	class;
int	option;
int	enable;
{
    if (class * 100 + option < 149 || 499 < class * 100 + option)
	return;
    printf("%s%s%d", PCONFIG, enable ? "" : ":", class * 100 + option);
    fprintf(stderr, "%s: Warning: %s printer option (%d,%d)\n", Whoami,
    enable ? "enabling" : "disabling", class, option);
}

/* Converts a baud rate from a number to the number you need to pass to
 * ioctl(2).
 */
static int convertspeed(b)
int b;
{
    struct Speeds   *s;

    for (s = Speeds; s->speed; s++)
	if (s->speed == b)
	    return s->code;
    return B9600;
}
