#ifndef lint
static char	*rcs = "$Header: pktoch.c,v 1.1 88/01/15 13:04:58 simpson Rel $";
#endif
/*
$Log:	pktoch.c,v $
 * Revision 1.1  88/01/15  13:04:58  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  18:31:11  simpson
 * beta test
 * 
*/
#include <stdio.h>
#include <local/standard.h>
#include "fontinfo.h"

char	*Usage = "Usage: %s <pk-file> <chr-file>\n";
char	*WhoAmI;
float	Version = 1.0;

main(argc, argv)
int	argc;
char	*argv[];
{
    int		c;
    extern int	optind;
    void	printrasters(), seteoffunction(), eofencountered();
    FILE	*output;
    struct FontInfo	*getfontinfo(), *fi;

    WhoAmI = argv[0];
    while ((c = getopt(argc, argv, "")) != EOF)
    	switch (c) {
	case '?':
err:	    fprintf(stderr, Usage, WhoAmI);
  	    exit(FAIL);
	}
    if (optind != argc - 2)
    	goto err;
    printf("This is PKtoCH, Version %.1f\n", Version);
    seteoffunction(eofencountered);
    if (!(fi = getfontinfo(argv[optind], 'X'))) {
	fprintf(stderr, "%s: %s is not readable or is not a pk file\n",
	WhoAmI, argv[optind]);
	exit(FAIL);
    }
    if (!(output = fopen(argv[++optind], "w"))) {
	fprintf(stderr, "%s: could not open %s\n", WhoAmI, argv[optind]);
	exit(FAIL);
    }
    fputs("Font file info :", output);
    fputs(fi->comment, output);
    (void)putc('\n', output);
    fprintf(output, "Design Size    :%ld\n", fi->ds);
    fprintf(output, "Checksum       :%ld\n", fi->cs);
    fprintf(output, "hppp           :%ld\n", fi->hppp);
    fprintf(output, "vppp           :%ld\n", fi->vppp);
    printrasters(argv[optind - 1], output);
    (void)fclose(output);
    printf("All done.\n");
    exit(SUCCEED);
}

void printrasters(infile, output)
char	*infile;
FILE	*output;
{
    struct CharInfo	*ci;
    void		printbitmap(), resetpkfile();

    resetpkfile();
    while (getnextcharinfo(infile, 'X', &ci) != 1) {
	(void)putc('\f', output);
	fprintf(output, "chrcode        :");
	if (' ' <= ci->cc && ci->cc <= '~')
	    fprintf(output, "'%c'\n", (int)ci->cc);
	else
	    fprintf(output, "%ld\n", ci->cc);
	fprintf(output, "tfm width      :%ld\n", ci->tfm);
	if (ci->preambletype == plong) {
	    fprintf(output, "dx             :%ld\n", ci->dxordm);
	    fprintf(output, "dy             :%ld\n", ci->dy);
	} else
	    fprintf(output, "dm             :%ld\n", ci->dxordm);
	fprintf(output, "width          :%ld\n", ci->w);
	fprintf(output, "height         :%ld\n", ci->h);
	fprintf(output, "h offset       :%ld\n", ci->hoff);
	fprintf(output, "v offset       :%ld\n", ci->voff);
	fprintf(output, "+\n");
	printbitmap(output, ci->bitmap, (int)ci->w, (int)ci->h);
    }
}

void eofencountered()
{
    fprintf(stderr, "%s: premature eof encountered in PK file\n", WhoAmI);
    exit(FAIL);
}

	
