#ifndef lint
static char *rcs = "$Header: table.c,v 1.1 88/01/15 13:05:34 simpson Rel $";
#endif
/*
$Log:	table.c,v $
 * Revision 1.1  88/01/15  13:05:34  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  18:31:22  simpson
 * beta test
 * 
*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <local/standard.h>

/* Routines for creating and querying the name table.  The name table is a
 * table of 2-tuples consisting of the name of a font and the font's
 * corresponding QMS number.
 */

static char	**NameTable;
static int	NameTableSize;		/* Current size of name table */
static int	TableEntriesAllocated;	/* # of entries allocated */
static int	BaseConstant;		/* Base constant to start #s */

/* Loads the names of all the fonts in the system font directory in the name
 * array.  A list of ROM font numbers is passed as an argument.  This list
 * is terminated by 0.  Indices occupied by ROM fonts are not given a name.
 * A base constant is also passed as a parameter. For example, TeX fonts are
 * numbered 1-10000, inclusive, so the number 1 would be passed.  Troff fonts
 * are numbered 10001-20000 so the number 10001 would be passed.  The 
 * routine returns TRUE on success, FALSE if the font directory could not be 
 * opened.
 */
Boolean loadnametable(directory, romlist, base)
char	*directory;
int     *romlist;
int     base;
{
    DIR			*dirp;
    struct direct	*direntry;
    int			*p;
    char		*malloc(), *realloc(), *strcpy();

    
    NameTableSize = 0, NameTable = NULL, BaseConstant = base;
    if (!(dirp = opendir(directory)))
	return FALSE;
    for (direntry = readdir(dirp); direntry; direntry = readdir(dirp)) {
    	if (direntry->d_namlen < 5 || !EQ("pk", &direntry->d_name[
	direntry->d_namlen - 2]))
	    continue;
tryagain:if (++NameTableSize + 1 > TableEntriesAllocated)
	    if (!NameTable)
		NameTable = (char **)malloc((unsigned)(TableEntriesAllocated = 
		500) * sizeof(char *));
	    else
		NameTable = (char **)realloc((char *)NameTable, (unsigned)
		((TableEntriesAllocated += 500) * sizeof(char *)));
	if (NameTableSize > 10000)
	    return TRUE;           /* Too many fonts, but don't give error */
	for (p = romlist; p && *p; p++)
	    if (base - 1 + NameTableSize == *p) {
		NameTable[NameTableSize] = NULL;
		goto tryagain;
	    }
	(void)strcpy(NameTable[NameTableSize] = malloc((unsigned)
	(direntry->d_namlen + 1)), direntry->d_name);
    }
    closedir(dirp);
    return TRUE;
}

/* Returns the QMS font number in the table NameTable. Returns -1 if not 
 * found 
 */
int getnumfromtable(s)
char	*s;
{
    int	i;

    for (i = 1; i <= NameTableSize; i++)
    	if (NameTable[i])
	    if (EQ(NameTable[i], s))
	    	return i + BaseConstant - 1;
    return -1;
}
