%{
#ifndef lint
static char *copyright = "Copyright (C) 1985, Sven Mattisson.";
#endif


/*
 * $Log:	doc2sty.l,v $
 * Revision 1.1  86/01/15  22:17:59  sven
 * Initial revision
 * 
 */

%}
%START	BOL INL
S	[ \t]+
T	[ \t]*
W	[ \t\f\n]
X	[^{W}]
%%
<BOL>^{T}%.*\n		;   /* comment line(s) */
<INL>{S}%.*\n		|
<INL>%.*\n/{W}		{putchar ('\n'); BEGIN BOL;}	/* trailing comment */
<INL>%.*\n/{X}		{printf ("%%\n"); BEGIN BOL;}	/* tricky comment */
<BOL>^{T}\n		;   /* empty line */
<BOL>^{S}		;   /* strip leading spaces */
<INL>{S}$		;   /* strip trailing spaces */
<INL>{S}/[^%]		{putchar (' ');}	/* compress spaces */
\\" "			|
.			{ECHO; BEGIN INL;}
\n			{ECHO; BEGIN BOL;}
%%
main(argc,argv)
	char **argv;
{
    int i;

    BEGIN BOL;
    if (argc==1) {
	yyin = stdin;
	yylex();
    } else for (i=1; i<argc; i++) {
	yyin = fopen(argv[i],"r");
	if (yyin==NULL) {
	    fprintf(stderr,"can't open %s\n",argv[i]);
	    exit(1);
	}
	yylex();
    }
    exit(0);
}

