/*
 * File:
 *
 *	global.h
 *
 * Author:
 *
 *	Brad Rullman
 *	Department of Computer Science  FR-35
 *	University of Washington
 *	Seattle, Washington  98155
 *	email: ecola@cs.washington.edu
 *
 *	Copyright @ March, 1987 - This program, or any subset of the functions
 *	herein, is not to be redistributed, or used for personal or commercial
 *	gain in the form of fame, fortune, or shorter working hours, without
 *	the consent of the author.
 *
 * Function:
 *
 *	Include that contains declarations of global data used 
 *	throughout the FontTool code, including the external
 *	declarations of the global data	defined in global.c.
 */

#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>

/*
 * Miscellaneous defines.
 */
#define MAXFILENAMLEN 	64	/* maximum acceptable length of a file name */
#define MINVIEWSWWIDTH	60	/* default width of view subwindow */
#define MINVIEWSWHEIGHT	60	/* default height of view subwindow */
#define MAXVIEWSWWIDTH	600	/* maximum width of view subwindow */
#define MAXVIEWSWHEIGHT	600	/* maximum height of view subwindow */
#define FRAMEMARGIN	5	/* breadth of margin around frame */
#define SWSPACING	5	/* space between adjacent subwindows */
#define WHITE		0	/* white paint */
#define BLACK		1	/* black paint */
#define MIN(x,y)	(((x)<(y)) ? (x) : (y))
#define MAX(x,y)	(((x)<(y)) ? (y) : (x))

/*
 * Option subwindow defines.
 */
#define MAXMAG		10	/* largest magnification available */

#define MODEPOINTS	0	/* mouse modes */
#define MODELINES	1
#define MODEFILL	2
#define MODEMOVE	3

#define CELLNORMAL	0	/* Paint subwindow cell types */
#define CELLWRITEBLACK	1
#define CELLWRITEWHITE	2

/*
 * FontTool writes 1-by-1 pixels to the ViewSW, and cells of
 * Magnification-by-Magnification pixels (representing 1 ViewSW pixel)
 * to the PaintSW.  SCALEUP scales a coordinate up to magnified PaintSW size.
 */
#define SCALEUP(x)	(((x)*Magnification))

/*
 * Scale a magnified coordinate down to true (ViewSW) size.
 */
#define SCALEDOWN(x)	((int) ((x)/Magnification))

/*
 * Clear the contents of the given pixrect.
 */
#define CLEARPR(pr) (pr_rop(pr, 0, 0, pr->pr_size.x, pr->pr_size.y,\
			    PIX_CLR, (struct pixrect *) NULL, 0, 0))

/*
 * Copy the contents of one pixrect into another pixrect of equal size.
 */
#define COPYPR(frompr, topr)	(pr_rop(topr, 0, 0,\
					topr->pr_size.x, topr->pr_size.y,\
					PIX_SRC, frompr, 0, 0))

/*
 * The following macro "clears" UndoReferenceXY, indicating that "Move
 * Reference Point" was not the previous paint operation that was done.
 */
#define CLEARUNDOREFPT	UndoReferenceXY.x = UndoReferenceXY.y = -1

/*
 * The following macro "sets" UndoReferenceXY, indicating that "Move
 * Reference Point" WAS the previous paint operation that was done.
 */
#define SETUNDOREFPT	UndoReferenceXY.x = ReferenceXY.x;\
			UndoReferenceXY.y = ReferenceXY.y

/*
 * Set each subwindow's cursor to the one it normally has.
 */
#define SETCURSORNORMAL	window_set(MessageSW, WIN_CURSOR, MainCursor, 0);\
			window_set(OptionSW, WIN_CURSOR, MainCursor, 0);\
			window_set(ViewSW, WIN_CURSOR, MainCursor, 0);\
			window_set(PaintSW, WIN_CURSOR, PaintCursor, 0)

/*
 * Set each subwindow's cursor to a "watch".
 */
#define SETCURSORWATCH	window_set(MessageSW, WIN_CURSOR, WatchCursor, 0);\
			window_set(OptionSW, WIN_CURSOR, WatchCursor, 0);\
			window_set(ViewSW, WIN_CURSOR, WatchCursor, 0);\
			window_set(PaintSW, WIN_CURSOR, PaintWatchCursor, 0)

/*
 ******************** Globals for the SunView package ************************
 */

extern Frame	FontToolFrame;
extern Panel	MessageSW, OptionSW;
extern Canvas	ViewSW, PaintSW;
extern Pixwin	*ViewPW, *PaintPW;

extern Rect 	MessageRect, ViewRect, OptionRect, PaintRect;

extern int	OptionSWHeight;

/*
 ******************** Global pixrects and associated data ********************
 */

extern Pixrect		*ViewPR, *UndoPR, *PaintPR, *ReferencePoint;
extern Rect		UndoRect;
extern struct pr_pos	ReferenceXY, UndoReferenceXY;
extern int		RasterChanged;

/*
 ******************** Option globals *****************************************
 */

extern int		Magnification, CellType, CellOffset, MouseMode, 
			PaintColor;
extern Pixrect 		*CellMask;

/*
 ******************** Cell Masks *********************************************
 */

extern Pixrect 		WriteBlackCell10, WriteBlackCell8, WriteBlackCell6,
			WriteBlackCell4;

/*
 ******************** FontTool cursors ***************************************
 */

extern struct pixrect	CursorPR, WatchCursorPR;
extern Cursor		MainCursor, PaintCursor, WatchCursor,
			PaintWatchCursor;
