#include <stdio.h>
#ifdef MSDOS
extern int errno;
#else
#include <errno.h>
#endif
#ifdef GOULD_NP1
extern int errno;
#endif

#ifdef vms
extern int strcmp();
extern int strlen();
extern char *strcpy();
extern char *strncpy();
#else
# include <string.h>
#endif


#define	SAME	0	/* for strcmp() */

#include "help.h"	/* values passed back */

/* help -- help subsystem that understands defined keywords
**
** Looks for the desired keyword in the help file at runtime, so you
** can give extra help or supply local customizations by merely editing
** the help file.
**
** The original (single-file) idea and algorithm is by John D. Johnson,
** Hewlett-Packard Company.  Thanx and a tip of the Hatlo hat!
**
** The help file looks like (the question marks are really in column 1):
** 
** 	?topic
** 	This line is printed when the user wants help on "topic".
** 	?keyword
** 	?Keyword
** 	?KEYWORD
** 	These lines will be printed on the screen if the user wanted
** 	help on "keyword", "Keyword", or "KEYWORD".  No casefolding is
**	done on the keywords.
** 	?subject
** 	?alias
** 	This line is printed for help on "subject" and "alias".
** 	?
**	??
** 	Since there is a null keyword for this line, this section
** 	is printed when the user wants general help (when a help
** 	keyword isn't given).  A command summary is usually here.
**	Notice that the null keyword is equivalent to a "?" keyword
**	here, because of the '?' and '??' topic lines above.
** 	?last-subject
** 	Note that help sections are terminated by the start of the next
** 	'?' entry or by EOF.  So you can't have a leading '?' on a line
** 	of any help section.  You can re-define the magic character to
**	recognize in column 1, though, if '?' is too useful.  (Try ^A.)
*/

#define	KEYFLAG	'?'	/* leading char in help file topic lines */

/*
** Calling sequence:
**	int result;		# 0 == success
**	char *keyword;		# topic to give help on
**	char *pathname;		# path of help file
**	result = help(keyword, pathname);
** Sample:
**	cmd = "search\n";
**	helpfile = "/usr/local/lib/program/program.help";
**	if (help(cmd, helpfile) != H_FOUND)
**		printf("Sorry, no help for %s", cmd);
**
**
** Speed this up by replacing the stdio calls with open/close/read/write.
*/
#ifdef	WDLEN
#  define	PATHSIZE	WDLEN
#else
#  define	PATHSIZE	BUFSIZ
#endif

help(keyword, path)	/* print a help message */
	char *keyword;	/* on this topic */
	char *path;	/* from this file */
{
	static char oldpath[PATHSIZE] = '\0';	/* previous help file */
	char *oldpathp = oldpath;	/* pointer to same */

	static FILE *helpfp = NULL;
	FILE *fopen();

	char buf[BUFSIZ];	/* line from help file */
	char *bufp = buf;	/* pointer to same */
	char *bufkeyp = bufp + 1;	/* start of key in help line */

/*
** Open the help file if necessary (say, first time we enter this routine,
** or if the help file changes from the last time we were called).
*/
	errno = 0;
	if (strcmp(oldpathp, path) == SAME)
		rewind(helpfp);	/* start at the beginning each time */
	else
	{	/* first time the user asked for help using this file */
		if ((helpfp = fopen(path, "r")) == NULL)
		{	/* can't open help file, so error exit */
			return H_ERROR;
		}
		/* save the new path in oldpath */
		if (strlen(path) < sizeof oldpath)
			strcpy(oldpathp, path);
		else
		{	/* not enough room in oldpath, sigh */
			strncpy(oldpathp, path, sizeof oldpath);
			oldpath[sizeof oldpath] = NULL;
		}
	}

/*
** The correct help file is open.  Look in there for the keyword.
*/
	while (fgets(buf, sizeof buf, helpfp) != NULL)
	{	/*
		** If we find the keyword:
		**	skip to the first non-keyword line
		**	print lines until you find another keyword line or EOF
		**	return success
		*/
		if (buf[0] == KEYFLAG && strcmp(keyword, bufkeyp) == SAME)
		{	/* found the key */
			while (fgets(buf, sizeof buf, helpfp) != NULL
				&& buf[0] == KEYFLAG)
				;	/* eat additional keyword lines */

			fputs(bufp, stdout);		/* print help */
			while (fgets(buf, sizeof buf, helpfp) != NULL
				&& buf[0] != KEYFLAG)
				fputs(bufp, stdout);	/* print help */
			return H_FOUND;
		}
	}

/* 
** Didn't find anything in the help file for the poor user.  Return failure.
** Don't close the help file!  The luser may want further help, and
** re-opening an already-open help file is wasteful of time.
*/
	return H_NOTFOUND;
}
