(defun 

    (TeX-double-quote lpos rpos
	(if (= '\\' (preceding-char))
	    (insert-character '"')
	    (progn 
		   (save-excursion 
		       (setq lpos 0)
		       (setq rpos 0)
		       (set-mark)
		       (error-occured 
			   (search-reverse "``")
			   (setq lpos (dot))
			   (exchange-dot-and-mark)
			   (search-reverse "''")
			   (setq rpos (dot)))
		   )
		   (if (> lpos rpos)
		       (insert-string "''")
		       (insert-string "``"))))
    )
    
    (insert-TeX-aux-macros
	(beginning-of-line)
	(insert-string (concat "% \\noflash{...text...} makes a box as wide"
			       " as its arg, but which is whitespace\n"
			       "\\def\\noflash#1{\\setbox0=\\hbox{#1}\\hbox"
			       " to 1\\wd0{\\hfill}}\n"))
    )
    
    
    (skip-white-space
	(re-search-forward "[^	 ]")
	(backward-character)
    )
    
    (setup-indented-TeX-display prior nfl-ins padding col
	(save-excursion 
	    (delete-region-to-buffer "TeX indent temp")
	    (temp-use-buffer "TeX indent temp")
	    (beginning-of-file)
	    (setq padding "                    ")
	    (setq prior padding)
	    (while (! (eobp))
		   (skip-white-space)
		   (setq col (current-column))
		   (delete-white-space)
		   (if (eolp)
		       (insert-string "\\vskip 5pt")
		       (progn 
			      (setq nfl-ins (substr prior 1 (- col 1)))
			      (if (= (length nfl-ins) 0)
				  (insert-string "\\hbox{")
				  (insert-string (concat "\\hbox{\\noflash{"
							 nfl-ins "}")))
			      (set-mark)
			      (end-of-line)
			      (setq prior (concat nfl-ins (region-to-string)
						  padding))
			      (insert-character '}'))
		   )
		   (next-line)
		   (beginning-of-line)
	    )
	    (insert-character '}')
	    (beginning-of-file)
	    (insert-string "\\vbox{")
	)
	(yank-buffer "TeX indent temp")
	(novalue)
    )
    
    
    (unsetup-indented-TeX-display
	(search-reverse "\\vbox{")
	(set-mark)
	(forward-paren)
	(save-excursion 
	    (delete-region-to-buffer "TeX indent temp")
	    (temp-use-buffer "TeX indent temp")
	    (end-of-file)
	    (delete-previous-character)
	    (beginning-of-file)
	    (provide-prefix-argument 6 (delete-next-character))
	    (while (! (eobp))
		   (delete-next-character)
		   (if (!= 'h' (following-char))
		       ; a \vskip line (blank)
		       (kill-to-end-of-line)
		       ; an \hbox line
		       (progn
			     (provide-prefix-argument 5
				 (delete-next-character))
			     (if (= '\\' (following-char))
			         (replace-noflash))
			     (end-of-line)
			     (delete-previous-character)
		       )
		   )
		   (next-line)
		   (beginning-of-line)
	    )
	)
	(yank-buffer "TeX indent temp")
	(novalue)
    )

    (replace-noflash col
	(set-mark)
	(search-forward "}")
	(setq col (current-column))
	(delete-to-killbuffer)
	(to-col (- col 10))
    )

    (beginning-of-math-region pdot
	(set-mark)
	(insert-character '}')
	(if (error-occured 
		(backward-paren))
	    (beginning-of-file))
	(setq pdot (dot))
	(exchange-dot-and-mark)
	(delete-next-character)
	(if (error-occured 
		(search-reverse "%emacs-mathOK"))
	    (beginning-of-file))
	(if (< (dot) pdot)
	    (exchange-dot-and-mark))
    )

    (in-math-mode mm-count
	(insert-character ' ')
	(save-excursion enddot c
	    (setq enddot (dot))
	    (beginning-of-math-region)
	    (if (= '\$' (following-char))
		(setq mm-count 1)
		(setq mm-count 0))
	    (while (& (! (error-occured 
			     (re-search-forward "[^\\\$]\$\$*[^\$]")
			     (backward-character)))
		      (<= (dot) enddot))
		   (setq mm-count (+ mm-count 1))
	    )
	)
	(delete-previous-character)
	(% mm-count 2)
    )

    (TeX-end-math-region
	(if (in-math-mode)
	    (error-message "You're still in math mode!")
	    (progn 
		   (if (! (bolp))
		       (insert-character '\n'))
		   (insert-string "%emacs-mathOK\n")
	    )
	)
    )
    
    (check-too-many-$ l$
				; Checks if 3 $s are just before cursor.
				; Complains in \$$$ case as well.
	(save-excursion 
	    (setq l$ (dot))
	    (while (= (preceding-char) '$')
		   (backward-character))
	    (if (> (- l$ (dot)) 2)
		(error-message "Too many '$'s"))
	)
    )

    (rev-find-mm$
	(error-occured 
	    (re-search-reverse "[^\\\$]\$\$*[^\$]")
	    (forward-character))
    )

    (TeX-$ c
	  (setq c (preceding-char))
	  (insert-character (last-key-struck))
	  (if (& (!= c '\\') (! (in-math-mode)))
	      (save-excursion 
		  (if (! (eobp))
		      (re-search-reverse "[^\\\$]\$\$*[^\$]"))
		  (if (error-occured 
			  (re-search-reverse "[^\\\$]\$\$*[^\$]")
			  (forward-character))
		      (beginning-of-file))		      
		  (if (dot-is-visible)
		      (sit-for 5)
		      (progn
			    (beginning-of-line)
			    (set-mark)
			    (end-of-line)
			    (message (region-to-string)))
		  )
	      )
	  )
	  (check-too-many-$) 
    )
	      
	      
    (c-paren
	    (insert-character (last-key-struck))
	    (save-excursion
		(backward-paren)
		(if (dot-is-visible)
		    (sit-for 5)
		    (progn
			  (beginning-of-line)
			  (set-mark)
			  (end-of-line)
			  (message (region-to-string)))
		)
	    )
    )
	      
    (TeX-brace
	(if (= (preceding-char) '\\')
	    (insert-character (last-key-struck))
	    (c-paren)
	)
    )

    (TeX-mode
	(local-bind-to-key "justify-paragraph" (+ 128 'j'))
	(local-bind-to-key "TeX-end-math-region" (+ 128 '$'))
	(local-bind-to-key "TeX-brace" '}')
	(if (! (is-bound TeX-inhibit-$))
	    (local-bind-to-key "TeX-$" '$'))
	(if (is-bound TeX-expand-quote)
	    (local-bind-to-key "TeX-double-quote" '\"'))
	(setq right-margin 77)
	(setq mode-string "TeX")
	(setq case-fold-search 1)
	(use-syntax-table "text-mode")
	(modify-syntax-entry "(}   {")
	(modify-syntax-entry "){   }")
	(modify-syntax-entry "\\    \\")
	(use-abbrev-table "text-mode")
	(setq left-margin 1)
	(novalue)
    )
)
