/* 
 *	Fig2latex : Fig-to-LaTeX translator
 *
 *	Instalation dependent constants:
 *
 *	  THINDOT	diameter of a dot if line width = \thinlines
 *
 *	  THICKDOT	diameter of a dot if line width = \thicklines
 *
 *	  MIN_LEN	shortest slanted line that latex can produce
 *			shorter lines will we translated into a sequence
 *			of dots generated by a \multiput.
 *
 *	  THICK_LDOT	diameter of the dot for making short slanted lines
 *			 if line width = \thinlines
 *	  THIN_LDOT	...  if line width = \thicklines
 */
 
#define THICKDOT	(1.5/72.0)	/* 1.5 points */
#define THINDOT		(1.0/72.0)	/* 1.0 points */
#define MIN_LEN		(13.0/72.0)	/* 13  points */
#define THICK_LDOT	(1.1/72.0)	/* 1.1 points */
#define THIN_LDOT	(0.7/72.0)	/* 0.7 points */
