/* 
 *	FIG : Facility for Interactive Generation of figures
 *
 *	(c) copy right 1985 by Supoj Sutanthavibul (paul@ut-sally.ARPA)
 *
 *	University of Texas at Austin,
 *
 *	January 1985.
 *
 *	Major revision : Aug 1985.
 *
 *	@(#)object.h	1.2  10/12/85
*/
struct point			{ int			 x, y;
				  struct point		*next;
				};

struct position			{ int	x, y };

struct ellipse_object		{ int			 type, style;
				  int			 thickness;
				  float			 dash_length;
				  int			 direction;
				  struct position	 center;
				  struct position	 radiuses;
				  struct position	 start;
				  struct position	 end;
				  struct ellipse_object	*next;
				};

struct arc_object		{ int			 type, style;
				  int			 thickness;
				  float			 dash_length;
				  int			 direction;
				  int			 forward_arrow;
				  int			 backward_arrow;
				  int			 arrow_wid, arrow_ht;
				  struct {float x, y;}	 center;
				  struct position	 point[3];
				  struct arc_object	*next;
				};

struct line_object		{ int			 type, style;
				  int			 thickness;
				  float			 dash_length;
				  int			 forward_arrow;
				  int			 backward_arrow;
				  int			 arrow_wid, arrow_ht;
				  struct point		*point;
				  struct line_object	*next;
				};

struct text_object		{ int			 font, size, style;
				  int			 height, length;
				  struct position	 swcorner;
				  char			*cstring;
				  struct text_object	*next;
				};

struct spline_object		{ int			 type, style;
				  int			 thickness;
				  float			 dash_length;
				  int			 forward_arrow; 
				  int			 backward_arrow;
				  int			 arrow_wid, arrow_ht;
				  struct point		*point;
				  struct spline_object	*next;
				};

struct compound_object		{ struct position	 nwcorner;
				  struct position	 secorner;
				  struct line_object	*lines;
				  struct ellipse_object	*ellipses;
				  struct spline_object	*splines;
				  struct text_object	*texts;
				  struct arc_object	*arcs;
				  struct compound_object	*compounds;
				  struct compound_object	*next;
				};

#define				POINT_SIZE	sizeof(struct point)

#define				ELLOBJ_SIZE	sizeof(struct ellipse_object)
#define				ARCOBJ_SIZE	sizeof(struct arc_object)
#define				LINOBJ_SIZE	sizeof(struct line_object)
#define				TEXOBJ_SIZE	sizeof(struct text_object)
#define				SPLOBJ_SIZE	sizeof(struct spline_object)
#define				COMOBJ_SIZE	sizeof(struct compound_object)

/**********************  Generic object code  **********************/

#define				ELLIPSE		1
#define				POLYLINE	2
#define				SPLINE		3
#define				TEXT		4
#define				ARC		5
#define				COMPOUND	6
#define				END_COMPOUND	-COMPOUND

/***********************  Object attributes  *************************/

#define				SOLID_LINE	0
#define				DASH_LINE	1
#define				DOTTED_LINE	2
