#ifndef lint
static char RCSid[] = "$Header: calledit.c,v 1.0 86/01/31 14:58:43 richards Released $";
#endif

/*
** CALLEDIT.C -- external procedures:
**
**	procedure calledit(
**			var	filename:	ASCIIcode;
**				fnlength,
**				linenumber:	integer		);
**		{ invoke the system editor on "filename" (of length fnlength) }
**		{ to start on line "linenumber" of the file		      }
**		{ the editor is started using environment variable MFEDITOR   }
**		{ as a pattern for constructing the arguments to the editor   }
*/

#include <stdio.h>
#define	EXTERN	extern
#include "../mfd.h"

#ifdef	SYSV
extern int sprintf();
#else
extern char *sprintf();
#endif

/*
**  The following procedure is due to sjc@s1-c.
**
**	calledit(filename, fnlength, linenumber)
**
**  MetaFont84 can call this to implement the 'e' feature in error-recovery
**  mode, invoking a text editor on the erroneous source file.
**  
**  You should pass to "filename" the first character of the packed array
**  containing the filename, and to "fnlength" the size of the filename.
**  
**  Ordinarily, this invokes "/usr/ucb/vi". If you want a different
**  editor, create a shell environment variable MFEDITOR containing
**  the string that invokes that editor, with "%s" indicating where
**  the filename goes and "%d" indicating where the decimal
**  linenumber (if any) goes. For example, a MFEDITOR string for a
**  variant copy of "vi" might be:
**  
**	setenv MFEDITOR "/usr/local/bin/vi +%d %s"
**  
*/

   char *getenv(), *malloc();
   char *mfeditvalue = EDITOR;

calledit(filename, fnstart, fnlength, linenumber)
ASCIIcode filename[];
poolpointer fnstart;
integer fnlength, linenumber;
{
    char *temp, *command, c;
    int sdone, ddone, i;

    sdone = ddone = 0;
    filename += fnstart;

    /* Close any open input files */
    for (i=1; i <= inopen; i++)
	(void) fclose(inputfile[i]);

    /* Replace default with environment variable if possible. */
    if (NULL != (temp = (char *) getenv("MFEDITOR")))
	 mfeditvalue = temp;

    /* Make command string containing envvalue, filename, and linenumber */
    if (! (command = malloc((unsigned) (strlen(mfeditvalue)+fnlength+25)))) {
	 fprintf(stderr, "! Not enough memory to issue editor command\n");
	 exit(1);
    }
    temp = command;
    while ((c = *mfeditvalue++) != '\0') {
	if (c == '%') {
	    switch (c = *mfeditvalue++) {
	    case 'd': 
		if (ddone) {
		    fprintf(stderr,
		       "! Line number cannot appear twice in editor command\n");
		    exit(1);
		}
		(void) sprintf(temp, "%d", linenumber);
		while (*temp != '\0')
		    temp++;
		ddone = 1;
		break;
	    case 's':
		if (sdone) {
		    fprintf(stderr,
			"! Filename cannot appear twice in editor command\n");
		    exit(1);
		}
		i = 0;
		while (i < fnlength)
		    *temp++ = filename[i++];
		sdone = 1;
		break;
	    case '\0':
		*temp++ = '%';
		mfeditvalue--; /* Back up to \0 to force termination. */
		break;
	    default:
		*temp++ = '%';
		*temp++ = c;
		break;
	    }
	}
	else
	    *temp++ = c;
    }
    *temp = '\0';

    /* Execute command. */
    if (system(command) != 0)
	 fprintf(stderr, "! Trouble executing command %s\n", command);

    /* Quit, indicating MetaFont had found an error before you typed "e". */
    exit(1);
}
