#include "web2c.h"
/* 9999 */ 
#define tfmsize 20000 
typedef unsigned char byte  ; 
typedef integer index  ; 
file_ptr /* of  unsigned char */ tfmfile  ; 
char tfmname[101]  ; 
short lf, lh, bc, ec, nw, nh, nd, ni, nl, nk, ne, np  ; 
text plfile  ; 
char plname[101]  ; 
byte 
#define tfm (zzzaa +1000)
  zzzaa[tfmsize + 1001]  ; 
integer charbase, widthbase, heightbase, depthbase, italicbase, ligkernbase, 
kernbase, extenbase, parambase  ; 
schar fonttype  ; 
ccharpointer ASCII04, ASCII10, ASCII14  ; 
ccharpointer MBLstring, RIstring, RCEstring  ; 
schar dig[12]  ; 
schar level  ; 
schar charsonline  ; 
boolean perfect  ; 
short i  ; 
byte c, r  ; 
index k  ; 
struct {
    byte cc ; 
  short rr ; 
} labeltable[258]  ; 
short labelptr  ; 
short sortptr  ; 
boolean active  ; 

#include "tftopl.h"
void initialize ( ) 
{(void) fprintf(stdout, "%s\n", "This is TFtoPL, C Version 2.5" ) ; 
  if ( argc < 3 ) 
  {
    (void) fprintf(stdout, "%s\n", "Usage: tftopl <tfm-file> <pl-file>" ) ; 
    uexit ( 1 ) ; 
  } 
  argv ( 1 , tfmname ) ; 
  reset ( tfmfile , tfmname ) ; 
  argv ( 2 , plname ) ; 
  rewrite ( plfile , plname ) ; 
  ASCII04 = "  !\"#$%&'()*+,-./0123456789:;<=>?" ; 
  ASCII10 = " @ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_" ; 
  ASCII14 = " `abcdefghijklmnopqrstuvwxyz{|}~ " ; 
  MBLstring = " MBL" ; 
  RIstring = " RI " ; 
  RCEstring = " RCE" ; 
  level = 0 ; 
  charsonline = 0 ; 
  perfect = true ; 
  labelptr = 0 ; 
  labeltable [ 0 ] .rr = 0 ; 
} 
void zoutdigs ( j ) 
integer j ; 
{do {
    j = j - 1 ; 
    (void) fprintf( plfile , "%ld",  (long)dig [ j ] ) ; 
  } while ( ! ( j == 0 ) ) ; 
} 
void zprintdigs ( j ) 
integer j ; 
{do {
    j = j - 1 ; 
    (void) fprintf(stdout, "%ld", (long)dig [ j ] ) ; 
  } while ( ! ( j == 0 ) ) ; 
} 
void zprintoctal ( c ) 
byte c ; 
{schar j  ; 
  (void) putc('\'' , stdout);
  {register integer for_end; j = 0 ; for_end = 2 ; if ( j <= for_end) do 
    {
      dig [ j ] = c % 8 ; 
      c = c / 8 ; 
    } 
  while ( j++ < for_end ) ; } 
  printdigs ( 3 ) ; 
} 
void outln ( ) 
{schar l  ; 
  (void) putc('\n',  plfile );
  {register integer for_end; l = 1 ; for_end = level ; if ( l <= for_end) do 
    (void) Fputs( plfile ,  "   " ) ; 
  while ( l++ < for_end ) ; } 
} 
void left ( ) 
{level = level + 1 ; 
  (void) putc( '(' ,  plfile );
} 
void right ( ) 
{level = level - 1 ; 
  (void) putc( ')' ,  plfile );
  outln () ; 
} 
void zoutBCPL ( k ) 
index k ; 
{schar l  ; 
  (void) putc( ' ' ,  plfile );
  l = tfm [ k ] ; 
  while ( l > 0 ) {
      
    k = k + 1 ; 
    l = l - 1 ; 
    switch ( tfm [ k ] / 32 ) 
    {case 1 : 
      (void) putc( ASCII04 [ 1 + ( tfm [ k ] % 32 ) ] ,  plfile );
      break ; 
    case 2 : 
      (void) putc( ASCII10 [ 1 + ( tfm [ k ] % 32 ) ] ,  plfile );
      break ; 
    case 3 : 
      (void) putc( ASCII14 [ 1 + ( tfm [ k ] % 32 ) ] ,  plfile );
      break ; 
    } 
  } 
} 
void zoutoctal ( k , l ) 
index k ; 
index l ; 
{short a  ; 
  schar b  ; 
  schar j  ; 
  (void) Fputs( plfile ,  " O " ) ; 
  a = 0 ; 
  b = 0 ; 
  j = 0 ; 
  while ( l > 0 ) {
      
    l = l - 1 ; 
    if ( tfm [ k + l ] != 0 ) 
    {
      while ( b > 2 ) {
	  
	dig [ j ] = a % 8 ; 
	a = a / 8 ; 
	b = b - 3 ; 
	j = j + 1 ; 
      } 
      switch ( b ) 
      {case 0 : 
	a = tfm [ k + l ] ; 
	break ; 
      case 1 : 
	a = a + 2 * tfm [ k + l ] ; 
	break ; 
      case 2 : 
	a = a + 4 * tfm [ k + l ] ; 
	break ; 
      } 
    } 
    b = b + 8 ; 
  } 
  while ( ( a > 0 ) || ( j == 0 ) ) {
      
    dig [ j ] = a % 8 ; 
    a = a / 8 ; 
    j = j + 1 ; 
  } 
  outdigs ( j ) ; 
} 
void zoutchar ( c ) 
byte c ; 
{if ( fonttype > 0 ) 
  {
    tfm [ 0 ] = c ; 
    outoctal ( 0 , 1 ) ; 
  } 
  else if ( ( c >= 48 ) && ( c <= 57 ) ) 
  (void) fprintf( plfile , "%s%ld",  " C " , (long)c - 48 ) ; 
  else if ( ( c >= 65 ) && ( c <= 90 ) ) 
  (void) fprintf( plfile , "%s%c",  " C " , ASCII10 [ c - 63 ] ) ; 
  else if ( ( c >= 97 ) && ( c <= 122 ) ) 
  (void) fprintf( plfile , "%s%c",  " C " , ASCII14 [ c - 95 ] ) ; 
  else {
      
    tfm [ 0 ] = c ; 
    outoctal ( 0 , 1 ) ; 
  } 
} 
void zoutface ( k ) 
index k ; 
{schar s  ; 
  schar b  ; 
  if ( tfm [ k ] >= 18 ) 
  outoctal ( k , 1 ) ; 
  else {
      
    (void) Fputs( plfile ,  " F " ) ; 
    s = tfm [ k ] % 2 ; 
    b = tfm [ k ] / 2 ; 
    (void) fprintf( plfile , "%ld",  (long)MBLstring [ 1 + ( b % 3 ) ] ) ; 
    (void) fprintf( plfile , "%ld",  (long)RIstring [ 1 + s ] ) ; 
    (void) fprintf( plfile , "%ld",  (long)RCEstring [ 1 + ( b / 3 ) ] ) ; 
  } 
} 
void zoutfix ( k ) 
index k ; 
{short a  ; 
  integer f  ; 
  schar j  ; 
  integer delta  ; 
  (void) Fputs( plfile ,  " R " ) ; 
  a = ( tfm [ k ] * 16 ) + ( tfm [ k + 1 ] / 16 ) ; 
  f = ( ( tfm [ k + 1 ] % 16 ) * toint ( 256 ) + tfm [ k + 2 ] ) * 256 + tfm [ 
  k + 3 ] ; 
  if ( a > 2047 ) 
  {
    (void) putc( '-' ,  plfile );
    a = 4096 - a ; 
    if ( f > 0 ) 
    {
      f = 1048576L - f ; 
      a = a - 1 ; 
    } 
  } 
  {
    j = 0 ; 
    do {
	dig [ j ] = a % 10 ; 
      a = a / 10 ; 
      j = j + 1 ; 
    } while ( ! ( a == 0 ) ) ; 
    outdigs ( j ) ; 
  } 
  {
    (void) putc( '.' ,  plfile );
    f = 10 * f + 5 ; 
    delta = 10 ; 
    do {
	if ( delta > 1048576L ) 
      f = f + 524288L - ( delta / 2 ) ; 
      (void) fprintf( plfile , "%ld",  (long)f / 1048576L ) ; 
      f = 10 * ( f % 1048576L ) ; 
      delta = delta * 10 ; 
    } while ( ! ( f <= delta ) ) ; 
  } 
} 
void zcheckBCPL ( k , l ) 
index k ; 
index l ; 
{index j  ; 
  byte c  ; 
  if ( tfm [ k ] >= l ) 
  {
    {
      perfect = false ; 
      if ( charsonline > 0 ) 
      (void) fprintf(stdout, "%c\n", ' ' ) ; 
      charsonline = 0 ; 
      (void) fprintf(stdout, "%s%s\n", "Bad TFM file: " ,       "String is too long; I've shortened it drastically." ) ; 
    } 
    tfm [ k ] = 1 ; 
  } 
  {register integer for_end; j = k + 1 ; for_end = k + tfm [ k ] ; if ( j <= 
  for_end) do 
    {
      c = tfm [ j ] ; 
      if ( ( c == 40 ) || ( c == 41 ) ) 
      {
	{
	  perfect = false ; 
	  if ( charsonline > 0 ) 
	  (void) fprintf(stdout, "%c\n", ' ' ) ; 
	  charsonline = 0 ; 
	  (void) fprintf(stdout, "%s%s\n", "Bad TFM file: " ,           "Parenthesis in string has been changed to slash." ) ; 
	} 
	tfm [ j ] = 47 ; 
      } 
      else if ( ( c < 32 ) || ( c > 126 ) ) 
      {
	{
	  perfect = false ; 
	  if ( charsonline > 0 ) 
	  (void) fprintf(stdout, "%c\n", ' ' ) ; 
	  charsonline = 0 ; 
	  (void) fprintf(stdout, "%s%s\n", "Bad TFM file: " ,           "Nonstandard ASCII code has been blotted out." ) ; 
	} 
	tfm [ j ] = 63 ; 
      } 
      else if ( ( c >= 97 ) && ( c <= 122 ) ) 
      tfm [ j ] = c - 32 ; 
    } 
  while ( j++ < for_end ) ; } 
} 
boolean organize ( ) 
{/* 9999 30 */ register boolean Result; index tfmptr  ; 
  read ( tfmfile , tfm [ 0 ] ) ; 
  if ( tfm [ 0 ] > 127 ) 
  {
    (void) fprintf(stdout, "%s\n", "The first byte of the input file exceeds 127!" ) ; 
    (void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
    goto lab9999 ; 
  } 
  if ( eof ( tfmfile ) ) 
  {
    (void) fprintf(stdout, "%s\n", "The input file is only one byte long!" ) ; 
    (void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
    goto lab9999 ; 
  } 
  read ( tfmfile , tfm [ 1 ] ) ; 
  lf = tfm [ 0 ] * 256 + tfm [ 1 ] ; 
  if ( lf == 0 ) 
  {
    (void) fprintf(stdout, "%s\n", "The file claims to have length zero, but that's impossible!" ) 
    ; 
    (void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
    goto lab9999 ; 
  } 
  if ( 4 * lf - 1 > tfmsize ) 
  {
    (void) fprintf(stdout, "%s\n", "The file is bigger than I can handle!" ) ; 
    (void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
    goto lab9999 ; 
  } 
  {register integer for_end; tfmptr = 2 ; for_end = 4 * lf - 1 ; if ( tfmptr 
  <= for_end) do 
    {
      if ( eof ( tfmfile ) ) 
      {
	(void) fprintf(stdout, "%s\n", "The file has fewer bytes than it claims!" ) ; 
	(void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
	goto lab9999 ; 
      } 
      read ( tfmfile , tfm [ tfmptr ] ) ; 
    } 
  while ( tfmptr++ < for_end ) ; } 
  if ( ! eof ( tfmfile ) ) 
  {
    (void) fprintf(stdout, "%s\n", "There's some extra junk at the end of the TFM file," ) ; 
    (void) fprintf(stdout, "%s\n", "but I'll proceed as if it weren't there." ) ; 
  } 
  {
    tfmptr = 2 ; 
    {
      if ( tfm [ tfmptr ] > 127 ) 
      {
	(void) fprintf(stdout, "%s\n", "One of the subfile sizes is negative!" ) ; 
	(void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
	goto lab9999 ; 
      } 
      lh = tfm [ tfmptr ] * 256 + tfm [ tfmptr + 1 ] ; 
      tfmptr = tfmptr + 2 ; 
    } 
    {
      if ( tfm [ tfmptr ] > 127 ) 
      {
	(void) fprintf(stdout, "%s\n", "One of the subfile sizes is negative!" ) ; 
	(void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
	goto lab9999 ; 
      } 
      bc = tfm [ tfmptr ] * 256 + tfm [ tfmptr + 1 ] ; 
      tfmptr = tfmptr + 2 ; 
    } 
    {
      if ( tfm [ tfmptr ] > 127 ) 
      {
	(void) fprintf(stdout, "%s\n", "One of the subfile sizes is negative!" ) ; 
	(void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
	goto lab9999 ; 
      } 
      ec = tfm [ tfmptr ] * 256 + tfm [ tfmptr + 1 ] ; 
      tfmptr = tfmptr + 2 ; 
    } 
    {
      if ( tfm [ tfmptr ] > 127 ) 
      {
	(void) fprintf(stdout, "%s\n", "One of the subfile sizes is negative!" ) ; 
	(void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
	goto lab9999 ; 
      } 
      nw = tfm [ tfmptr ] * 256 + tfm [ tfmptr + 1 ] ; 
      tfmptr = tfmptr + 2 ; 
    } 
    {
      if ( tfm [ tfmptr ] > 127 ) 
      {
	(void) fprintf(stdout, "%s\n", "One of the subfile sizes is negative!" ) ; 
	(void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
	goto lab9999 ; 
      } 
      nh = tfm [ tfmptr ] * 256 + tfm [ tfmptr + 1 ] ; 
      tfmptr = tfmptr + 2 ; 
    } 
    {
      if ( tfm [ tfmptr ] > 127 ) 
      {
	(void) fprintf(stdout, "%s\n", "One of the subfile sizes is negative!" ) ; 
	(void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
	goto lab9999 ; 
      } 
      nd = tfm [ tfmptr ] * 256 + tfm [ tfmptr + 1 ] ; 
      tfmptr = tfmptr + 2 ; 
    } 
    {
      if ( tfm [ tfmptr ] > 127 ) 
      {
	(void) fprintf(stdout, "%s\n", "One of the subfile sizes is negative!" ) ; 
	(void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
	goto lab9999 ; 
      } 
      ni = tfm [ tfmptr ] * 256 + tfm [ tfmptr + 1 ] ; 
      tfmptr = tfmptr + 2 ; 
    } 
    {
      if ( tfm [ tfmptr ] > 127 ) 
      {
	(void) fprintf(stdout, "%s\n", "One of the subfile sizes is negative!" ) ; 
	(void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
	goto lab9999 ; 
      } 
      nl = tfm [ tfmptr ] * 256 + tfm [ tfmptr + 1 ] ; 
      tfmptr = tfmptr + 2 ; 
    } 
    {
      if ( tfm [ tfmptr ] > 127 ) 
      {
	(void) fprintf(stdout, "%s\n", "One of the subfile sizes is negative!" ) ; 
	(void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
	goto lab9999 ; 
      } 
      nk = tfm [ tfmptr ] * 256 + tfm [ tfmptr + 1 ] ; 
      tfmptr = tfmptr + 2 ; 
    } 
    {
      if ( tfm [ tfmptr ] > 127 ) 
      {
	(void) fprintf(stdout, "%s\n", "One of the subfile sizes is negative!" ) ; 
	(void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
	goto lab9999 ; 
      } 
      ne = tfm [ tfmptr ] * 256 + tfm [ tfmptr + 1 ] ; 
      tfmptr = tfmptr + 2 ; 
    } 
    {
      if ( tfm [ tfmptr ] > 127 ) 
      {
	(void) fprintf(stdout, "%s\n", "One of the subfile sizes is negative!" ) ; 
	(void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
	goto lab9999 ; 
      } 
      np = tfm [ tfmptr ] * 256 + tfm [ tfmptr + 1 ] ; 
      tfmptr = tfmptr + 2 ; 
    } 
    if ( lf != 6 + lh + ( ec - bc + 1 ) + nw + nh + nd + ni + nl + nk + ne + 
    np ) 
    {
      (void) fprintf(stdout, "%s\n", "Subfile sizes don't add up to the stated total!" ) ; 
      (void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
      goto lab9999 ; 
    } 
    if ( ( nw == 0 ) || ( nh == 0 ) || ( nd == 0 ) || ( ni == 0 ) ) 
    {
      (void) fprintf(stdout, "%s\n", "Incomplete subfiles for character dimensions!" ) ; 
      (void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
      goto lab9999 ; 
    } 
    if ( ( bc > ec + 1 ) || ( ec > 255 ) ) 
    {
      (void) fprintf(stdout, "%s%ld%s%ld%s\n", "The character code range " , (long)bc , ".." , (long)ec , "is illegal!" ) 
      ; 
      (void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
      goto lab9999 ; 
    } 
    if ( ne > 256 ) 
    {
      (void) fprintf(stdout, "%s%ld%s\n", "There are " , (long)ne , " extensible recipes!" ) ; 
      (void) fprintf(stdout, "%s\n", "Sorry, but I can't go on; are you sure this is a TFM?" ) ; 
      goto lab9999 ; 
    } 
  } 
  {
    charbase = 6 + lh - bc ; 
    widthbase = charbase + ec + 1 ; 
    heightbase = widthbase + nw ; 
    depthbase = heightbase + nh ; 
    italicbase = depthbase + nd ; 
    ligkernbase = italicbase + ni ; 
    kernbase = ligkernbase + nl ; 
    extenbase = kernbase + nk ; 
    parambase = extenbase + ne - 1 ; 
  } 
  Result = true ; 
  goto lab30 ; 
  lab9999: Result = false ; 
  lab30: ; 
  return(Result) ; 
} 
void dosimplethings ( ) 
{short i  ; 
  {
    fonttype = 0 ; 
    if ( lh >= 12 ) 
    {
      {
	checkBCPL ( 32 , 40 ) ; 
	if ( ( tfm [ 32 ] >= 11 ) && ( tfm [ 33 ] == 84 ) && ( tfm [ 34 ] == 
	69 ) && ( tfm [ 35 ] == 88 ) && ( tfm [ 36 ] == 32 ) && ( tfm [ 37 ] 
	== 77 ) && ( tfm [ 38 ] == 65 ) && ( tfm [ 39 ] == 84 ) && ( tfm [ 40 
	] == 72 ) && ( tfm [ 41 ] == 32 ) ) 
	{
	  if ( ( tfm [ 42 ] == 83 ) && ( tfm [ 43 ] == 89 ) ) 
	  fonttype = 1 ; 
	  else if ( ( tfm [ 42 ] == 69 ) && ( tfm [ 43 ] == 88 ) ) 
	  fonttype = 2 ; 
	} 
      } 
      if ( lh >= 17 ) 
      {
	left () ; 
	(void) Fputs( plfile ,  "FAMILY" ) ; 
	checkBCPL ( 72 , 20 ) ; 
	outBCPL ( 72 ) ; 
	right () ; 
	if ( lh >= 18 ) 
	{
	  left () ; 
	  (void) Fputs( plfile ,  "FACE" ) ; 
	  outface ( 95 ) ; 
	  right () ; 
	  {register integer for_end; i = 18 ; for_end = lh - 1 ; if ( i <= 
	  for_end) do 
	    {
	      left () ; 
	      (void) fprintf( plfile , "%s%ld",  "HEADER D " , (long)i ) ; 
	      outoctal ( 24 + 4 * i , 4 ) ; 
	      right () ; 
	    } 
	  while ( i++ < for_end ) ; } 
	} 
      } 
      left () ; 
      (void) Fputs( plfile ,  "CODINGSCHEME" ) ; 
      outBCPL ( 32 ) ; 
      right () ; 
    } 
    left () ; 
    (void) Fputs( plfile ,  "DESIGNSIZE" ) ; 
    if ( lh < 2 ) 
    {
      {
	perfect = false ; 
	if ( charsonline > 0 ) 
	(void) fprintf(stdout, "%c\n", ' ' ) ; 
	charsonline = 0 ; 
	(void) fprintf(stdout, "%s%s%s%c\n", "Bad TFM file: " , "Design size " , "missing" , '!' ) ; 
      } 
      (void) fprintf(stdout, "%s\n", "I've set it to 10 points." ) ; 
      (void) Fputs( plfile ,  " D 10" ) ; 
    } 
    else if ( tfm [ 28 ] > 127 ) 
    {
      {
	perfect = false ; 
	if ( charsonline > 0 ) 
	(void) fprintf(stdout, "%c\n", ' ' ) ; 
	charsonline = 0 ; 
	(void) fprintf(stdout, "%s%s%s%c\n", "Bad TFM file: " , "Design size " , "negative" , '!' ) ; 
      } 
      (void) fprintf(stdout, "%s\n", "I've set it to 10 points." ) ; 
      (void) Fputs( plfile ,  " D 10" ) ; 
    } 
    else if ( ( tfm [ 28 ] == 0 ) && ( tfm [ 29 ] < 16 ) ) 
    {
      {
	perfect = false ; 
	if ( charsonline > 0 ) 
	(void) fprintf(stdout, "%c\n", ' ' ) ; 
	charsonline = 0 ; 
	(void) fprintf(stdout, "%s%s%s%c\n", "Bad TFM file: " , "Design size " , "too small" , '!' ) ; 
      } 
      (void) fprintf(stdout, "%s\n", "I've set it to 10 points." ) ; 
      (void) Fputs( plfile ,  " D 10" ) ; 
    } 
    else outfix ( 28 ) ; 
    right () ; 
    (void) Fputs( plfile ,  "(COMMENT DESIGNSIZE IS IN POINTS)" ) ; 
    outln () ; 
    (void) Fputs( plfile ,  "(COMMENT OTHER SIZES ARE MULTIPLES OF DESIGNSIZE)" ) ; 
    outln () ; 
    left () ; 
    (void) Fputs( plfile ,  "CHECKSUM" ) ; 
    if ( lh == 0 ) 
    (void) Fputs( plfile ,  " O 0" ) ; 
    else outoctal ( 24 , 4 ) ; 
    right () ; 
    if ( ( lh > 17 ) && ( tfm [ 92 ] > 127 ) ) 
    {
      left () ; 
      (void) Fputs( plfile ,  "SEVENBITSAFEFLAG TRUE" ) ; 
      right () ; 
    } 
  } 
  if ( np > 0 ) 
  {
    left () ; 
    (void) Fputs( plfile ,  "FONTDIMEN" ) ; 
    outln () ; 
    {register integer for_end; i = 1 ; for_end = np ; if ( i <= for_end) do 
      {
	left () ; 
	if ( i == 1 ) 
	(void) Fputs( plfile ,  "SLANT" ) ; 
	else {
	    
	  if ( ( tfm [ 4 * ( parambase + i ) ] > 0 ) && ( tfm [ 4 * ( 
	  parambase + i ) ] < 255 ) ) 
	  {
	    tfm [ 4 * ( parambase + i ) ] = 0 ; 
	    tfm [ ( 4 * ( parambase + i ) ) + 1 ] = 0 ; 
	    tfm [ ( 4 * ( parambase + i ) ) + 2 ] = 0 ; 
	    tfm [ ( 4 * ( parambase + i ) ) + 3 ] = 0 ; 
	    {
	      perfect = false ; 
	      if ( charsonline > 0 ) 
	      (void) fprintf(stdout, "%c\n", ' ' ) ; 
	      charsonline = 0 ; 
	      (void) fprintf(stdout, "%s%s%c%ld%s\n", "Bad TFM file: " , "Parameter " , ' ' , (long)i ,               " is too big;" ) ; 
	    } 
	    (void) fprintf(stdout, "%s\n", "I have set it to zero." ) ; 
	  } 
	  if ( i <= 7 ) 
	  switch ( i ) 
	  {case 2 : 
	    (void) Fputs( plfile ,  "SPACE" ) ; 
	    break ; 
	  case 3 : 
	    (void) Fputs( plfile ,  "STRETCH" ) ; 
	    break ; 
	  case 4 : 
	    (void) Fputs( plfile ,  "SHRINK" ) ; 
	    break ; 
	  case 5 : 
	    (void) Fputs( plfile ,  "XHEIGHT" ) ; 
	    break ; 
	  case 6 : 
	    (void) Fputs( plfile ,  "QUAD" ) ; 
	    break ; 
	  case 7 : 
	    (void) Fputs( plfile ,  "EXTRASPACE" ) ; 
	    break ; 
	  } 
	  else if ( ( i <= 22 ) && ( fonttype == 1 ) ) 
	  switch ( i ) 
	  {case 8 : 
	    (void) Fputs( plfile ,  "NUM1" ) ; 
	    break ; 
	  case 9 : 
	    (void) Fputs( plfile ,  "NUM2" ) ; 
	    break ; 
	  case 10 : 
	    (void) Fputs( plfile ,  "NUM3" ) ; 
	    break ; 
	  case 11 : 
	    (void) Fputs( plfile ,  "DENOM1" ) ; 
	    break ; 
	  case 12 : 
	    (void) Fputs( plfile ,  "DENOM2" ) ; 
	    break ; 
	  case 13 : 
	    (void) Fputs( plfile ,  "SUP1" ) ; 
	    break ; 
	  case 14 : 
	    (void) Fputs( plfile ,  "SUP2" ) ; 
	    break ; 
	  case 15 : 
	    (void) Fputs( plfile ,  "SUP3" ) ; 
	    break ; 
	  case 16 : 
	    (void) Fputs( plfile ,  "SUB1" ) ; 
	    break ; 
	  case 17 : 
	    (void) Fputs( plfile ,  "SUB2" ) ; 
	    break ; 
	  case 18 : 
	    (void) Fputs( plfile ,  "SUPDROP" ) ; 
	    break ; 
	  case 19 : 
	    (void) Fputs( plfile ,  "SUBDROP" ) ; 
	    break ; 
	  case 20 : 
	    (void) Fputs( plfile ,  "DELIM1" ) ; 
	    break ; 
	  case 21 : 
	    (void) Fputs( plfile ,  "DELIM2" ) ; 
	    break ; 
	  case 22 : 
	    (void) Fputs( plfile ,  "AXISHEIGHT" ) ; 
	    break ; 
	  } 
	  else if ( ( i <= 13 ) && ( fonttype == 2 ) ) 
	  if ( i == 8 ) 
	  (void) Fputs( plfile ,  "DEFAULTRULETHICKNESS" ) ; 
	  else
	  (void) fprintf( plfile , "%s%ld",  "BIGOPSPACING" , (long)i - 8 ) ; 
	  else
	  (void) fprintf( plfile , "%s%ld",  "PARAMETER D " , (long)i ) ; 
	} 
	outfix ( 4 * ( parambase + i ) ) ; 
	right () ; 
      } 
    while ( i++ < for_end ) ; } 
    right () ; 
  } 
  if ( ( fonttype == 1 ) && ( np != 22 ) ) 
  (void) fprintf(stdout, "%s%ld%s\n", "Unusual number of fontdimen parameters for a math symbols font ("   , (long)np , " not 22)." ) ; 
  else if ( ( fonttype == 2 ) && ( np != 13 ) ) 
  (void) fprintf(stdout, "%s%ld%s\n", "Unusual number of fontdimen parameters for an extension font (" ,   (long)np , " not 13)." ) ; 
  if ( ( tfm [ 4 * widthbase ] > 0 ) || ( tfm [ 4 * widthbase + 1 ] > 0 ) || ( 
  tfm [ 4 * widthbase + 2 ] > 0 ) || ( tfm [ 4 * widthbase + 3 ] > 0 ) ) 
  {
    perfect = false ; 
    if ( charsonline > 0 ) 
    (void) fprintf(stdout, "%c\n", ' ' ) ; 
    charsonline = 0 ; 
    (void) fprintf(stdout, "%s%s\n", "Bad TFM file: " , "width[0] should be zero." ) ; 
  } 
  if ( ( tfm [ 4 * heightbase ] > 0 ) || ( tfm [ 4 * heightbase + 1 ] > 0 ) || 
  ( tfm [ 4 * heightbase + 2 ] > 0 ) || ( tfm [ 4 * heightbase + 3 ] > 0 ) ) 
  {
    perfect = false ; 
    if ( charsonline > 0 ) 
    (void) fprintf(stdout, "%c\n", ' ' ) ; 
    charsonline = 0 ; 
    (void) fprintf(stdout, "%s%s\n", "Bad TFM file: " , "height[0] should be zero." ) ; 
  } 
  if ( ( tfm [ 4 * depthbase ] > 0 ) || ( tfm [ 4 * depthbase + 1 ] > 0 ) || ( 
  tfm [ 4 * depthbase + 2 ] > 0 ) || ( tfm [ 4 * depthbase + 3 ] > 0 ) ) 
  {
    perfect = false ; 
    if ( charsonline > 0 ) 
    (void) fprintf(stdout, "%c\n", ' ' ) ; 
    charsonline = 0 ; 
    (void) fprintf(stdout, "%s%s\n", "Bad TFM file: " , "depth[0] should be zero." ) ; 
  } 
  if ( ( tfm [ 4 * italicbase ] > 0 ) || ( tfm [ 4 * italicbase + 1 ] > 0 ) || 
  ( tfm [ 4 * italicbase + 2 ] > 0 ) || ( tfm [ 4 * italicbase + 3 ] > 0 ) ) 
  {
    perfect = false ; 
    if ( charsonline > 0 ) 
    (void) fprintf(stdout, "%c\n", ' ' ) ; 
    charsonline = 0 ; 
    (void) fprintf(stdout, "%s%s\n", "Bad TFM file: " , "italic[0] should be zero." ) ; 
  } 
  {register integer for_end; i = 0 ; for_end = nw - 1 ; if ( i <= for_end) do 
    if ( ( tfm [ 4 * ( widthbase + i ) ] > 0 ) && ( tfm [ 4 * ( widthbase + i 
    ) ] < 255 ) ) 
    {
      tfm [ 4 * ( widthbase + i ) ] = 0 ; 
      tfm [ ( 4 * ( widthbase + i ) ) + 1 ] = 0 ; 
      tfm [ ( 4 * ( widthbase + i ) ) + 2 ] = 0 ; 
      tfm [ ( 4 * ( widthbase + i ) ) + 3 ] = 0 ; 
      {
	perfect = false ; 
	if ( charsonline > 0 ) 
	(void) fprintf(stdout, "%c\n", ' ' ) ; 
	charsonline = 0 ; 
	(void) fprintf(stdout, "%s%s%c%ld%s\n", "Bad TFM file: " , "Width" , ' ' , (long)i , " is too big;" ) ; 
      } 
      (void) fprintf(stdout, "%s\n", "I have set it to zero." ) ; 
    } 
  while ( i++ < for_end ) ; } 
  {register integer for_end; i = 0 ; for_end = nh - 1 ; if ( i <= for_end) do 
    if ( ( tfm [ 4 * ( heightbase + i ) ] > 0 ) && ( tfm [ 4 * ( heightbase + 
    i ) ] < 255 ) ) 
    {
      tfm [ 4 * ( heightbase + i ) ] = 0 ; 
      tfm [ ( 4 * ( heightbase + i ) ) + 1 ] = 0 ; 
      tfm [ ( 4 * ( heightbase + i ) ) + 2 ] = 0 ; 
      tfm [ ( 4 * ( heightbase + i ) ) + 3 ] = 0 ; 
      {
	perfect = false ; 
	if ( charsonline > 0 ) 
	(void) fprintf(stdout, "%c\n", ' ' ) ; 
	charsonline = 0 ; 
	(void) fprintf(stdout, "%s%s%c%ld%s\n", "Bad TFM file: " , "Height" , ' ' , (long)i , " is too big;" ) ; 
      } 
      (void) fprintf(stdout, "%s\n", "I have set it to zero." ) ; 
    } 
  while ( i++ < for_end ) ; } 
  {register integer for_end; i = 0 ; for_end = nd - 1 ; if ( i <= for_end) do 
    if ( ( tfm [ 4 * ( depthbase + i ) ] > 0 ) && ( tfm [ 4 * ( depthbase + i 
    ) ] < 255 ) ) 
    {
      tfm [ 4 * ( depthbase + i ) ] = 0 ; 
      tfm [ ( 4 * ( depthbase + i ) ) + 1 ] = 0 ; 
      tfm [ ( 4 * ( depthbase + i ) ) + 2 ] = 0 ; 
      tfm [ ( 4 * ( depthbase + i ) ) + 3 ] = 0 ; 
      {
	perfect = false ; 
	if ( charsonline > 0 ) 
	(void) fprintf(stdout, "%c\n", ' ' ) ; 
	charsonline = 0 ; 
	(void) fprintf(stdout, "%s%s%c%ld%s\n", "Bad TFM file: " , "Depth" , ' ' , (long)i , " is too big;" ) ; 
      } 
      (void) fprintf(stdout, "%s\n", "I have set it to zero." ) ; 
    } 
  while ( i++ < for_end ) ; } 
  {register integer for_end; i = 0 ; for_end = ni - 1 ; if ( i <= for_end) do 
    if ( ( tfm [ 4 * ( italicbase + i ) ] > 0 ) && ( tfm [ 4 * ( italicbase + 
    i ) ] < 255 ) ) 
    {
      tfm [ 4 * ( italicbase + i ) ] = 0 ; 
      tfm [ ( 4 * ( italicbase + i ) ) + 1 ] = 0 ; 
      tfm [ ( 4 * ( italicbase + i ) ) + 2 ] = 0 ; 
      tfm [ ( 4 * ( italicbase + i ) ) + 3 ] = 0 ; 
      {
	perfect = false ; 
	if ( charsonline > 0 ) 
	(void) fprintf(stdout, "%c\n", ' ' ) ; 
	charsonline = 0 ; 
	(void) fprintf(stdout, "%s%s%c%ld%s\n", "Bad TFM file: " , "Italic correction" , ' ' , (long)i ,         " is too big;" ) ; 
      } 
      (void) fprintf(stdout, "%s\n", "I have set it to zero." ) ; 
    } 
  while ( i++ < for_end ) ; } 
  if ( nk > 0 ) 
  {register integer for_end; i = 0 ; for_end = nk - 1 ; if ( i <= for_end) do 
    if ( ( tfm [ 4 * ( kernbase + i ) ] > 0 ) && ( tfm [ 4 * ( kernbase + i ) 
    ] < 255 ) ) 
    {
      tfm [ 4 * ( kernbase + i ) ] = 0 ; 
      tfm [ ( 4 * ( kernbase + i ) ) + 1 ] = 0 ; 
      tfm [ ( 4 * ( kernbase + i ) ) + 2 ] = 0 ; 
      tfm [ ( 4 * ( kernbase + i ) ) + 3 ] = 0 ; 
      {
	perfect = false ; 
	if ( charsonline > 0 ) 
	(void) fprintf(stdout, "%c\n", ' ' ) ; 
	charsonline = 0 ; 
	(void) fprintf(stdout, "%s%s%c%ld%s\n", "Bad TFM file: " , "Kern" , ' ' , (long)i , " is too big;" ) ; 
      } 
      (void) fprintf(stdout, "%s\n", "I have set it to zero." ) ; 
    } 
  while ( i++ < for_end ) ; } 
} 
void docharacters ( ) 
{byte c  ; 
  index k  ; 
  sortptr = 0 ; 
  {register integer for_end; c = bc ; for_end = ec ; if ( c <= for_end) do 
    if ( tfm [ 4 * ( charbase + c ) ] > 0 ) 
    {
      if ( charsonline == 8 ) 
      {
	(void) fprintf(stdout, "%c\n", ' ' ) ; 
	charsonline = 1 ; 
      } 
      else {
	  
	if ( charsonline > 0 ) 
	(void) putc(' ' , stdout);
	charsonline = charsonline + 1 ; 
      } 
      printoctal ( c ) ; 
      left () ; 
      (void) Fputs( plfile ,  "CHARACTER" ) ; 
      outchar ( c ) ; 
      outln () ; 
      {
	left () ; 
	(void) Fputs( plfile ,  "CHARWD" ) ; 
	if ( tfm [ 4 * ( charbase + c ) ] >= nw ) 
	{
	  perfect = false ; 
	  (void) fprintf(stdout, "%c\n", ' ' ) ; 
	  (void) fprintf(stdout, "%s%s", "Width" , " index for character " ) ; 
	  printoctal ( c ) ; 
	  (void) fprintf(stdout, "%s\n", " is too large;" ) ; 
	  (void) fprintf(stdout, "%s\n", "so I reset it to zero." ) ; 
	} 
	else outfix ( 4 * ( widthbase + tfm [ 4 * ( charbase + c ) ] ) ) ; 
	right () ; 
      } 
      if ( ( tfm [ 4 * ( charbase + c ) + 1 ] / 16 ) > 0 ) 
      if ( ( tfm [ 4 * ( charbase + c ) + 1 ] / 16 ) >= nh ) 
      {
	perfect = false ; 
	(void) fprintf(stdout, "%c\n", ' ' ) ; 
	(void) fprintf(stdout, "%s%s", "Height" , " index for character " ) ; 
	printoctal ( c ) ; 
	(void) fprintf(stdout, "%s\n", " is too large;" ) ; 
	(void) fprintf(stdout, "%s\n", "so I reset it to zero." ) ; 
      } 
      else {
	  
	left () ; 
	(void) Fputs( plfile ,  "CHARHT" ) ; 
	outfix ( 4 * ( heightbase + ( tfm [ 4 * ( charbase + c ) + 1 ] / 16 ) 
	) ) ; 
	right () ; 
      } 
      if ( ( tfm [ 4 * ( charbase + c ) + 1 ] % 16 ) > 0 ) 
      if ( ( tfm [ 4 * ( charbase + c ) + 1 ] % 16 ) >= nd ) 
      {
	perfect = false ; 
	(void) fprintf(stdout, "%c\n", ' ' ) ; 
	(void) fprintf(stdout, "%s%s", "Depth" , " index for character " ) ; 
	printoctal ( c ) ; 
	(void) fprintf(stdout, "%s\n", " is too large;" ) ; 
	(void) fprintf(stdout, "%s\n", "so I reset it to zero." ) ; 
      } 
      else {
	  
	left () ; 
	(void) Fputs( plfile ,  "CHARDP" ) ; 
	outfix ( 4 * ( depthbase + ( tfm [ 4 * ( charbase + c ) + 1 ] % 16 ) ) 
	) ; 
	right () ; 
      } 
      if ( ( tfm [ 4 * ( charbase + c ) + 2 ] / 4 ) > 0 ) 
      if ( ( tfm [ 4 * ( charbase + c ) + 2 ] / 4 ) >= ni ) 
      {
	perfect = false ; 
	(void) fprintf(stdout, "%c\n", ' ' ) ; 
	(void) fprintf(stdout, "%s%s", "Italic correction" , " index for character " ) ; 
	printoctal ( c ) ; 
	(void) fprintf(stdout, "%s\n", " is too large;" ) ; 
	(void) fprintf(stdout, "%s\n", "so I reset it to zero." ) ; 
      } 
      else {
	  
	left () ; 
	(void) Fputs( plfile ,  "CHARIC" ) ; 
	outfix ( 4 * ( italicbase + ( tfm [ 4 * ( charbase + c ) + 2 ] / 4 ) ) 
	) ; 
	right () ; 
      } 
      switch ( ( tfm [ 4 * ( charbase + c ) + 2 ] % 4 ) ) 
      {case 0 : 
	; 
	break ; 
      case 1 : 
	{
	  left () ; 
	  (void) Fputs( plfile ,  "COMMENT" ) ; 
	  outln () ; 
	  i = tfm [ 4 * ( charbase + c ) + 3 ] ; 
	  active = true ; 
	  do {
	      { 
	      k = 4 * ( ligkernbase + i ) ; 
	      if ( tfm [ k + 2 ] >= 128 ) 
	      {
		if ( ( ( tfm [ k + 1 ] < bc ) || ( tfm [ k + 1 ] > ec ) || ( 
		tfm [ 4 * ( charbase + tfm [ k + 1 ] ) ] == 0 ) ) ) 
		{
		  perfect = false ; 
		  if ( charsonline > 0 ) 
		  (void) fprintf(stdout, "%c\n", ' ' ) ; 
		  charsonline = 0 ; 
		  (void) fprintf(stdout, "%s%s%s", "Bad TFM file: " , "Kern step for" ,                   " nonexistent character " ) ; 
		  printoctal ( tfm [ k + 1 ] ) ; 
		  (void) fprintf(stdout, "%c\n", '.' ) ; 
		} 
		else {
		    
		  left () ; 
		  (void) Fputs( plfile ,  "KRN" ) ; 
		  outchar ( tfm [ k + 1 ] ) ; 
		  if ( tfm [ k + 3 ] >= nk ) 
		  {
		    {
		      perfect = false ; 
		      if ( charsonline > 0 ) 
		      (void) fprintf(stdout, "%c\n", ' ' ) ; 
		      charsonline = 0 ; 
		      (void) fprintf(stdout, "%s%s\n", "Bad TFM file: " , "Kern index too large." ) ; 
		    } 
		    (void) Fputs( plfile ,  " R 0.0" ) ; 
		  } 
		  else outfix ( 4 * ( kernbase + tfm [ k + 3 ] ) ) ; 
		  right () ; 
		} 
	      } 
	      else {
		  
		if ( ( ( tfm [ k + 1 ] < bc ) || ( tfm [ k + 1 ] > ec ) || ( 
		tfm [ 4 * ( charbase + tfm [ k + 1 ] ) ] == 0 ) ) ) 
		{
		  perfect = false ; 
		  if ( charsonline > 0 ) 
		  (void) fprintf(stdout, "%c\n", ' ' ) ; 
		  charsonline = 0 ; 
		  (void) fprintf(stdout, "%s%s%s", "Bad TFM file: " , "Ligature step for" ,                   " nonexistent character " ) ; 
		  printoctal ( tfm [ k + 1 ] ) ; 
		  (void) fprintf(stdout, "%c\n", '.' ) ; 
		} 
		if ( ( ( tfm [ k + 3 ] < bc ) || ( tfm [ k + 3 ] > ec ) || ( 
		tfm [ 4 * ( charbase + tfm [ k + 3 ] ) ] == 0 ) ) ) 
		{
		  perfect = false ; 
		  if ( charsonline > 0 ) 
		  (void) fprintf(stdout, "%c\n", ' ' ) ; 
		  charsonline = 0 ; 
		  (void) fprintf(stdout, "%s%s%s", "Bad TFM file: " , "Ligature step produces the" ,                   " nonexistent character " ) ; 
		  printoctal ( tfm [ k + 3 ] ) ; 
		  (void) fprintf(stdout, "%c\n", '.' ) ; 
		} 
		else {
		    
		  left () ; 
		  (void) Fputs( plfile ,  "LIG" ) ; 
		  outchar ( tfm [ k + 1 ] ) ; 
		  outchar ( tfm [ k + 3 ] ) ; 
		  right () ; 
		} 
	      } 
	      if ( tfm [ k ] >= 128 ) 
	      {
		if ( sortptr > 0 ) 
		{
		  (void) Fputs( plfile ,  "(STOP)" ) ; 
		  outln () ; 
		  if ( level > 1 ) 
		  right () ; 
		} 
		active = false ; 
	      } 
	    } 
	    i = i + 1 ; 
	  } while ( ! ( active == false ) ) ; 
	  right () ; 
	} 
	break ; 
      case 2 : 
	{
	  r = tfm [ 4 * ( charbase + c ) + 3 ] ; 
	  if ( ( ( r < bc ) || ( r > ec ) || ( tfm [ 4 * ( charbase + r ) ] == 
	  0 ) ) ) 
	  {
	    {
	      perfect = false ; 
	      if ( charsonline > 0 ) 
	      (void) fprintf(stdout, "%c\n", ' ' ) ; 
	      charsonline = 0 ; 
	      (void) fprintf(stdout, "%s%s%s", "Bad TFM file: " , "Character list link to" ,               " nonexistent character " ) ; 
	      printoctal ( r ) ; 
	      (void) fprintf(stdout, "%c\n", '.' ) ; 
	    } 
	    tfm [ 4 * ( charbase + c ) + 2 ] = 4 * ( tfm [ 4 * ( charbase + c 
	    ) + 2 ] / 4 ) + 0 ; 
	  } 
	  else {
	      
	    while ( ( r < c ) && ( ( tfm [ 4 * ( charbase + r ) + 2 ] % 4 ) == 
	    2 ) ) r = tfm [ 4 * ( charbase + r ) + 3 ] ; 
	    if ( r == c ) 
	    {
	      {
		perfect = false ; 
		if ( charsonline > 0 ) 
		(void) fprintf(stdout, "%c\n", ' ' ) ; 
		charsonline = 0 ; 
		(void) fprintf(stdout, "%s%s\n", "Bad TFM file: " , "Cycle in a character list!" ) ; 
	      } 
	      (void) Fputs(stdout, "Character " ) ; 
	      printoctal ( c ) ; 
	      (void) fprintf(stdout, "%s\n", " now ends the list." ) ; 
	      tfm [ 4 * ( charbase + c ) + 2 ] = 4 * ( tfm [ 4 * ( charbase + 
	      c ) + 2 ] / 4 ) + 0 ; 
	    } 
	    else {
		
	      left () ; 
	      (void) Fputs( plfile ,  "NEXTLARGER" ) ; 
	      outchar ( tfm [ 4 * ( charbase + c ) + 3 ] ) ; 
	      right () ; 
	    } 
	  } 
	} 
	break ; 
      case 3 : 
	if ( tfm [ 4 * ( charbase + c ) + 3 ] >= ne ) 
	{
	  {
	    perfect = false ; 
	    (void) fprintf(stdout, "%c\n", ' ' ) ; 
	    (void) fprintf(stdout, "%s%s", "Extensible" , " index for character " ) ; 
	    printoctal ( c ) ; 
	    (void) fprintf(stdout, "%s\n", " is too large;" ) ; 
	    (void) fprintf(stdout, "%s\n", "so I reset it to zero." ) ; 
	  } 
	  tfm [ 4 * ( charbase + c ) + 2 ] = 4 * ( tfm [ 4 * ( charbase + c ) 
	  + 2 ] / 4 ) + 0 ; 
	} 
	else {
	    
	  left () ; 
	  (void) Fputs( plfile ,  "VARCHAR" ) ; 
	  outln () ; 
	  {register integer for_end; k = 0 ; for_end = 3 ; if ( k <= for_end) 
	  do 
	    if ( ( k == 3 ) || ( tfm [ 4 * ( extenbase + tfm [ 4 * ( charbase 
	    + c ) + 3 ] ) + k ] > 0 ) ) 
	    {
	      left () ; 
	      switch ( k ) 
	      {case 0 : 
		(void) Fputs( plfile ,  "TOP" ) ; 
		break ; 
	      case 1 : 
		(void) Fputs( plfile ,  "MID" ) ; 
		break ; 
	      case 2 : 
		(void) Fputs( plfile ,  "BOT" ) ; 
		break ; 
	      case 3 : 
		(void) Fputs( plfile ,  "REP" ) ; 
		break ; 
	      } 
	      if ( ( ( tfm [ 4 * ( extenbase + tfm [ 4 * ( charbase + c ) + 3 
	      ] ) + k ] < bc ) || ( tfm [ 4 * ( extenbase + tfm [ 4 * ( 
	      charbase + c ) + 3 ] ) + k ] > ec ) || ( tfm [ 4 * ( charbase + 
	      tfm [ 4 * ( extenbase + tfm [ 4 * ( charbase + c ) + 3 ] ) + k ] 
	      ) ] == 0 ) ) ) 
	      outchar ( c ) ; 
	      else outchar ( tfm [ 4 * ( extenbase + tfm [ 4 * ( charbase + c 
	      ) + 3 ] ) + k ] ) ; 
	      right () ; 
	    } 
	  while ( k++ < for_end ) ; } 
	  right () ; 
	} 
	break ; 
      } 
      right () ; 
    } 
  while ( c++ < for_end ) ; } 
} 
void main_body() {
    
  initialize () ; 
  if ( ! organize () ) 
  goto lab9999 ; 
  dosimplethings () ; 
  {register integer for_end; c = bc ; for_end = ec ; if ( c <= for_end) do 
    if ( ( tfm [ 4 * ( charbase + c ) + 2 ] % 4 ) == 1 ) 
    {
      r = tfm [ 4 * ( charbase + c ) + 3 ] ; 
      if ( r >= nl ) 
      {
	{
	  perfect = false ; 
	  (void) fprintf(stdout, "%c\n", ' ' ) ; 
	  (void) fprintf(stdout, "%s%s", "Ligature/kern" , " index for character " ) ; 
	  printoctal ( c ) ; 
	  (void) fprintf(stdout, "%s\n", " is too large;" ) ; 
	  (void) fprintf(stdout, "%s\n", "so I reset it to zero." ) ; 
	} 
	tfm [ 4 * ( charbase + c ) + 2 ] = 4 * ( tfm [ 4 * ( charbase + c ) + 
	2 ] / 4 ) + 0 ; 
      } 
      else {
	  
	sortptr = labelptr ; 
	while ( labeltable [ sortptr ] .rr > r ) {
	    
	  labeltable [ sortptr + 1 ] = labeltable [ sortptr ] ; 
	  sortptr = sortptr - 1 ; 
	} 
	labeltable [ sortptr + 1 ] .cc = c ; 
	labeltable [ sortptr + 1 ] .rr = r ; 
	labelptr = labelptr + 1 ; 
      } 
    } 
  while ( c++ < for_end ) ; } 
  labeltable [ labelptr + 1 ] .rr = 256 ; 
  if ( nl > 0 ) 
  {
    left () ; 
    (void) Fputs( plfile ,  "LIGTABLE" ) ; 
    outln () ; 
    active = false ; 
    sortptr = 1 ; 
    {register integer for_end; i = 0 ; for_end = nl - 1 ; if ( i <= for_end) 
    do 
      {
	while ( i == labeltable [ sortptr ] .rr ) {
	    
	  if ( level > 1 ) 
	  right () ; 
	  active = true ; 
	  left () ; 
	  (void) Fputs( plfile ,  "LABEL" ) ; 
	  outchar ( labeltable [ sortptr ] .cc ) ; 
	  right () ; 
	  sortptr = sortptr + 1 ; 
	} 
	if ( ! active ) 
	{
	  left () ; 
	  (void) Fputs( plfile ,  "COMMENT THIS PART OF THE PROGRAM IS NEVER USED!" ) 
	  ; 
	  outln () ; 
	  active = true ; 
	} 
	{
	  k = 4 * ( ligkernbase + i ) ; 
	  if ( tfm [ k + 2 ] >= 128 ) 
	  {
	    if ( ( ( tfm [ k + 1 ] < bc ) || ( tfm [ k + 1 ] > ec ) || ( tfm [ 
	    4 * ( charbase + tfm [ k + 1 ] ) ] == 0 ) ) ) 
	    {
	      perfect = false ; 
	      if ( charsonline > 0 ) 
	      (void) fprintf(stdout, "%c\n", ' ' ) ; 
	      charsonline = 0 ; 
	      (void) fprintf(stdout, "%s%s%s", "Bad TFM file: " , "Kern step for" ,               " nonexistent character " ) ; 
	      printoctal ( tfm [ k + 1 ] ) ; 
	      (void) fprintf(stdout, "%c\n", '.' ) ; 
	    } 
	    else {
		
	      left () ; 
	      (void) Fputs( plfile ,  "KRN" ) ; 
	      outchar ( tfm [ k + 1 ] ) ; 
	      if ( tfm [ k + 3 ] >= nk ) 
	      {
		{
		  perfect = false ; 
		  if ( charsonline > 0 ) 
		  (void) fprintf(stdout, "%c\n", ' ' ) ; 
		  charsonline = 0 ; 
		  (void) fprintf(stdout, "%s%s\n", "Bad TFM file: " , "Kern index too large." ) ; 
		} 
		(void) Fputs( plfile ,  " R 0.0" ) ; 
	      } 
	      else outfix ( 4 * ( kernbase + tfm [ k + 3 ] ) ) ; 
	      right () ; 
	    } 
	  } 
	  else {
	      
	    if ( ( ( tfm [ k + 1 ] < bc ) || ( tfm [ k + 1 ] > ec ) || ( tfm [ 
	    4 * ( charbase + tfm [ k + 1 ] ) ] == 0 ) ) ) 
	    {
	      perfect = false ; 
	      if ( charsonline > 0 ) 
	      (void) fprintf(stdout, "%c\n", ' ' ) ; 
	      charsonline = 0 ; 
	      (void) fprintf(stdout, "%s%s%s", "Bad TFM file: " , "Ligature step for" ,               " nonexistent character " ) ; 
	      printoctal ( tfm [ k + 1 ] ) ; 
	      (void) fprintf(stdout, "%c\n", '.' ) ; 
	    } 
	    if ( ( ( tfm [ k + 3 ] < bc ) || ( tfm [ k + 3 ] > ec ) || ( tfm [ 
	    4 * ( charbase + tfm [ k + 3 ] ) ] == 0 ) ) ) 
	    {
	      perfect = false ; 
	      if ( charsonline > 0 ) 
	      (void) fprintf(stdout, "%c\n", ' ' ) ; 
	      charsonline = 0 ; 
	      (void) fprintf(stdout, "%s%s%s", "Bad TFM file: " , "Ligature step produces the" ,               " nonexistent character " ) ; 
	      printoctal ( tfm [ k + 3 ] ) ; 
	      (void) fprintf(stdout, "%c\n", '.' ) ; 
	    } 
	    else {
		
	      left () ; 
	      (void) Fputs( plfile ,  "LIG" ) ; 
	      outchar ( tfm [ k + 1 ] ) ; 
	      outchar ( tfm [ k + 3 ] ) ; 
	      right () ; 
	    } 
	  } 
	  if ( tfm [ k ] >= 128 ) 
	  {
	    if ( sortptr > 0 ) 
	    {
	      (void) Fputs( plfile ,  "(STOP)" ) ; 
	      outln () ; 
	      if ( level > 1 ) 
	      right () ; 
	    } 
	    active = false ; 
	  } 
	} 
      } 
    while ( i++ < for_end ) ; } 
    if ( active ) 
    {
      {
	perfect = false ; 
	if ( charsonline > 0 ) 
	(void) fprintf(stdout, "%c\n", ' ' ) ; 
	charsonline = 0 ; 
	(void) fprintf(stdout, "%s%s\n", "Bad TFM file: " ,         "No stop bit at the end of ligature/kern program." ) ; 
      } 
      {
	(void) Fputs( plfile ,  "(STOP)" ) ; 
	outln () ; 
	if ( level > 1 ) 
	right () ; 
      } 
      tfm [ 4 * ( kernbase + 0 ) - 4 ] = tfm [ 4 * ( kernbase + 0 ) - 4 ] + 
      128 ; 
    } 
    right () ; 
  } 
  if ( ne > 0 ) 
  {register integer for_end; c = 0 ; for_end = ne - 1 ; if ( c <= for_end) do 
    {register integer for_end; r = 0 ; for_end = 3 ; if ( r <= for_end) do 
      {
	k = 4 * ( extenbase + c ) + r ; 
	if ( ( tfm [ k ] > 0 ) || ( r == 3 ) ) 
	{
	  if ( ( ( tfm [ k ] < bc ) || ( tfm [ k ] > ec ) || ( tfm [ 4 * ( 
	  charbase + tfm [ k ] ) ] == 0 ) ) ) 
	  {
	    {
	      perfect = false ; 
	      if ( charsonline > 0 ) 
	      (void) fprintf(stdout, "%c\n", ' ' ) ; 
	      charsonline = 0 ; 
	      (void) fprintf(stdout, "%s%s%s", "Bad TFM file: " , "Extensible recipe involves the" ,               " nonexistent character " ) ; 
	      printoctal ( tfm [ k ] ) ; 
	      (void) fprintf(stdout, "%c\n", '.' ) ; 
	    } 
	    if ( r < 3 ) 
	    tfm [ k ] = 0 ; 
	  } 
	} 
      } 
    while ( r++ < for_end ) ; } 
  while ( c++ < for_end ) ; } 
  docharacters () ; 
  (void) fprintf(stdout, "%c\n", '.' ) ; 
  if ( level != 0 ) 
  (void) fprintf(stdout, "%s\n", "This program isn't working!" ) ; 
  if ( ! perfect ) 
  (void) Fputs( plfile ,    "(COMMENT THE TFM FILE WAS BAD, SO THE DATA HAS BEEN CHANGED!)" ) ; 
  lab9999: (void) fprintf(stdout, "%c\n", ' ' ) ; 
} 
