/*
 * built-in font
 */

#include	"defs.h"
#include	"global.h"
#include	"bifont.h"
#include	"jsub.h"

/* tfm_access, jstfm_access, jfm_access may be device dependent,
   because not all devices allow arbitrary magnification. */

int tfm_access();
int jstfm_access();
int jfm_access();
void init_tfm_fontinfo();
void init_jstfm_fontinfo();
void init_jfm_fontinfo();

struct fontop tfmop = {
    "tfm",
    tfm_access,
    init_tfm_fontinfo,
};

#ifdef UNDEF
struct fontop jstfmop = {
    "jstfm",
    jstfm_access,
    init_jstfm_fontinfo,
};
#endif

struct fontop jfmop = {
    "jfm",
    tfm_access,
    init_jfm_fontinfo,
};

tfm_access(proto, fe, acca)
char *proto;
struct font_entry *fe;
struct accarg *acca;
{
    /* In the case of tfm, declaration of bifont-line is not checked
       because fe->n itself can be builtin-font name */
    pave(fe->name, proto, acca);
#ifdef DEBUG
    if (Debuguser)
	(void)fprintf(stderr, "trying to access %s\n", fe->name);
#endif
    return (access(fe->name, R_OK) == 0);
}

#ifdef UNDEF
jstfm_access(proto, fe, acca)
char *proto;
struct font_entry *fe;
struct accarg *acca;
{
    pave(fe->name, proto, acca);
#ifdef DEBUG
    if (Debuguser)
	(void)fprintf(stderr, "trying to access %s\n", fe->name);
#endif
    if (access(fe->name, R_OK) == 0)
	if (dev_is_jstfm(fe->n))
	    return TRUE;
    return FALSE;
}

jfm_access(proto, fe, acca)
char *proto;
struct font_entry *fe;
struct accarg *acca;
{
    pave(fe->name, proto, acca);
#ifdef DEBUG
    if (Debuguser)
	(void)fprintf(stderr, "trying to access %s\n", fe->name);
#endif
    if (access(fe->name, R_OK) == 0)
	if (dev_is_jfm(fe->n))
	    return TRUE;
    return FALSE;
}
#endif

/*
    There are three kinds of tfm files, e.g.
	Times-Roman.tfm, Courier.tfm, ...
	XXjhira10.tfm, XXja10.tfm, ... (XX: japanese font)
	XX.tfm, ... (jfm format, XX: japanese font)
    The first one: (TYPE tfm)
	easy.
    The second one: (TYPE jstfm)
	dev_font: assgined when XX first appears
	dev_ku, dev_ten: calculated from j?? and charcode
    The third one: (TYPE jfm)
	easy, but tfmw information can be stored efficiently
	by using jfm structure
*/

/* set by readtfm, readjfm */
static byte width[4*256];
static int nt, lh, bc, ec, nw;
#define	JSTFMHEAD	4*2
static byte header[JSTFMHEAD];

/* TYPE: tfm
 */
void
init_tfm_fontinfo(fe)
register struct font_entry *fe;
{
    int	null_markchar();
    void read_tfm_fontinfo();

    fe->fnt_type = FT_TFM;
    fe->fnt_use = FU_USED;
    fe->fnt_markchar = null_markchar;
    fe->fnt_readfontinfo = read_tfm_fontinfo;
}

void
read_tfm_fontinfo(fe)
register struct font_entry *fe;
{
    register FILE *fntfp;
    register struct tfmchar_entry *ce;
    register int i;
    SCALED s;

    openfontfile(fe);
    readtfm(fntfp = fe->openfile);
    tfmfinfo(fe) = NEW(struct tfmfntinfo, "tfmfont info");
    tfmfinfo(fe)->lastfntchar = ec;
    
    s = (SCALED)fe->s;
    for (i = bc, ce = (tfmfinfo(fe)->ch)+bc; i <= ec; i++, ce++) {
	/* ce->dev_font = fe->k;	/* Not used */
	ce->dev_char = i;
	ce->tfmw = scale(makeuint(width+4*getuint(fntfp,1),4), s);
	(void)fseek(fntfp, 3L, 1);
    }
    dev_tfm_initfe(fe, dev_tfm_initfontdict(fe));
}

#ifdef UNDEF
/* ARGSUSED */
DEV_FONT
tfm_fontdict(fe, c)
struct font_entry *fe;
int c;
{
    return (fe->k);
}
#endif

#ifdef UNDEF
/* TYPE: jstfm
 */
void
init_jstfm_fontinfo(fe)
register struct font_entry *fe;
{
    int	null_markchar();
    void read_jstfm_fontinfo();

    fe->fnt_markchar = null_markchar;
    fe->fnt_readfontinfo = read_jstfm_fontinfo;
}

void
read_jstfm_fontinfo(fe)
register struct font_entry *fe;
{
    register FILE *fntfp;
    register struct jstfmchar_entry *ce;
    register int i;
    SCALED s;
    int subfont;

    openfontfile(fe);
    readtfm(fntfp = fe->openfile);
    if (lh <= 2 || makeuint(header, 4) != JSTFM_MAGIC)
	Fatal("%s is not japanese subfont", fe->name);
    subfont = header[JSTFMHEAD-1];
    jstfmfinfo(fe) = NEW(struct jstfmfntinfo, "jstfmfont info");
    jstfmfinfo(fe)->lastfntchar = ec;
    if (subfont != dev_getjsubfont(fe))
	Warning("%s has subfont number %d", fe->name, subfont);
    s = (SCALED)fe->s;
    for (i = bc, ce = (jstfmfinfo(fe)->ch)+bc; i <= ec; i++, ce++) {
	compute_jis(subfont, i, &(ce->dev_ku), &(ce->dev_ten));
	ce->tfmw = scale(makeuint(width+4*getuint(fntfp,1),4), s);
	(void)fseek(fntfp, 3L, 1);
    }
    dev_jstfm_initfe(fe, dev_jstfm_initfontdict(fe));
}

/* ARGSUSED */
DEV_FONT
jstfm_fontdict(fe, c)
struct font_entry *fe;
int c;
{
    return (jstfmfinfo(fe)->dev_font);
}
#endif

/* TYPE: jfm
 */
void
init_jfm_fontinfo(fe)
struct font_entry *fe;
{
    int	null_markchar();
    void read_jfm_fontinfo();

    fe->fnt_type = FT_JFM;
    fe->fnt_use = FU_USED;
    fe->fnt_markchar = null_markchar;
    fe->fnt_readfontinfo = read_jfm_fontinfo;
}

void
read_jfm_fontinfo(fe)
struct font_entry *fe;
{
    register FILE *fntfp;
    register struct jfmtype_entry *te;
    register struct jfmchar_entry *ce;
    register int i;
    SCALED s;

    openfontfile(fe);
    if (!readjfm(fntfp = fe->openfile))
	Fatal("%s is not jfm file", fe->name);
    jfmfinfo(fe) = NEW(struct jfmfntinfo, "jfmfont info");
    jfmfinfo(fe)->nctype = nt;
    jfmfinfo(fe)->ctype = NEWTAB(struct jfmtype_entry, nt, "jfmtype table");
    for (i = 0, te = jfmfinfo(fe)->ctype; i < nt; i++, te++) {
	te->jfm_code = getuint(fntfp, 2);
	te->jfm_type = getuint(fntfp, 2);
    }
    jfmfinfo(fe)->lasttypecode = (te-1)->jfm_code;
    jfmfinfo(fe)->ch = NEWTAB(struct jfmchar_entry, ec+1, "jfmchar table");
    s = (SCALED)fe->s;
    for (i = bc, ce = (jfmfinfo(fe)->ch)+bc; i <= ec; i++, ce++) {
	ce->tfmw = scale(makeuint(width+4*getuint(fntfp,1),4), s);
	(void)fseek(fntfp, 3L, 1);
    }
    jfmfinfo(fe)->dev_name = dev_getjfmname(fe->n);
    dev_jfm_initfe(fe, dev_jfm_initfontdict(fe));
}

getctype(c, jfmfi)
int c;
struct jfmfntinfo *jfmfi;
{
    register int m;
    register int left, right;
    register struct jfmtype_entry *te;
    int code;

    if (c > jfmfi->lasttypecode)
	return (0);
    for (left = 0, right = jfmfi->nctype, te = jfmfi->ctype; left <= right;) {
	m = (left+right)/2;
	if (c < (code = (te+m)->jfm_code))
	    right = m-1;
	else if (c > code)
	    left = m+1;
	else if (c == code)
	    return ((te+m)->jfm_type);
    }
    return (0);
}


/* utilities
 */
readtfm(fntfp)
register FILE *fntfp;
{
    (void)fseek(fntfp, 2L, 0);	/* lf */
    lh = getuint(fntfp, 2);
    bc = getuint(fntfp, 2);
    ec = getuint(fntfp, 2);
    nw = getuint(fntfp, 2);
    (void)fseek(fntfp, 8*4L, 0);
    getbytes(fntfp, header, (lh-2)*4 > JSTFMHEAD ? JSTFMHEAD : (lh-2)*4);
    (void)fseek(fntfp, (6+lh+(ec-bc)+1)*4L, 0);
    getbytes(fntfp, width, 4*nw);
    (void)fseek(fntfp, (6+lh)*4L, 0);	/* ready to read char_info */
}

readjfm(fntfp)
register FILE *fntfp;
{
    if (getuint(fntfp, 2) != JFM_ID)
	return (FALSE);
    nt = getuint(fntfp, 2);
    (void)fseek(fntfp, 2L, 1);	/* lf */
    lh = getuint(fntfp, 2);
    bc = getuint(fntfp, 2);	/* bc should be 0 */
    ec = getuint(fntfp, 2);
    nw = getuint(fntfp, 2);
    (void)fseek(fntfp, (7+lh+nt+(ec-bc)+1)*4L, 0);
    getbytes(fntfp, width, 4*nw);
    (void)fseek(fntfp, (7+lh)*4L, 0);	/* ready to read char_type and char_info */
    return (TRUE);
}
