#include	"defs.h"
#include	"global.h"
#include	"commands.h"

int dvi_h = 0;			/* current h on output dvi */
int dvi_v = 0;			/* current v on output dvi */

DEV_FONT dvi_curfe;
int spmax = 0;

long dvipos;
long lpagep;

extern int command;
extern int num, den;
extern long postambleptr;

/* ARGSUSED */
dev_arg(option, c)
char option;
char *c;
{
}

dev_init()
{
}

dev_finish()
{
    long postpos;
    int i;
    register struct font_entry *fe;

    postpos = dvipos;
    putbyte(outfp, POST);
    putnint(outfp, lpagep, 4);
    putnint(outfp, num, 4);
    putnint(outfp, den, 4);
    putnint(outfp, mag, 4);
    (void)fseek(dvifp, postambleptr+17, 0);
    copybytes(dvifp, outfp, 8);
    putnint(outfp, spmax+1, 2);
    (void)fseek(dvifp, (long)2, 1);
    copybytes(dvifp, outfp, 2);
    dvipos += 29;

    for (fe = hdfontent; fe != NULL; fe = fe->next)
	if (fe->fnt_use == FU_USED)
	    putfontdef(fe);

    putbyte(outfp, POST_POST);
    putnint(outfp, postpos, 4);
    putnint(outfp, DVIFORMAT, 1);
    dvipos += 6;
    for (i = 0; i < 7 - (dvipos+3) % 4; i++)
	putbyte(outfp, 223);
}

putfontdef(fe)
register struct font_entry *fe;
{
    byte *b;
    int n;

    n = uinttob(&b, fe->k);
    putbyte(outfp, FNT_DEF1+n-1);
    putbytes(outfp, b, n);
    putnint(outfp, fe->c, 4);
    putnint(outfp, fe->s, 4);
    putnint(outfp, fe->d, 4);
    putnint(outfp, fe->a, 1);
    putnint(outfp, fe->l, 1);
    putbytes(outfp, fe->n, fe->a+fe->l);
    dvipos += n+15+fe->a+fe->l;
}

dev_setup(def_resolution)
int def_resolution;
{
    /* use resolution as drift!! */
    if (resolution <= 0)
	resolution = 5;
}

dev_endsetup()
{
    register struct font_entry *fe;
    register int k;

    for (fe = hdfontent, k = 0; fe != NULL; fe = fe->next)
	if (fe->fnt_use == FU_USED) {
	    fe->k = k;
	    fe->fnt_use = FU_NOTUSED;
	    k++;
	}
    
    putbyte(outfp, PRE);
    putnint(outfp, DVIFORMAT, 1);
    putnint(outfp, num, 4);
    putnint(outfp, den, 4);
    putnint(outfp, mag, 4);
    (void)fseek(dvifp, (long)14, 0);
    putnint(outfp, k = getuint(dvifp, 1), 1);
    copybytes(dvifp, outfp, k);
    dvipos = 15+k;
    lpagep = -1;
}


dev_command(com)
int com;
{
    putbyte(outfp, com);
    dvipos++;
}

dev_bop(count)
int count[];
{
    int i;

    putbyte(outfp, BOP);
    for (i = 0; i < 10; i++)
	putnint(outfp, count[i], 4);
    putnint(outfp, lpagep, 4);
    dvi_curfe = DEV_NULLFONT;
    lpagep = dvipos;
    dvipos += 45;
}

dev_eop()
{
    putbyte(outfp, EOP);
    dvipos++;
}

dev_push()
{
    extern int sp;

    putbyte(outfp, PUSH);
    dvipos++;
    if (sp > spmax)
	spmax = sp;
}

dev_pop()
{
    putbyte(outfp, POP);
    dvipos++;
}

dev_setfont(dvif)
register DEV_FONT dvif;
{
    byte *b;
    int n;

    if (dvif != dvi_curfe) {
	if (dvif->fnt_use == FU_NOTUSED) {
	    putfontdef(dvif);
	    dvif->fnt_use = FU_USED;
	}
	if (0 <= dvif->k && dvif->k <= 63) {
	    putbyte(outfp, FONT_00+dvif->k);
	    dvipos++;
	} else {
	    n = uinttob(&b, dvif->k);
	    putbyte(outfp, FNT1+n-1);
	    putbytes(outfp, b, n);
	    dvipos += n+1;
	}
	dvi_curfe = dvif;
    }
}

dev_move(x, n, com)
byte *x;
int n, com;
{
    putbyte(outfp, com+n);
    putbytes(outfp, x, n);
    dvipos += n+1;
}

dev_makemove(x, com)
int x, com;
{
    byte *s;
    int n;

    /* use resolution as drift!! */
    if (-resolution < x && x < resolution)
	return;
    n = inttob(&s, x);
    dev_move(s, n, com);
}

/* ARGSUSED */
dev_setposn(x, y)
int x, y;
{
}

dev_setrule(a, b)
int a, b;
{
    putbyte(outfp, command);
    putnint(outfp, a, 4);
    putnint(outfp, b, 4);
    dvipos += 9;
}


/* ARGSUSED */
void
dev_predospecial(str, n)
byte *str;
int n;
{
}

void
dev_dospecial(str, n)
byte *str;
int n;
{
    putbyte(outfp, command);
    putnint(outfp, n, command-XXX1+1);
    putbytes(outfp, str, n);
    dvipos += n+2;
}
