#include	"defs.h"
#include	"global.h"

extern struct fontop
    pkop,	/* pkfont.c */
    gfop,	/* gffont.c */
    pxlop,	/* pxlfont.c */
    jxlop,	/* jxl4font.c */
    vfop,	/* virfont.c */
    jvfop,	/* virfont.c */
    tfmop,	/* bifont.c */
    jstfmop,	/* bifont.c */
    jfmop;	/* bifont.c */
struct fontop *fontops[] = {
    &pkop,
    &gfop,
    &pxlop,
    &jxlop,
    &vfop,
    &jvfop,
    &tfmop,
    &jstfmop,
    &jfmop,
    NULL
};

extern struct confop
    fdcop,	/* fontdesc.c */
    fontcop,	/* fontdesc.c */
    pdcop,	/* psrast.c */
    bicop,	/* psbi.c */
    bfcop,	/* psbi.c */
    bkcop,	/* psbi.c */
    resolutioncop, /* fontdesc.c */
    includecop,	/* fontdesc.c */
    setupcop,	/* fontdesc.c */
    substcop,	/* fontdesc.c */
    replfcop;	/* fontdesc.c */
struct confop *confops[] = {
    &fdcop,
    &fontcop,
    &pdcop,
    &bicop,
    &bfcop,
    &bkcop,
    &resolutioncop,
    &includecop,
    &setupcop,
    &substcop,
    &replfcop,
    NULL
};


/*
 * read_fontdesc
 */
static char *fdname;
static FILE *fd;
static int fdch;
static int fdline;
static char *libdir;

void
read_fontdesc(fdn, top)
char *fdn;
BOOLEAN top;
{
    char fdfile[PATHLEN];
    FILE *f;
    char field[STRSIZE];
    char newlibdir[PATHLEN];
    char *save_fdname;
    FILE *save_fd;
    int save_fdch;
    int save_fdline;
    char *save_libdir;
    struct confop *findconfop();

    if (searchfile(fdn, fdfile, newlibdir, top, NULL)) {
#ifdef DEBUG
	if (Debuguser)
	    (void)fprintf(stderr, "open fontdesc %s\n", fdfile);
#endif
	f = fopen(fdfile, "r");
    } else
	Fatal("cannot open fontdesc file %s", fdn);
    save_fdname = fdname;
    save_fd = fd;
    save_fdch = fdch;
    save_fdline = fdline;
    save_libdir = libdir;
    fdname = fdfile;
    fd = f;
    libdir = newlibdir;
    for (fdline = 1; (fdch = getc(fd)) != EOF; fdline++) {
	if (fdch == '#' || fdch == '\n') {
	    skipline();
	    continue;
	}
	getfield(field);
	(*(findconfop(field)->co_get))();
    }
    (void)fclose(fd);
    fdname = save_fdname;
    fd = save_fd;
    fdch = save_fdch;
    fdline = save_fdline;
    libdir = save_libdir;
}

searchfile(f, newf, newld, top, ext)
char *f, *newf, *newld;
BOOLEAN top;
char *ext;
{
    char *path, *p, *d;

    if (strncmp(f, "//", 2) == 0) {
	(void)strcpy(newf, dvi2lib);	/* default lib directory */
	(void)strcat(newf, "/");
	(void)strcat(newf, f+2);
	goto find;
    } else if (*f == '/'
#ifdef MSDOS
	       || (isalpha(*f) && *(f+1) == ':')
#endif
	       ) {
	(void)strcpy(newf, f);
	goto find;
    } else if (!top) {
	(void)strcpy(newf, libdir);
	(void)strcat(newf, "/");
	(void)strcat(newf, f);
	goto find;
    }

    if (strncmp(f, "./", 2) == 0 || strncmp(f, "../", 3) == 0) {
	(void)strcpy(newf, f);
	goto find;
    }
    for (path = ((dvi2path == NULL) ? dvi2lib : dvi2path); *path != '\0'; ) {
	for (p = path, d = newld; *p != PATH_SEP && *p != '\0'; )
	    *d++ = *p++;
	*d = '\0';
	if (d == newld)
	    continue;
	(void)strcpy(newf, newld);
	(void)strcat(newf, "/");
	(void)strcat(newf, f);
	if (access(newf, R_OK) == 0)
	    goto found;
	if (ext != NULL) {
	    (void)strcat(newf, ext);
	    if (access(newf, R_OK) == 0)
		goto found;
	}
	if (*p == '\0')
	    break;
	path = p+1;
    }
    return FALSE;

 find:
    if (access(newf, R_OK) == 0)
	goto found;
    if (ext != NULL) {
	(void)strcat(newf, ext);
	if (access(newf, R_OK) == 0)
	    goto found;
    }
    return FALSE;
 found:
    p = rindex(newf, '/');
    (void)strncpy(newld, newf, p-newf);
    newld[p-newf] = '\0';
    return TRUE;
}

void
skipline()
{
    for (; fdch != '\n'; fdch = getc(fd))
	;
}

getfield(field)
char *field;
{
    char *fend, c;

    for (; fdch == ' ' || fdch == '\t' || fdch == '\\'; fdch = getc(fd))
	if (fdch == '\\')
	    if ((c = getc(fd)) != '\n') {
		(void)ungetc(c, fd);
		break;
	    }
    if (fdch == '\n')
	Fatal("fontdesc: %s illegal line %d", fdname, fdline);
    for (fend = field+STRSIZE-1;
	 fdch != ' ' && fdch != '\t' && fdch != '\n'; fdch = getc(fd)) {
	if (fdch == '\\')
	    if ((c = getc(fd)) != '\n') {
		(void)ungetc(c, fd);
	    } else {
		fdch = ' ';
		break;
	    }
	if (field < fend)
	    *field++ = fdch;
	else
	    Fatal("fontdesc: field too long (%s line %d)", fdname, fdline);
    }
    *field = '\0';
}

getqfield(field)
char *field;
{
    char *fend, c;

    for (; fdch == ' ' || fdch == '\t'; fdch = getc(fd))
	if (fdch == '\\')
	    if ((c = getc(fd)) != '\n') {
		(void)ungetc(c, fd);
		break;
	    }
    if (fdch == '\n')
	Fatal("fontdesc: %s illegal line %d", fdname, fdline);
    if (fdch == FDQUO) {
	*field++ = fdch;
	for (fend = field+STRSIZE-1; (*field++ = getc(fd)) != FDQUO; ) {
	    if (fdch == '\\')
		*(field-1) = getc(fd);
	    if (field >= fend)
		Fatal("fontdesc: field too long (%s line %d)", fdname, fdline);
	}
	*field = '\0';
	fdch = getc(fd);
    } else
	getfield(field);
}

struct confop skipcop = {
    "",
    skipline
};

struct confop *
findconfop(field)
char *field;
{
    struct confop **co;

    for (co = confops; *co != NULL; co++)
	if (STREQ((*co)->co_name, field))
	    return (*co);
    Warning("fontdesc: %s illegal (%s line %d)", field, fdname, fdline);
    return (&skipcop);
}

/*
 * configuration operations
 */

void getfontdesc();
struct confop fdcop = {
    "fontdesc",
    getfontdesc
};

void
getfontdesc()
{
    char field_file[PATHLEN];

    getfield(field_file);
    skipline();
    read_fontdesc(field_file, FALSE);
}

void getfdfont();
struct confop fontcop = {
    "font",
    getfdfont
};

struct fontdesc {
    struct fontop *fd_op;
    char *fd_spec;	/* specifier */ /* not used */
    int	fd_sub;		/* font substitution */
    char *fd_path;	/* prototype path */
    struct fontdesc *fd_next;
};
static struct fontdesc *fontdescs = NULL;
static struct fontdesc **nextfd = &fontdescs;

void
getfdfont()
{
    char field_type[STRSIZE];
    char field_spec[STRSIZE];
    char field_sub[STRSIZE];
    char field_path[STRSIZE];
    struct fontdesc *fd;
    struct fontop *fop;
    struct fontop *findfontop();

    getfield(field_type);
    if ((fop = findfontop(field_type)) == NULL) {
	Warning("fontdesc: illegal font type %s (%s line %d)",
		field_type, fdname, fdline);
	skipline();
	return;
    }
    getfield(field_spec);
    getfield(field_sub);
    getfield(field_path);
    skipline();
    fd = NEW(struct fontdesc, "fontdesc");
    fd->fd_op = fop;
    fd->fd_spec = strsave(field_spec);
    fd->fd_sub = atoi(field_sub);
    fd->fd_path = strsave(field_path);
    fd->fd_next = NULL;
    *nextfd = fd;
    nextfd = &(fd->fd_next);
}

struct fontop *
findfontop(type)
register char *type;
{
    register struct fontop **fo;
    
    for (fo = fontops; *fo != NULL; fo++)
	if (STREQ((*fo)->fo_type, type))
	    return (*fo);
    return (NULL);
}

void getresolution();
struct confop resolutioncop = {
    "resolution",
    getresolution
};

void
getresolution()
{
    char fd_resolution[STRSIZE];

    getfield(fd_resolution);
    resolution = atoi(fd_resolution);
    skipline();
}

void getinclude();
struct confop includecop = {
    "include",
    getinclude
};
void getsetup();
struct confop setupcop = {
    "setup",
    getsetup
};

struct devfile {
    char *df_file;
    struct devfile *df_next;
};
static struct devfile *includefiles = NULL;
static struct devfile **nextif = &includefiles;
static struct devfile *setupfiles = NULL;
static struct devfile **nextsf = &setupfiles;

void
add_include(f, top)
char *f;
BOOLEAN top;
{
    add_devfile(f, top, "includefile", &nextif);
}

void
add_setup(f, top)
char *f;
BOOLEAN top;
{
    add_devfile(f, top, "setupfile", &nextsf);
}

add_devfile(f, top, k, np)
char *f;
BOOLEAN top;
char *k;
struct devfile ***np;
{
    register struct devfile *df;
    char fdfile[PATHLEN];
    char newlibdir[PATHLEN];

    if (*f == FDQUO) {
	*(f+strlen(f)-1) = '\0';
    } else if (searchfile(f, fdfile, newlibdir, top, INCEXT)) {
	f = strsave(fdfile);
    } else
	Fatal("cannot open file %s", f);
    df = NEW(struct devfile, k);
    df->df_file = f;
    df->df_next = NULL;
    **np = df;
    *np = &(df->df_next);
}

void
getinclude()
{
    getdevfile(add_include);
}

void
getsetup()
{
    getdevfile(add_setup);
}

getdevfile(add)
void (*add)();
{
    char field_file[PATHLEN];

    getqfield(field_file);
    skipline();
    (*add)(field_file, FALSE);
}

do_include(ops, opf)
void (*ops)();
void (*opf)();
{
    do_devfile(includefiles, ops, opf);
}

do_setup(ops, opf)
void (*ops)();
void (*opf)();
{
    do_devfile(setupfiles, ops, opf);
}

do_devfile(df, ops, opf)
register struct devfile *df;
void (*ops)();
void (*opf)();
{
    char file[PATHLEN];

    for (; df != NULL; df = df->df_next)
	if (*(df->df_file) == FDQUO)
	    (*ops)(df->df_file+1);
	else
	    (*opf)(df->df_file, file);
}

void getsubst();
struct confop substcop = {
    "subst",
    getsubst
};

struct fontsubst {
    char *fs_font;
    int fs_len;
    int fs_reqmag;
    int fs_submag;
    struct fontsubst *fs_next;
};
static struct fontsubst *fontsubsts = NULL;
static struct fontsubst **nextfs = &fontsubsts;

void
getsubst()
{
    char field_font[STRSIZE];
    char field_reqmag[STRSIZE];
    char field_submag[STRSIZE];
    struct fontsubst *fs;;

    getfield(field_font);
    getfield(field_reqmag);
    getfield(field_submag);
    skipline();
    fs = NEW(struct fontsubst, "fontsubst");
    fs->fs_font = strsave(field_font);
    fs->fs_len = strlen(field_font);
    fs->fs_reqmag = atoi(field_reqmag);
    fs->fs_submag = atoi(field_submag);
    fs->fs_next = NULL;
    *nextfs = fs;
    nextfs = &(fs->fs_next);
}

void getreplfont();
struct confop replfcop = {
    "replfont",
    getreplfont
};

struct fontreplace {
    char *fr_replfont;
    char *fr_font;
    int fr_ds;
    int fr_fix;
    struct fontreplace *fr_next;
};
static struct fontreplace *fontreplaces = NULL;
static struct fontreplace **nextfr = &fontreplaces;

void
getreplfont()
{
    char field_replfont[STRSIZE];
    char field_font[STRSIZE];
    char field_par[STRSIZE];
    struct fontreplace *fr;
    char *c;
    BOOLEAN fixs;
    float fx;

    getfield(field_replfont);
    getfield(field_font);
    getfield(field_par);
    skipline();
    fr = NEW(struct fontreplace, "fontreplace");
    fr->fr_replfont = strsave(field_replfont);
    fr->fr_font = strsave(field_font);
    for (c = field_par; *c != '\0' && *c != '/'; c++)
	;
    fixs = *c == '/';
    *c = '\0';
    fr->fr_ds = atoi(field_par)<<16;
    if (fixs) {
	c++;
	if (*c == 'f')
	    fr->fr_fix = atoi(c+1);
	else {
	    (void)sscanf(c, "%f", &fx);
	    fr->fr_fix = (int)(fx*(float)(1<<20));
	}
    } else
	fr->fr_fix = -1;
    fr->fr_next = NULL;
    *nextfr = fr;
    nextfr = &(fr->fr_next);
}


/*
 * replace font
 */
replfont(n, s, rn, rd, rs)
char *n;
int s;
char *rn;
int *rd, *rs;
{
    struct fontreplace *fr;
    char *sb, *se;

    for (fr = fontreplaces; fr != NULL; fr = fr->fr_next)
	if (match_subf(fr->fr_replfont, n, FALSE, &sb, &se)) {
	    subst_subf(rn, fr->fr_font, sb, se);
	    *rd = fr->fr_ds;
	    if (fr->fr_fix < 0)
		*rs = s;
	    else
		*rs = scale_exact(fr->fr_fix, s);
	    return TRUE;
	}
    return FALSE;
}

/*
 * init_fontinfo
 */
void
init_fontinfo(fe)
struct font_entry *fe;
{
    struct accarg acca;
    float rawmagfact, newmagfact;
    register struct fontdesc *fd;
    struct fontsubst *fs;
    char *sb, *se;
    int i, next;
    int null_markchar();

    acca.rawmagfact = rawmagfact = newmagfact = dev_fontmag(fe);
    acca.pv_name = fe->n;
    /* We don't treat the case fe->a != 0 */

    acca.acc_mode = ACC_EXACT;
    acca.actmagfact = actfact(acca.rawmagfact);
    for (fd = fontdescs; fd != NULL; fd = fd->fd_next) {
	if ((*(fd->fd_op->fo_access))(fd->fd_path, fe, &acca)) {
	    (*(fd->fd_op->fo_initfontinfo))(fe);
	    return;
	}
    }

    acca.acc_mode = ACC_SUBST;
    for (fs = fontsubsts; fs != NULL; fs = fs->fs_next)
	if (match_subf(fs->fs_font, fe->n, TRUE, &sb, &se)) {
	    acca.submag = fs->fs_submag;
	    acca.reqmag = fs->fs_reqmag;
	    for (fd = fontdescs; fd != NULL; fd = fd->fd_next) {
		if ((fd->fd_sub&ACC_SUBST) == 0)
		    continue;
		if ((*(fd->fd_op->fo_access))(fd->fd_path, fe, &acca)) {
		    (*(fd->fd_op->fo_initfontinfo))(fe);
		    Warning("Font file for %s: font mag %d replaced by %d",
			    fe->n, fs->fs_reqmag, fs->fs_submag);
		    return;
		}
	    }
	}

    acca.acc_mode = ACC_MAGSTEP;
    (void)apprfact(rawmagfact);
    for (i = 0; ; i = next) {
	acca.stepmagfact = newmagfact = mag_table[mag_index+i];
	for (fd = fontdescs; fd != NULL; fd = fd->fd_next) {
	    if ((fd->fd_sub&ACC_MAGSTEP) == 0)
		continue;
	    if ((*(fd->fd_op->fo_access))(fd->fd_path, fe, &acca)) {
		(*(fd->fd_op->fo_initfontinfo))(fe);
		Warning("Font file for %s: magnification %d replaced by %d",
			fe->n, MAGSIZE(rawmagfact), MAGSIZE(newmagfact));
		return;
	    }
	}
	if (i >= 0) {
	    if (mag_index+(next = -i-1) < 0)
		if (mag_index+(next = i+1) >= magtabsize)
		    goto notfound;
	} else {
	    if (mag_index+(next = -i) >= magtabsize)
		if (mag_index+(next = i-1) < 0)
		    goto notfound;
	}
    }

 notfound:	/* allow missing FNT files */
    Warning("No font file for %s in magnification %d",
	    fe->n, MAGSIZE(rawmagfact));
    if (Debugoff)
	Warning("(use -d option to know the font file names tried)");
    fe->fnt_markchar = null_markchar;
    (void)sprintf(fe->name, "null:%s:%d", fe->n, MAGSIZE(rawmagfact));
}

/*
 * Turn a prototype path into a fullpath.
 */
void
pave(path, proto, acca)
char *path, *proto;
struct accarg *acca;
{
    register char *p, *s, *t;
    char *pend;
    int len;
    char buf[32];
#ifdef MSDOS
    char *l, *b;
#endif

    for (p = path, s = proto, pend = path+PATHLEN-1; *s != '\0'; s++)
	if (*s == '%') {
	    switch (*++s) {
	    case 'f':
	    case 'n':
	    case 's':
#ifdef MSDOS
		len = strlen(t = acca->pv_name);
		if ((l = rindex(t, '.')) == NULL)
		    l = t+len;
		if (l-t > 8) {
		    if (G_longfontname) {
			(void)strncpy(buf, t, 4);
			(void)strncpy(buf+4, l-4, 4);
		    } else {
			(void)strncpy(buf, t, 8);
		    }
		    b = buf+8;
		} else {
		    (void)strncpy(buf, t, l-t);
		    b = buf+(l-t);
		}
		(void)strncpy(b, l, len-(l-t)+1);
		t = buf;
#else
		t = acca->pv_name;
#endif
		break;
	    case 'd':
	    case 'm':
		(void)sprintf(t = buf, "%d", acca->pv_mag);
		break;
	    case 'F':
		t = acca->pv_fam;
		break;
	    case 'D':
		(void)sprintf(t = buf, "%d", acca->pv_ds);
		break;
	    case 'j':
		t = acca->pv_jsub;
		break;
	    default:
		*(t = buf) = *s;  *(t+1) = '\0';
		break;
	    }
	    if (p + (len = strlen(t)) <= pend) {
		(void)strncpy(p, t, len);
		p += len;
	    } else
		Fatal("font path too long %s", proto);
	} else if (p < pend) {
	    *p++ = *s;
	} else
	    Fatal("font path too long %s", proto);
    *p = '\0';
}
