/*
 * DEVICE dependent I/O
 */

#include	"defs.h"
#include	"emit.h"
#include	"global.h"

void
ps_copyfile(str)
char *str;
{
    EMIT(outfp, "%%%%BeginFile: %s\n", str);
    copyfile(str, FALSE);
    EMIT(outfp, "%%%%EndFile\n");
}

void
ps_copyfigfile(str)
char *str;
{
    BOOLEAN found;
    char newf[PATHLEN];

    EMIT(outfp, "%%%%BeginDocument: %s\n", str);
    found = FALSE;
    if (str[0] == '/') {
	if (access(str, R_OK) == 0) {
	    copyfile(str, G_removecomments);
	    found = TRUE;
	}
    } else {
	if (dvidirpath[0] != '\0') {
	    (void)strcpy(newf, dvidirpath);
	    (void)strcat(newf, str);
	    if (access(newf, R_OK) == 0) {
		copyfile(newf, G_removecomments);
		found = TRUE;
	    }
	}
	if (!found) {
	    if (access(str, R_OK) == 0) {
		copyfile(str, G_removecomments);
		found = TRUE;
	    }
	}
	if (!found) {
	    (void)strcpy(newf, dvi2lib);
	    (void)strcat(newf, "/");
	    (void)strcat(newf, str);
	    if (access(newf, R_OK) == 0) {
		copyfile(newf, G_removecomments);
		found = TRUE;
	    }
	}
    }
    if (!found)
	Warning("File %s not found", str);
    EMIT(outfp, "%%%%EndDocument\n");
}

void
ps_createpipe(str)
char *str;
{
    EMIT(outfp, "%%%%BeginDocument: %s\n", str);
    createpipe(str, G_removecomments);
    EMIT(outfp, "%%%%EndDocument\n");
}

void
ps_copystring(str)
char *str;
{
    EMIT(outfp, "%s\n", str);
}

void
ps_string(str)
char *str;
{
    register int i;
    register int instring = 0;
    int lastc = 0;

    i = 0 ;
    while (*str) {
	if (i > 65 && *str == ' ' && instring == 0) {
	    EMITC('\n');
	    i = 0;
	} else {
	    EMITC(*str);
	    i++;
	}
	if (*str == '(' && lastc != '\\')
	    instring = 1;
	else if (*str == ')' && lastc != '\\')
	    instring = 0;
	lastc = *str;
	str++;
    }
}

pschar(c)
register int c;
{
    if (c < ' ' || c >= 0177)
	EMITO(c);
    else if (c == '(' || c == ')' || c == '\\') {
	EMITC('\\');
	EMITC(c);
    } else
	EMITC(c);
}

codetopsstr(code, n)
int code, n;
{
    EMITC('(');
    c2pstr(code, n);
    EMITS(") ");
}

c2pstr(code, n)
int code, n;
{
    if (n > 0) {
	c2pstr(code>>8, n-1);
	pschar(code&0xff);
    }
}


/*-->copyfile*/   /* copy a file straight through to output */
/*********************************************************************/
/***************************** copyfile ******************************/
/*********************************************************************/

copyfile(str, flag)
char *str;
BOOLEAN flag;
{
    FILE *spfp;
    int t, pt;
    
    if ((spfp = fopen(str,"r")) == NULL) {
	Warning("Unable to open file %s", str);
	return;
    }
    if (!G_quiet)
	(void)fprintf(stderr, "[%s", str);
    if (flag) {
	pt = '\n';
	while ((t = getc(spfp)) != EOF) {
	    if (t == '%' && pt == '\n') {
		while ((t = getc(spfp)) != EOF)	/* remove comments */
		    if (t == '\n')
			break;
	    } else {
		EMITC(t);
		pt = t;
	    }
	}
    } else
	while ((t = getc(spfp)) != EOF)
	    EMITC(t);
    (void)fclose(spfp);
    if (!G_quiet) {
	(void)fprintf(stderr, "] ");
	(void)fflush(stderr);
    }
}

/*-->createpipe*/   /* create pipe  */
/*********************************************************************/
/***************************** createpipe ******************************/
/*********************************************************************/
createpipe(str, flag)
char *str;
BOOLEAN flag;
{
    FILE *spfp;
    int t, pt;
    
#ifdef MSDOS
    Warning("MSDOS does not have pipes");
    return;
#else
    if ((spfp = popen(str,"r")) == NULL) {
	Warning("Unable to create pipe %s", str);
	return;
    }
    if (!G_quiet)
	(void)fprintf(stderr, "[%s", str);
    if (flag) {
	pt = '\n';
	while ((t = getc(spfp)) != EOF) {
	    if (t == '%' && pt == '\n') {
		while ((t = getc(spfp)) != EOF)	/* remove comments */
		    if (t == '\n')
			break;
	    } else {
		EMITC(t);
		pt = t;
	    }
	}
    } else
	while ((t = getc(spfp)) != EOF)
	    EMITC(t);
    (void)pclose(spfp);
    if (!G_quiet) {
	(void)fprintf(stderr, "] ");
	(void)fflush(stderr);
    }
#endif
}
