#include	"defs.h"
#include	"global.h"
#include	"rastfont.h"

struct passrastfntinfo passrfinfo;

rast_access(proto, fe, acca, t)
char *proto;
register struct font_entry *fe;
register struct accarg *acca;
int t;
{
    fe->finfo = (struct finfo *)&passrfinfo;
    switch (acca->acc_mode) {
    case ACC_EXACT:
	acca->pv_mag = ROUND(acca->actmagfact*resolution*t);
	passrfinfo.corrfact = 1;
	break;
    case ACC_SUBST:
	if (ROUND(acca->actmagfact*resolution*t) != acca->reqmag)
	    return (FALSE);
	acca->pv_mag = acca->submag;
	passrfinfo.corrfact = (float)acca->reqmag/(float)acca->submag;
	break;
    case ACC_MAGSTEP:
	acca->pv_mag = ROUND(acca->stepmagfact*resolution*t);
	passrfinfo.corrfact = acca->rawmagfact/acca->stepmagfact;
	break;
    }
    pave(fe->name, proto, acca);
#ifdef DEBUG
    if (Debuguser && acca->acc_mode == ACC_EXACT)
	(void)fprintf(stderr, "trying to access %s\n", fe->name);
#endif
    return (access(fe->name, R_OK) == 0);
}

check_id(name, id)
char	*name;
int	id;
{
    FILE *tfp;

    if ((tfp = BINARYOPEN(name)) == NULL)
	Fatal("FNT file %s could not be opened", name);
    if (getuint(tfp, 4) != id) {
	(void)fclose(tfp);
	return (FALSE);
    }
    (void)fseek(tfp, -4L, 2);
    if (getuint(tfp, 4) != id) {
	(void)fclose(tfp);
	return (FALSE);
    }
    (void)fclose(tfp);
    return (TRUE);
}

init_rast_fontinfo(fe)
register struct font_entry *fe;
{
    register int i;
    struct keeprastfntinfo *k;
    int	rast_markchar();

    fe->fnt_markchar = rast_markchar;
    k = (struct keeprastfntinfo *)
	alloc_check(malloc((unsigned)sizeof(struct keeprastfntinfo)+
			   MAXMARKCHAR*sizeof(char)),
		    "keeprastfntinfo");
    for (i = 0; i <= MAXMARKCHAR; i++)
	k->mark[i] = FALSE;
    k->maxc = 0;
    k->corrfact = passrastfinfo(fe)->corrfact;
    keeprastfinfo(fe) = k;
}

rast_markchar(c)
int c;
{
    if (c > MAXMARKCHAR) {
	Warning("char %d in %s ignored", c, curfontent->name);
	return;
    }
    keeprastfinfo(curfontent)->mark[c] = TRUE;
    if (c > keeprastfinfo(curfontent)->maxc)
	keeprastfinfo(curfontent)->maxc = c;
}

struct rastfntinfo *
alloc_rastfinfo(nchars, init, krfi)
int nchars, init;
struct keeprastfntinfo *krfi;
{
    register struct rastfntinfo *rfi;
    register struct rastchar_entry *ce;	/* temporary char_entry pointer  */
    register int i;

    rfi = (struct rastfntinfo *)
	  alloc_check(malloc((unsigned)sizeof(struct rastfntinfo)+
			     (nchars-1)*sizeof(struct rastchar_entry)),
		      "rastfont info");
    if (init)
	for (i = 0; i < nchars; i++) {
	    ce = &(rfi->ch[i]);
	    ce->width = 0;
	    ce->height = 0;
	    ce->xoffset= 0;
	    ce->yoffset = 0;
	    /*ce->dev_font = NONFONT;*/
	    /*ce->dev_char = NONCHAR;*/
	    ce->where.fileoffset = NONEXISTANT;
	    ce->tfmw = 0;
	}
    rfi->corrfact = krfi->corrfact;
    return (rfi);
}

/* returs the current fontdict of raster font */
DEV_FONT
rast_fontdict(fe, c)
struct font_entry *fe;
int c;
{
    /* char range check omitted */
    return (rastfinfo(fe)->ch[c].dev_font);
}
