#define	MAXMARKCHAR	255	/* >= 255 */
#define	NONEXISTANT	-1	/* offset for raster files not found */

struct rastchar_entry {		/* character entry */
    unsigned short width, height;/* width and height in pixels */
    short xoffset, yoffset;	/* x offset and y offset in pixels */
    short dev_font, dev_char;
    unsigned short nbpl;	/* # of bytes per pixel data line */
    union {
	unsigned int fileoffset;
	char *pixptr;
    } where;
    int tfmw;			/* TFM width */
};

struct rastfntinfo {
    /* int font_space;	/* computed from FNT_DEF s parameter	*/
    /* int font_mag;	/* computed from FNT_DEF s and d parameters */
    /* int designsize;	/* design size read from raster file	*/
    float corrfact;
    int nfntchars;
    int dictform;	/* form of dev_font dictionary		*/
    struct rastchar_entry ch[1];	/* character information	*/
};

/* form of dictionary */
#define	PACK		0
#define	DVI		1

#define	rastfinfo(fe)	((struct rastfntinfo *)(fe->finfo))

/* used to pass information from access to initfontinfo */
struct passrastfntinfo {
    /* int font_mag; */
    float corrfact;
};

/* used to pass information from initfontinfo to readfontinfo
   and to pass marking information */
struct keeprastfntinfo {
    /* int font_mag; */
    float corrfact;
    int maxc;
    char mark[1];
};

#define	passrastfinfo(fe)	((struct passrastfntinfo *)(fe->finfo))
#define	keeprastfinfo(fe)	((struct keeprastfntinfo *)(fe->finfo))

struct rastfntinfo *alloc_rastfinfo();
DEV_FONT rast_fontdict();


/*
 * Interface with device driver
 */
void dev_rast_initfe();
void dev_rast_initfontdict();
