/*
 * funtions for analyzing dvi in dvi-file (dfd stands for dvi-file dvi)
 */

#include	"defs.h"
#include	"commands.h"
#include	"dconv.h"
#include	"global.h"

int dfd_getcommand();
void dfd_backupone();
void dfd_getbytes();
void dfd_skipbytes();
int dfd_getuint();
int dfd_getint();
void dfd_movedown();
void dfd_moveover();
void dfd_setrule();
struct dconv dfd_dconv_templ = {
    dfd_getcommand,
    dfd_backupone,
    dfd_getbytes,
    dfd_skipbytes,
    dfd_getuint,
    dfd_getint,
    NULL,
    NULL,
    NULL,
    dfd_movedown,
    dfd_moveover,
    dfd_setrule,
    0
};

int
dfd_getcommand()
{
    return getuint(dc_file, 1);
}

void
dfd_backupone()
{
    (void)fseek(dc_file, -1L, 1);
}

void
dfd_getbytes(cp, n)
byte *cp;
int n;
{
    getbytes(dc_file, cp, n);
}

void
dfd_skipbytes(n)
int n;
{
    (void)fseek(dc_file, (long)n, 1);
}

int
dfd_getuint(n)
int n;
{
    return getuint(dc_file, n);
}

int
dfd_getint(n)
int n;
{
    return getint(dc_file, n);
}


void
ReadFontDef(k, hdfip)
int k;
struct font_index **hdfip;
{
    int	c, s, d, a, l;
    byte n[STRSIZE];

    c = getuint(dc_file, 4);	/* checksum */
    s = getuint(dc_file, 4);	/* scaled size */
    d = getuint(dc_file, 4);	/* design size */
    a = getuint(dc_file, 1);	/* area length for font name */
    l = getuint(dc_file, 1);	/* device length */
    getbytes(dc_file, n, a+l);
    n[a+l] = '\0';
    readfontdef(k, c, s, d, a, l, (char *)n, hdfip);
}

void
SkipFontDef()
{
    int a, l;

    skipbytes(dc_file, 4*3);
    a = getuint(dc_file, 1);
    l = getuint(dc_file, 1);
    skipbytes(dc_file, a+l);
}

int
HasBeenRead(k, hdfidx)
int k;
struct font_index *hdfidx;
{
    register struct font_index *ptr;

    for (ptr = hdfidx; (ptr!=NULL) && (ptr->k!=k); )
	ptr = ptr->next;
    return (ptr != NULL);
}


void
dfd_movedown(a)
int a;
{
    v += a;
}

void
dfd_moveover(b)
int b;
{
    h += b;
}

void
dfd_setrule(a, b, Set)	/* this routine will draw a rule */
int a, b;
BOOLEAN Set;
{
    if (a > 0 && b > 0) {
	dev_setposn(h, v);	/* lower left corner */
	dev_setrule(a, b);
    }
    if (Set)
	h += b;
}
