/*
 * DEVICE dependent, built-in font dependent
 */

#include	"defs.h"
#include	"emit.h"
#include	"global.h"
#include	"bifont.h"
#include	"jsub.h"
#include	"ps.h"


/* bifont & bikanji
 */
void getbuiltin();
struct confop bicop = {
    "builtin",
    getbuiltin
};
void getbifont();
struct confop bfcop = {
    "bifont",
    getbifont
};
void getbikanji();
struct confop bkcop = {
    "bikanji",
    getbikanji
};

#define	BF_NAME_STRICT	0
#define	BF_NAME_INITIAL	1
#define	BF_NAME_REG	2

#define	BF_TYPE_TFM	0
#define	BF_TYPE_KAN	1	/* backward compatibility */
#define	BF_TYPE_SUB	2	/* subfont */
#define	BF_TYPE_JFM	3

#define	BF_FONT_TFM	0
#define	BF_FONT_NAT	1
#define	BF_FONT_EQU	2
#define	BF_FONT_SPC	3
#define	BF_FONT_FRC	4

#define	BF_POS_CLOSED	0
#define	BF_POS_REL	1
#define	BF_POS_ABS	2
#define	BF_POS_UNDEF	3

struct bifont {
    char *bf_name;
    int bf_len;
    int bf_fam;
    char bf_mode_name;
    char bf_mode_type;
    char bf_mode_font;
    char bf_mode_pos;
    int bf_stand;
    char *bf_psfont;
    char *bf_psname;
    int bf_created;
    struct bifont *bf_next;
};
struct bifont *bifonts = NULL;
struct bifont **nextbf = &bifonts;
int bffam = 1;
void getbuiltinfont();

void
getbuiltin()
{
    getbuiltinfont("builtin", &nextbf,
		   BF_NAME_STRICT, BF_TYPE_TFM, BF_FONT_TFM, BF_FONT_SPC);
}

void
getbifont()
{
    getbuiltinfont("bifont", &nextbf,
		   BF_NAME_STRICT, BF_TYPE_TFM, BF_FONT_TFM, BF_FONT_SPC);
}

void
getbikanji()
{
    getbuiltinfont("bikanji", &nextbf,
		   BF_NAME_INITIAL, BF_TYPE_KAN, BF_FONT_NAT, BF_FONT_NAT);
}

void
getbuiltinfont(cop, next, defm_name, defm_type, defm_font, defm_font_fix)
char *cop;
struct bifont ***next;
char defm_name, defm_type, defm_font, defm_font_fix;
{
    char field_name[STRSIZE];
    char field_mode[STRSIZE];
    char field_psfont[STRSIZE];
    register struct bifont *bf;
    char *mode, *he;

    getfield(field_name);
    getfield(field_mode);
    getqfield(field_psfont);
    skipline();
    bf = NEW(struct bifont, cop);
    bf->bf_name = strsave(field_name);
    bf->bf_len = strlen(field_name);
    bf->bf_fam = bffam++;
    if (strcmp(field_mode, "fixed") == 0) {
	bf->bf_mode_name = defm_name;
	bf->bf_mode_type = defm_type;
	bf->bf_mode_font = defm_font_fix;
	bf->bf_mode_pos = BF_POS_UNDEF;
    } else if (strcmp(field_mode, "var") == 0) {
	bf->bf_mode_name = defm_name;
	bf->bf_mode_type = defm_type;
	bf->bf_mode_font = BF_FONT_TFM;
	bf->bf_mode_pos = BF_POS_UNDEF;
    } else {
	mode = field_mode;
	switch (*mode++) {
	case 'T':
	    bf->bf_mode_type = BF_TYPE_TFM;
	    break;
	case 'K':
	    bf->bf_mode_type = BF_TYPE_KAN;
	    break;
	case 'S':
	    bf->bf_mode_type = BF_TYPE_SUB;
	    break;
	case 'J':
	    bf->bf_mode_type = BF_TYPE_JFM;
	    break;
	case '*':
	default:
	    bf->bf_mode_type = defm_type;
	    break;
	}
	switch (*mode++) {
	case 'S':
	    bf->bf_mode_name = BF_NAME_STRICT;
	    break;
	case 'I':
	    bf->bf_mode_name = BF_NAME_INITIAL;
	    break;
	case 'R': /* not implemented */
	case '*':
	default:
	    bf->bf_mode_name = defm_name;
	    break;
	}
	switch (*mode++) {
	case 'T':
	    bf->bf_mode_font = BF_FONT_TFM;
	    break;
	case 'N':
	    bf->bf_mode_font = BF_FONT_NAT;
	    break;
	case 'E':
	    bf->bf_mode_font = BF_FONT_EQU;
	    bf->bf_stand = htoi(++mode, &he);
	    mode = he+1;
	    break;
	case 'S':
	    bf->bf_mode_font = BF_FONT_SPC;
	    break;
	case 'F':
	    bf->bf_mode_font = BF_FONT_FRC;
	    bf->bf_stand = htoi(++mode, &he);
	    mode = he+1;
	    break;
	case '*':
	default:
	    bf->bf_mode_font = defm_font;
	    break;
	}
	switch (*mode++) {
	case 'R':
	default:
	    bf->bf_mode_pos = BF_POS_REL;
	    break;
	case 'A':
	    bf->bf_mode_pos = BF_POS_ABS;
	    break;
	case '*':
	    bf->bf_mode_pos = BF_POS_UNDEF;
	    break;
	}
    }
    if (field_psfont[0] == FDQUO)
	field_psfont[strlen(field_psfont)-1] = '\0';
    bf->bf_psfont = strsave(field_psfont);
    bf->bf_created = FALSE;
    bf->bf_next = NULL;
    **next = bf;
    *next = &(bf->bf_next);
}

comp_bfname(name, bf)
char *name;
struct bifont *bf;
{
    if (bf->bf_mode_name == BF_NAME_STRICT &&
	strcmp(name, bf->bf_name) == 0) {
	return TRUE;
    } else if (bf->bf_mode_name == BF_NAME_INITIAL &&
	       strncmp(name, bf->bf_name, bf->bf_len) == 0) {
	return TRUE;
    }
    return FALSE;
}

struct bifont *
findbifont(name)
char *name;
{
    register struct bifont *bf;

    for (bf = bifonts; bf != NULL; bf = bf->bf_next)
	if (bf->bf_mode_type == BF_TYPE_TFM)
	    if (comp_bfname(name, bf))
		return bf;
    return NULL;
}

struct bifont *
findbksub(name)
char *name;
{
    register struct bifont *bf;
    char *subbeg, *subend;

    for (bf = bifonts; bf != NULL; bf = bf->bf_next) {
	if (bf->bf_mode_type == BF_TYPE_SUB) {
	    if (match_subf(bf->bf_name, name,
			   bf->bf_mode_name == BF_NAME_INITIAL,
			   &subbeg, &subend))
		return bf;
	} else if (bf->bf_mode_type == BF_TYPE_KAN)
	    if (comp_bfname(name, bf)) {
		foundjsubf = getjsubfont(name+bf->bf_len, &subend);
		return bf;
	    }
    }
    return NULL;
}

struct bifont *
findbkjfm(name)
char *name;
{
    register struct bifont *bf;

    for (bf = bifonts; bf != NULL; bf = bf->bf_next)
	if (bf->bf_mode_type == BF_TYPE_JFM ||
	    bf->bf_mode_type == BF_TYPE_KAN)
	    if (comp_bfname(name, bf))
		return bf;
    return NULL;
}

static int bifcount = 0;

char *
newbifont(psn, bf)
char *psn;
struct bifont *bf;
{
    char newbifname[STRSIZE];

    if (!(bf->bf_created)) {
	bf->bf_created = TRUE;
	if (psn[0] == FDQUO) {
	    (void)sprintf(newbifname, "bf%d", bifcount++);
	    bf->bf_psname = strsave(newbifname);
	    EMIT(outfp, "/%s %s\n", bf->bf_psname, psn+1);
	} else {
	    bf->bf_psname = bf->bf_psfont;
	}
    }
    return (bf->bf_psname);
}


/* TYPE: tfm
 */
dev_tfm_initfontdict(fe)
struct font_entry *fe;
{
    struct bifont *bf;
    int size;
    char *psop, *dev_name;
    BOOLEAN extraarg = FALSE;
    int stand;
    int mode_pos;

    fe->k = dev_newdevfont();
    if ((bf = findbifont(fe->n)) != NULL) {
	switch (bf->bf_mode_font) {
	case BF_FONT_TFM:
	    size = fe->s;
	    psop = "BFT";
	    break;
	case BF_FONT_NAT:
	    size = tfmfinfo(fe)->ch[tfmfinfo(fe)->lastfntchar].tfmw;
	    psop = "BFE";
	    break;
	case BF_FONT_EQU:
	    size = tfmfinfo(fe)->ch[bf->bf_stand].tfmw;
	    psop = "BFE";
	    break;
	case BF_FONT_SPC:
	    size = tfmfinfo(fe)->ch[0x20].tfmw;
	    psop = "BFF";
	    extraarg = TRUE;
	    stand = 0x20;
	    break;
	case BF_FONT_FRC:
	    size = tfmfinfo(fe)->ch[bf->bf_stand].tfmw;
	    psop = "BFF";
	    extraarg = TRUE;
	    stand = bf->bf_stand;
	    break;
	}
	dev_name = newbifont(bf->bf_psfont, bf);
	mode_pos = bf->bf_mode_pos;
    } else {
	size = fe->s;
	psop = "BFT";
	dev_name = fe->n;
	mode_pos = BF_POS_REL;
    }
    if (extraarg)
	codetopsstr(stand, 1);
    EMIT(outfp, "/%s /%s %.3f %.3f %s\n",
	 psfname(fe->k), dev_name,
	 (float)size/(float)hconv, -(float)size/(float)vconv, psop);
    fe->ncdl = 0;
    return mode_pos;
}

/* TYPE: jstfm
 */
dev_is_jstfm(name)
char *name;
{
    foundjsubf = 0;
    if (findbksub(name) != NULL)
	return (foundjsubf != 0);
    return FALSE;
}

struct jstfmfdict {
    int jd_jfam;
    int jd_s;
    int jd_jfont;
    int jd_open;
    struct jstfmfdict *jd_next;
};
struct jstfmfdict *jstfmfdicts = NULL;
struct jstfmfdict **nextjd = &jstfmfdicts;

dev_getjsubfont(fe)
register struct font_entry *fe;
{
    register int s, jfam;
    register struct jstfmfdict *jd;
    struct bifont *bf;

    s = fe->s;
    /* bf != NULL, because dev_is_jstfm called from jstfm_access ensures
       fe->n is jstfm. */
    jfam = (bf = findbksub(fe->n))->bf_fam;
    for (jd = jstfmfdicts; jd != NULL; jd = jd->jd_next)
	if (jd->jd_s == s && jd->jd_jfam == jfam) {
	    jstfmfinfo(fe)->dev_font = jd->jd_jfont;
	    jstfmfinfo(fe)->dictopen = &(jd->jd_open);
	    jstfmfinfo(fe)->dev_name = bf->bf_psfont;
	    return foundjsubf;
	}
    jd = NEW(struct jstfmfdict, "jstfmfdict");
    jd->jd_s = s;
    jd->jd_jfam = jfam;
    jd->jd_jfont = jstfmfinfo(fe)->dev_font = dev_newdevfont();
    jd->jd_open = BF_POS_CLOSED;
    jd->jd_next = NULL;
    *nextjd = jd;
    nextjd = &(jd->jd_next);
    jstfmfinfo(fe)->dictopen = &(jd->jd_open);
    jstfmfinfo(fe)->dev_name = bf->bf_psfont;
    return foundjsubf;
}

dev_jstfm_initfontdict(fe)
struct font_entry *fe;
{
    register struct jstfmfntinfo *jstfmfi;
    struct bifont *bf;
    int size;
    char *psop, *dev_name;
    BOOLEAN extraarg = FALSE;
    int stand;

    jstfmfi = jstfmfinfo(fe);
    if (*(jstfmfi->dictopen) == BF_POS_CLOSED) {
	/* bf != NULL, see the comments in dev_getjsubfont */
	bf = findbksub(fe->n);
	switch (bf->bf_mode_font) {
	case BF_FONT_TFM:
	    size = fe->s;
	    psop = "BFT";
	    break;
	case BF_FONT_NAT:
	    /* For now, it is ok to assume that lastchars of all subfonts
	       have the same `standard' metric */
	    size = jstfmfi->ch[jstfmfi->lastfntchar].tfmw;
	    psop = "BFE";
	    break;
	case BF_FONT_EQU:	/* TO DO */
	    size = jstfmfi->ch[bf->bf_stand].tfmw;
	    psop = "BFE";
	    break;
	case BF_FONT_SPC:	/* TO DO */
	    size = jstfmfi->ch[0x20].tfmw;
	    psop = "BFF";
	    extraarg = TRUE;
	    stand = 0x20;
	    break;
	case BF_FONT_FRC:	/* TO DO */
	    size = jstfmfi->ch[bf->bf_stand].tfmw;
	    psop = "BFF";
	    extraarg = TRUE;
	    stand = bf->bf_stand;
	    break;
	}
	dev_name = newbifont(jstfmfi->dev_name, bf);
	if (extraarg)
	    codetopsstr(stand, 1);
	EMIT(outfp, "/%s /%s %.3f %.3f %s\n",
	     psfname(jstfmfi->dev_font), dev_name,
	     (float)size/(float)hconv, -(float)size/(float)vconv, psop);
	*(jstfmfi->dictopen) = bf->bf_mode_pos;
    }
    return *(jstfmfi->dictopen);
}

/* TYPE: jfm
 */
dev_is_jfm(name)
char *name;
{
    return (findbkjfm(name) != NULL);
}

char *
dev_getjfmname(name)
char *name;
{
    return (findbkjfm(name)->bf_psfont);
}

dev_jfm_initfontdict(fe)
struct font_entry *fe;
{
    register struct jfmfntinfo *jfmfi;
    struct bifont *bf;
    int size;
    char *psop, *dev_name;
    BOOLEAN extraarg = FALSE;
    int stand;
    int mode_pos;

    fe->k = dev_newdevfont();
    jfmfi = jfmfinfo(fe);
    if ((bf = findbkjfm(fe->n)) != NULL) {
	switch (bf->bf_mode_font) {
	case BF_FONT_TFM:
	    size = fe->s;
	    psop = "BFT";
	    break;
	case BF_FONT_NAT:
	    size = jfmfi->ch[0].tfmw;	/* == zw */
	    psop = "BFE";
	    break;
	case BF_FONT_EQU:
	    size = jfmfi->ch[getctype(bf->bf_stand,jfmfi)].tfmw;
	    psop = "BFE";
	    break;
	case BF_FONT_SPC:
	    size = jfmfi->ch[getctype(0x2121,jfmfi)].tfmw;
	    psop = "BFF";
	    extraarg = TRUE;
	    stand = 0x2121;
	    break;
	case BF_FONT_FRC:
	    size = jfmfi->ch[getctype(bf->bf_stand,jfmfi)].tfmw;
	    psop = "BFF";
	    extraarg = TRUE;
	    stand = bf->bf_stand;
	    break;
	}
	dev_name = newbifont(jfmfi->dev_name, bf);
	mode_pos = bf->bf_mode_pos;
    } else {
	size = fe->s;
	psop = "BFT";
	dev_name = fe->n;
	mode_pos = BF_POS_REL;
    }
    if (extraarg)
	codetopsstr(stand, 2);
    EMIT(outfp, "/%s /%s %.3f %.3f %s\n",
	 psfname(fe->k), dev_name,
	 (float)size/(float)hconv, -(float)size/(float)vconv, psop);
    fe->ncdl = 0;
    return mode_pos;
}


/*
 * PS dependent setchar/setstring
 */
/* quick hack to disable USERELPOS */
#define	no_userelpos()	--ps_v;

dev_tfm_initfe(fe, pos)
register struct font_entry *fe;
char pos;
{
    DEV_FONT tfm_fontdict();
    int tfm_setchar(), tfm_setstring();
    int tfm_setchar_abs(), tfm_setstring_abs();

    fe->dev_fontdict = tfm_fontdict;
    if (pos == BF_POS_REL || pos == BF_POS_UNDEF) {
	fe->dev_setchar = tfm_setchar;
	fe->dev_setstring = tfm_setstring;
    } else {
	fe->dev_setchar = tfm_setchar_abs;
	fe->dev_setstring = tfm_setstring_abs;
    }
}

tfm_setchar(c)
int c;
{
    register struct tfmchar_entry *ce = &(tfmfinfo(curfontent)->ch[c]);
    register int cw;

    begin_string();
    pschar(ce->dev_char);
    ps_h += (cw = ce->tfmw);
    return cw;
}

tfm_setstring(s, len)
char *s;
int len;
{
    register char *sp;
    register struct tfmchar_entry *ce = tfmfinfo(curfontent)->ch;
    register int cw;

    begin_string();
    for (sp = s, cw = 0; sp < s+len; sp++) {
	pschar((ce+*sp)->dev_char);
	cw += (ce+*sp)->tfmw;
    }
    ps_h += cw;
    return cw;
}

tfm_setchar_abs(c)
int c;
{
    register int cw;

    cw = tfm_setchar(c);
    no_userelpos();
    return cw;
}

tfm_setstring_abs(s, len)
char *s;
int len;
{
    register char *sp;
    register struct tfmchar_entry *ce = tfmfinfo(curfontent)->ch;
    register int cw, w, orig_ps_v;

    orig_ps_v = ps_v;
    for (sp = s, cw = 0; sp < s+len; sp++) {
	begin_string();
	pschar((ce+*sp)->dev_char);
	end_string();
	cw += (w = (ce+*sp)->tfmw);
	no_userelpos();
	dev_setposn(ps_h+w, orig_ps_v);
    }
    return cw;
}

dev_jstfm_initfe(fe, pos)
register struct font_entry *fe;
char pos;
{
    DEV_FONT jstfm_fontdict();
    int jstfm_setchar(), jstfm_setstring();
    int jstfm_setchar_abs(), jstfm_setstring_abs();

    fe->dev_fontdict = jstfm_fontdict;
    if (pos == BF_POS_REL || pos == BF_POS_UNDEF) {
	fe->dev_setchar = jstfm_setchar;
	fe->dev_setstring = jstfm_setstring;
    } else {
	fe->dev_setchar = jstfm_setchar_abs;
	fe->dev_setstring = jstfm_setstring_abs;
    }
}

jstfm_setchar(c)
int c;
{
    register struct jstfmchar_entry *ce = &(jstfmfinfo(curfontent)->ch[c]);
    register int cw;

    begin_string();
    pschar((int)ce->dev_ku);
    pschar((int)ce->dev_ten);
    ps_h += (cw = ce->tfmw);
    return cw;
}

jstfm_setstring(s, len)
char *s;
int len;
{
    register char *sp;
    register struct jstfmchar_entry *ce = jstfmfinfo(curfontent)->ch;
    register int cw;

    begin_string();
    for (sp = s, cw = 0; sp < s+len; sp++) {
	pschar((int)(ce+*sp)->dev_ku);
	pschar((int)(ce+*sp)->dev_ten);
	cw += (ce+*sp)->tfmw;
    }
    ps_h += cw;
    return cw;
}

jstfm_setchar_abs(c)
int c;
{
    register int cw;

    cw = jstfm_setchar(c);
    no_userelpos();
    return cw;
}

jstfm_setstring_abs(s, len)
char *s;
int len;
{
    register char *sp;
    register struct jstfmchar_entry *ce = jstfmfinfo(curfontent)->ch;
    register int cw, w, orig_ps_v;

    orig_ps_v = ps_v;
    for (sp = s, cw = 0; sp < s+len; sp++) {
	begin_string();
	pschar((int)(ce+*sp)->dev_ku);
	pschar((int)(ce+*sp)->dev_ten);
	end_string();
	cw += (w = (ce+*sp)->tfmw);
	no_userelpos();
	dev_setposn(ps_h+w, orig_ps_v);
    }
    return cw;
}

dev_jfm_initfe(fe, pos)
register struct font_entry *fe;
char pos;
{
    DEV_FONT tfm_fontdict();
    int jfm_setchar(), jfm_setstring();
    int jfm_setchar_abs(), jfm_setstring_abs();

    fe->dev_fontdict = tfm_fontdict;
    if (pos == BF_POS_REL) {
	fe->dev_setchar = jfm_setchar;
	fe->dev_setstring = jfm_setstring;
    } else {
	fe->dev_setchar = jfm_setchar_abs;
	fe->dev_setstring = jfm_setstring_abs;
    }
}

jfm_setchar(c)
register int c;
{
    register int cw;
    register struct jfmfntinfo *jfmfi = jfmfinfo(curfontent);

    begin_string();
    pschar(c>>8);
    pschar(c&0xff);
    ps_h += (cw = jfmfi->ch[getctype(c,jfmfi)].tfmw);
    return (cw);
}

/* ARGSUSED */
jfm_setstring(s, len)
char *s;
int len;
{
    Fatal("%s implementation error: jfm_setstring", G_progname);
}

jfm_setchar_abs(c)
int c;
{
    register int cw;

    cw = jfm_setchar(c);
    no_userelpos();
    return cw;
}

/* ARGSUSED */
jfm_setstring_abs(s, len)
char *s;
int len;
{
    Fatal("%s implementation error: jfm_setstring_abs", G_progname);
}
