#include	"defs.h"
#include	"global.h"
#include	"rastfont.h"
#include	"pxlfont.h"

int pxltype_access();
void init_pxl_fontinfo();
struct fontop pxlop = {
    "pxl",
    pxltype_access,
    init_pxl_fontinfo,
};

static FILE *fntfp;
void loadpxlchar();

pxltype_access(proto, fe, acca)
char *proto;
struct font_entry *fe;
struct accarg *acca;
{
    if (rast_access(proto, fe, acca, 5))
	return (check_id(fe->name, PXLID));
    else
	return (FALSE);
}

void
init_pxl_fontinfo(fe)
register struct font_entry *fe;
{
    void read_pxl_fontinfo();

    fe->fnt_readfontinfo = read_pxl_fontinfo;
    init_rast_fontinfo(fe);
}

void
read_pxl_fontinfo(fe)
register struct font_entry *fe;
{
    int t, i, fdir, nchars;
    long possave;
    register struct rastchar_entry *ce;/* temporary char_entry pointer  */
    struct keeprastfntinfo *krfi;
    struct rastfntinfo *rfi;
    int ds, mg;

    openfontfile(fe);
    fntfp = fe->openfile;
    if ((t = getuint(fntfp, 4)) != PXLID)
	Fatal("PXL ID = %d, can only process PXL ID = %d files",
	      t, PXLID);
    (void)fseek(fntfp, -20L, 2);
    t = getuint(fntfp, 4);
    if ((fe->c != 0) && (t != 0) && (fe->c != t))
	Warning("font = \"%s\",\n-->font checksum = %d,\n-->dvi checksum = %d",
		fe->name, fe->c, t);
    mg = getuint(fntfp, 4);
    ds = getuint(fntfp, 4);
    
    t = ftell(fntfp) - 12;
    (void)fseek(fntfp, (long)(fdir = getuint(fntfp, 4) * 4), 0);
    nchars = (t-fdir)/(4*4);
    if (nchars > NPXLCHARS) {
	Fatal("PXL-font dir size of %s is %d\n", fe->name, nchars);
    } else if (nchars != NHALFPXLCHARS && nchars != NPXLCHARS) {
	Warning("PXL-font dir size of %s is %d\n", fe->name, nchars);
    }

    krfi = keeprastfinfo(fe);
    rastfinfo(fe) = rfi = alloc_rastfinfo(krfi->maxc+1, TRUE, krfi);
    dev_rast_initfe(fe);
    /* rfi->designsize = ds; */
    /* rfi->magnification = mg; */
    rfi->nfntchars = nchars;
    for (i = 0; i < nchars; i++) {
	if (krfi->mark[i] == FALSE) {
	    (void)fseek(fntfp, 16L, 1);
	} else {
	    ce = &(rfi->ch[i]);
	    ce->width = getuint(fntfp, 2);
	    ce->height = getuint(fntfp, 2);
	    ce->xoffset = getint(fntfp, 2);
	    ce->yoffset = getint(fntfp, 2);
	    /*ce->dev_char = NONCHAR;*/
	    ce->nbpl = ((ce->width + 31) >> 5) * 4;
	    ce->where.fileoffset = getuint(fntfp, 4) * 4;
	    ce->tfmw = scale(getuint(fntfp, 4), fe->s);
	    if (ce->where.fileoffset == 0) {
		/*ce->where.fileoffset = NONEXISTANT;*/
		Warning("The glyf of char %x in %s missing\n", i, fe->name);
		continue;
	    }
	    possave = ftell(fntfp);
	    loadpxlchar(fe, ce);
	    dev_rast_initfontdict(fe, i);
	    (void)fseek(fntfp, possave, 0);
	}
    }

    free((char *)krfi);
}

/* ARGSUSED */
void
loadpxlchar(fe, ce)
struct font_entry *fe;
register struct rastchar_entry *ce;
{
    char *pixel;
    int nbytes;

    (void)fseek(fntfp, (long)ce->where.fileoffset, 0);
    nbytes = ce->nbpl * ce->height;
    if ((pixel = malloc((unsigned)nbytes)) == NULL)
	Fatal("Unable to allocate memory for char\n");
    (void)fread(pixel, 1, nbytes, fntfp);
    ce->where.pixptr = pixel;
}
