/*
 * funtions for analyzing dvi in vf-file (vfd stands for vf-file dvi)
 */

#include	"defs.h"
#include	"commands.h"
#include	"dconv.h"
#include	"global.h"

int vfd_getcommand();
void vfd_backupone();
void vfd_getbytes();
void vfd_skipbytes();
int vfd_getuint();
int vfd_getint();
void vfd_movedown();
void vfd_moveover();
void vfd_setrule();
struct dconv vfd_dconv_templ = {
    vfd_getcommand,
    vfd_backupone,
    vfd_getbytes,
    vfd_skipbytes,
    vfd_getuint,
    vfd_getint,
    NULL,
    NULL,
    NULL,
    vfd_movedown,
    vfd_moveover,
    vfd_setrule,
    0
};

int
vfd_getcommand()
{
    dc_bufbeg++;
    return (dc_bufbeg > dc_bufend ? POST : *(dc_bufbeg-1));
}

void
vfd_backupone()
{
    --dc_bufbeg;
}

void
vfd_getbytes(cp, n)
char *cp;
int n;
{
    (void)strncpy(cp, (char *)dc_bufbeg, n);
    dc_bufbeg += n;
}

void
vfd_skipbytes(n)
int n;
{
    dc_bufbeg += n;
}

int
vfd_getuint(n)
int n;
{
    register int x;

    x = makeuint(dc_bufbeg, n);
    dc_bufbeg += n;
    return (x);
}

int
vfd_getint(n)
int n;
{
    register int x;

    x = makeint(dc_bufbeg, n);
    dc_bufbeg += n;
    return (x);
}


void
vfd_movedown(a)
int a;
{
    v += scale(a, dc_scale);
}

void
vfd_moveover(b)
int b;
{
    h += scale(b, dc_scale);
}

void
vfd_setrule(a, b, Set)	/* this routine will draw a rule */
int a, b;
BOOLEAN Set;
{
    a = scale(a, dc_scale);
    b = scale(b, dc_scale);
    if (a > 0 && b > 0) {
	dev_setposn(h, v);	/* lower left corner */
	dev_setrule(a, b);
    }
    if (Set)
	h += b;
}
