/* Original Author:         Andrew Trevorrow
   Implementation: Modula-2 under VAX/UNIX 4.2 BSD
   Date Started:   June, 1986
 
   Description:
   These terminal i/o routines are highly system-dependent and have been
   designed for DVItoVDU and its auxiliary modules.
 
   Notes:
 - The implementation block saves the current tty characteristics,
   then sets the mode to cbreak with no echo.
   Clients should therefore call RestoreTerminal before terminating.
 - WriteBuffer or WriteLn must be called to explicitly update the terminal
   (e.g., just before a read) or to synchronize output with writes
   from other modules that don't use ScreenIO.
 
   This version converted to C and ported to BSD and System V UNIX by
   some chaps at Kernel Technology up to September 1989.  Contact
   mjh@uk.co.kernel (Mark J. Hewitt) with bug fixes etc.
 
   Involved were:	Mark J. Hewitt
   			Dave Dixon
			Marc Hadley
*/
 
static char *sccsid_screen[] = "@(#)screenio.h	1.1";
 
extern void Read();
extern void ReadString();
extern short BusyRead();
extern void Write();
extern void WriteString();
extern void WriteInt();
extern void WriteCard();
extern void WriteLn();
extern void WriteBuffer();
extern void RestoreTerminal();
