/* Original Author:         Andrew Trevorrow
   Implementation: Modula-2 under VAX/UNIX 4.2 BSD
   Date Started:   June, 1986
 
   Description:
   This module provides the interface between DVItoVDU and the various
   VDU-specific modules.  InitVDUInterface must be called to initialize
   all the generic VDU parameters and routines.
 
   DVItoVDU assumes as little as possible about the capabilities of a VDU.
   We should be able to implement any VDU that can:
    - mix text and graphics on the screen (some VDUs make no distinction)
    - erase all of the screen, or individual text lines
    - move the cursor to any given screen pixel
    - display a rectangular region of screen pixels (possibly just one).
 
   DVItoVDU's definition of a "screen pixel" is more precisely known as
   an "addressable location".  Most graphic terminals use a coordinate scheme
   in which there are more addressable locations than the number of physical
   pixels making up the screen.  Such VDUs automatically scale given
   addresses to actual physical pixels.
 
   After starting up, DVItoVDU breaks the screen into 2 parts:
 
   1. The DIALOGUE REGION will typically consist of the top 4 text lines on the
      screen.  This region is used to display DVI and window status information,
      various kinds of messages and the command prompt.  DVItoVDU assumes
      text lines on the screen start at 1 and increase downwards.  The bottom
      text line on the screen is given by the parameter bottoml (also the total
      number of text lines).
 
   2. The WINDOW REGION is typically the remaining area of the screen and
      is used to display some sort of representation of the current DVI page.
      The user can move the window over any part of the current page,
      or even completely outside the page edges (but only just).
      The user can scale the page display by changing the width and height of
      the window region; windowwd and windowht are the initial, unscaled
      dimensions where one paper pixel equals one screen pixel.
      When addressing screen pixels, DVItoVDU assumes the top left pixel
      in the screen is at (0,0); horizontal coordinates increase to the right
      and vertical coordinates increase down the screen.  The top left pixel
      in the window region is at (windowh,windowv) in this coordinate scheme.
      Specific VDU modules may have to do some translation to the actual
      coordinate scheme used by the VDU.
 
   The following diagram illustrates the screen coordinate system used by
   DVItoVDU and shows what the generic VDU parameters refer to.
 
                --> h increases to the right
   h,v=(0,0) *------------------------------------------------
             |                               DVIstatusl      | top text line = 1
       |     |              DIALOGUE REGION  windowstatusl   | (lines increase
       V     |                               messagel        |  downwards)
             |                               commandl        |
       v     * (windowh,windowv) ----------------------------|   ---
   increases |                                               |    |
     down    |                                               |    |
             |                                               |    |
             |                                               |    |
             |                WINDOW REGION                  | windowht
             |         contains windowwd * windowht          |    |
             |            addressable locations              |    |
             |                                               |    |
             |                               bottoml         |    |
             -------------------------------------------------   ---
 
             |------------------ windowwd -------------------|
 
-------------------------------------------------------------------------------
 
   This version converted to C and ported to BSD and System V UNIX by
   some chaps at Kernel Technology up to September 1989.  Contact
   mjh@uk.co.kernel (Mark J. Hewitt) with bug fixes etc.
 
   Involved were:	Mark J. Hewitt
   			Dave Dixon
			Marc Hadley
*/
 
static char *sccsid_vdu[] = "@(#)vduif.h	1.1";
 
/*PROCEDURE InitVDUInterface;   must be called before anything below is used */
 
extern void InitAED512(),
            InitANSI(),
            InitFalco(),
            InitREGIS(),
            InitTEK4010(),
            InitVIS500(),
            InitVIS550(),
            InitVT220(),
            InitVT640();
 
 
   /* INTEGER variables: DVItoVDU treats these as read-only parameters.      */
 
int
   DVIstatusl,     /* DVI status line    (usually 1)                         */
   windowstatusl,  /* window status line (usually 2)                         */
   messagel,       /* message line       (usually 3)                         */
   commandl,       /* command line       (usually 4)                         */
   bottoml,        /* bottom line; also number of text lines in screen       */
   windowh,        /* horizontal coord for window's top left screen pixel    */
   windowv,        /* vertical coord for window's top left screen pixel      */
   windowwd,       /* width of window in screen pixels                       */
   windowht;       /* height of window in screen pixels                      */
 
   /* TeXtoASCII is an array of characters that can be used in a specific
      ShowChar or ShowRectangle routine to map the given TeX character into
      a similar looking ASCII character.
 
      index       (= TeX char)            -->  ASCII char (= TeXtoASCII[index])
 
      0C..12C     Greek letters           -->  all ?
      13C..17C    ligatures               -->  all ?
      20C, 21C    dotless i and j         -->  i and j
      22C, 23C    grave and acute         -->  ` and '
      24C..27C    other high accents      -->  all ~
      30C         cedilla                 -->  ,
      31C..40C    diphthongs and foreigns -->  all ?
      41C..133C   !../,0..9,:..@,A..Z,[   -->  same as index
      134C        opening double quote    -->  "
      135C        ]                       -->  ]
      136C, 137C  hat and dot accents     -->  both ^
      140C..172C  `,a..z                  -->  same as index
      173C, 174C  en dash and em dash     -->  both -
      175C..177C  more high accents       -->  all ~
 
      There are a few important features of the above mapping:
       - The TeX char is assumed to come from a text font, so characters from
         non-text fonts (e.g., math and symbol fonts) will appear incorrect.
       - We use ? as a catch-all for most of the TeX chars that have no
         similar ASCII equivalent.  This allows a specific ShowChar routine
         to efficiently detect such cases (taking care to check that the TeX
         char isn't an actual ?) and simulate a ligature, for example.
       - Characters 74C and 76C are an upside down exclamation and question
         mark in a TeX text font, but we map them to their equivalent
         ASCII positions (< and >) since they are much more likely to occur
         as the corresponding characters from a math or typewriter font.
       - DVItoVDU will only pass characters in the range 0C..177C.
   */
 
char TeXtoASCII[] =
{'?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', /* greek */
'?', '?', '?', '?', '?',                               /* ligatures */
'i',                                                   /* dotless i */
'j',                                                   /* dotless j */
'`',                                                   /* grave accent */
'\'',                                                  /* acute accent */
'~', '~', '~', '~',                                    /* high accents */
',',                                                   /* cedilla */
'?', '?', '?', '?', '?', '?', '?', '?',                /* dipthongs, foreign */
'!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+',/* normal characters */
',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6',
'7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A',
'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L',
'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',
'X', 'Y', 'Z', '[',
'"',                                                   /* open double quote */
']',                                                   /* normal characters */
'^', '^',                                              /* high accents */
'`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', /* normal characters */
'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u',
'v', 'w', 'x', 'y', 'z',
'-',                                                   /* en dash */
'-',                                                   /* em dash */
'~', '~', '~',                                         /* high accents */
'\0'};
 
   /* PROCEDURE variables:
      DVItoVDU does not assume anything about the new cursor position
      after calling any of these routines (except MoveToTextLine of course).
      Some specific VDU routines may be able to take advantage of the following
      features:
      - MoveToTextLine, ClearTextLine, ClearScreen and ResetVDU are only called
        after a StartText call (i.e., when DVItoVDU is in "text mode").
      - LoadFont, ShowChar and ShowRectangle are only called after a
        StartGraphics call (i.e., when DVItoVDU is in "graphics mode").
      - The sequence of ShowChar calls is defined by DVIReader: for each font,
        characters will be shown in an essentially left-right, top-down manner.
        Since the reference points of most characters in a line will have
        the same vertical coordinate, some ShowChar implementations can reduce
        the number of output bytes needed to update the screen position from one
        character to the next.  (See the ANSIVDU implementation for example.)
   */
 
/*   StartText : PROC;*/
   /* DVItoVDU calls this routine before displaying text in the dialogue region.
      Some VDUs may need to get out of graphics mode and enter text mode.
   */
 
/*   MoveToTextLine : PROCEDURE (CARDINAL);    linenumber */
   /* Move cursor to start of given text line. */
 
/*   ClearTextLine : PROCEDURE (CARDINAL);    linenumber */
   /* Erase given text line. */
 
/*   ClearScreen : PROC;*/
   /* Erase entire screen. */
 
/*   StartGraphics : PROC;*/
   /* DVItoVDU calls this routine before drawing in the window region.
      Some VDUs may need to get out of text mode and enter graphics mode.
   */
 
/*   LoadFont : PROCEDURE (ARRAY OF CHAR, CARDINAL, REAL,      REAL,   REAL);*/
                        /* fontspec,    fontsize, mag/1000,  hscale, vscale */
   /* DVItoVDU calls this routine just before displaying all the characters
      for the given font.  The information passed in can be used by later
      ShowChar calls.
      It is anticipated that a bit-mapped graphics terminal may be able to
      use this routine to download the given PXL file, scale the characters to
      the right size, and produce a Terse display (via ShowChar calls) much
      faster and almost as accurate as a Full display.
      At the moment, some VDUs only use the given fontsize (the TeX font's
      scaledsize converted into unscaled paper pixels) along with the mag,
      hscale and vscale values to select an appropriate hardware "font" for
      use in later ShowChar calls.
   */
 
/*   ShowChar : PROCEDURE (CARDINAL, CARDINAL, CHAR);    h, v, char */
   /* Show the given character from the last font loaded.
      (h,v) is the screen pixel representing the char's TeX reference point.
      (Note that v coordinates are normally lined up along the baseline.)
      DVItoVDU only calls this routine during a Terse display and guarantees
      that (h,v) is somewhere in the window region.  It is up to the specific
      VDU routine to decide how to handle characters too close to the screen
      edge.  (The right edge is usually the most crucial one because (h,v)
      is normally at the bottom left corner of the character, and the top of
      the screen is normally well above the top of the window region.
      Note that it is better to show something rather than nothing at all in
      cases where part or all of the character is invisible.)
      Most of the VDUs currently implemented assume the character is from a
      TeX text font and map it into a suitable ASCII character using the
      TeXtoASCII conversion array.
   */
 
/*   ShowRectangle : PROCEDURE (CARDINAL, CARDINAL, CARDINAL, CARDINAL, CHAR);*/
                             /* h,      v,        width,    height,   char */
   /* Show a rectangular region of black pixels.
      (h,v) is the TOP LEFT screen pixel in the rectangle.  The width and height
      of the rectangle are also given in screen pixels (both > 0).
      DVItoVDU guarantees that (h,v) is somewhere in the window region and that
      the entire rectangle is visible.
      Non-graphic VDUs may wish to use the given char as a "black pixel".
      DVItoVDU uses this routine to display:
       - all visible paper edges (char = '.')
       - all visible rules (char = '*')
       - the visible edges of a character box in a Box display (char = '*')
       - the visible horizontal lines making up a character in a Full display
         (char is the appropriate TeX character).
      Most rectangles generated by DVItoVDU will be short horizontal lines
      with a height of 1 pixel.
   */
 
/*   ResetVDU : PROC;*/
   /* Some VDUs may need to be reset to a known state.
      DVItoVDU calls this routine just before halting.
   */
