/* Original Author:         Andrew Trevorrow
   Implementation: Modula-2 under VAX/UNIX 4.2 BSD
   Date Started:   June, 1986
 
   Description:
   Implements the InitVT640()procedure that initializes the generic VDU
   routines and parameters used in DVItoVDU.
   The VT640 VDU has a Transparent mode in which it behaves like a VT100, but
   it can also emulate a Tektronix 4010 terminal in which the screen is
   1024 pixels wide by 780 pixels high.
   (The actual resolution of the VT640 screen is 640 by 480 pixels;
   the appropriate scaling is done automatically.)
 
   The bottom left pixel is the point (x=0,y=0). Note that x coordinates
   increase to the right and y coordinates increase up the screen.
   DVItoVDU uses a coordinate scheme in which horizontal (=h) coordinates
   also increase to the right but vertical (=v) coordinates increase DOWN the
   screen, i.e. the top left pixel on the screen is the point (h=0,v=0).
   This means that the Tektronix 4010 routines will have to do a
   simple translation of the vertical coordinates passed by DVItoVDU.
 
   This version converted to C and ported to BSD and System V UNIX by
   some chaps at Kernel Technology up to September 1989.  Contact
   mjh@uk.co.kernel (Mark J. Hewitt) with bug fixes etc.
 
   Involved were:	Mark J. Hewitt
   			Dave Dixon
			Marc Hadley
*/
 
#include "def.h"
 
static char sccsid[] = "@(#)vt640vdu.c	1.1";
 
extern Void TEK4010ClearScreen(),
            TEK4010ShowRectangle(),
            TEK4010StartGraphics(),
            TEK4010StartText(),
            TEK4010ShowChar(),
            TEK4010LoadFont();
 
Void VT640MoveToTextLine ();
Void VT640ClearTextLine ();
Void VT640ClearScreen ();
Void VT640ResetVDU ();
 
/******************************************************************************/
 
void InitVT640 ()
{
 
/* The dialog region will be the top 4 text lines in VT100 mode:
      Line 1 = DVI status line,
      Line 2 = window status line,
      Line 3 = message line,
      Line 4 = command line.
   The window region will be text lines 5 to 24 in VT100 mode.
*/
 
 
  DVIstatusl = 1;		/* DVItoVDU assumes top text line = 1 */
  windowstatusl = 2;
  messagel = 3;
  commandl = 4;
  bottoml = 24;			/* also number of text lines on screen */
/* The above values assume the VT640 is in VT100 mode;
   the following values assume it is emulating a Tektronix 4010.
   Note that windowv must be given a value using DVItoVDU's coordinate scheme
   where top left pixel is (0,0).
*/
  windowv = 130;		/* approx. height in TEK4010 pixels of 4 text lines
				   i.e. 4 * 780/24 */
  windowh = 0;
  windowht = 780 - windowv;
  windowwd = 1024;
 
  MoveToTextLine = VT640MoveToTextLine;
  ClearTextLine = VT640ClearTextLine;
  ClearScreen = VT640ClearScreen;
  StartText = TEK4010StartText;
  StartGraphics = TEK4010StartGraphics;
  LoadFont = TEK4010LoadFont;
  ShowChar = TEK4010ShowChar;
  ShowRectangle = TEK4010ShowRectangle;
  ResetVDU = VT640ResetVDU;
}
 
/******************************************************************************/
 
Void VT640MoveToTextLine (line)
 
unsigned int  line;
{
    Write (GS);				/* cannot send CAN if VT640 is */
					/* already in VT100 mode */
    Write (CAN);			/* switch to VT100 mode */
    MoveAbs (line, 1);
}
 
/******************************************************************************/
 
Void VT640ClearTextLine (line)
unsigned int  line;
{
  Write (GS);
  Write (CAN);
  MoveAbs (line, 1);
  Write (ESC);
  WriteString ("[K");		/* erase to end of line */
}
 
/******************************************************************************/
 
Void VT640ClearScreen ()
{
  Write (GS);
  Write (CAN);
  Write (ESC);
  WriteString ("[2J");		/* erase all alphanumerics - need for VIS550! */
  TEK4010ClearScreen ();
}
 
/******************************************************************************/
 
Void VT640ResetVDU ()
{
  Write (GS);			/* cannot send CAN if VT640 is already in VT100 mode
				   */
  Write (CAN);			/* switch to VT100 mode */
}
 
/******************************************************************************/
 
 
 
 
 
 
 
