/* Original Author:         Andrew Trevorrow
   Implementation: Modula-2 under VAX/UNIX 4.2 BSD
   Date Started:   June, 1986
 
   Description:
   InitVDUInterface()initializes the generic VDU routines and parameters
   according to the vdu value set by InitSysInterface()(in main module).
   Note that new VDUs can be added without having to recompile
   the main module (search for "XXX" below).
 
   This version converted to C and ported to BSD and System V UNIX by
   some chaps at Kernel Technology up to September 1989.  Contact
   mjh@uk.co.kernel (Mark J. Hewitt) with bug fixes etc.
 
   Involved were:	Mark J. Hewitt
   			Dave Dixon
			Marc Hadley
*/
 
#include "def.h"
#include "vduif.h"
#include <ctype.h>
 
static char *sccsid[] = "@(#)vduif.c	1.1";
 
extern stringvalue vdu;
 
/* void exitprog (); */
 
 
/******************************************************************************/
 
char  CAP (c)
char  c;
{
  if ((c >= 'a') && (c <= 'z'))
    return (char) toupper ((int) c);
  else
    return (c);
}
 
/******************************************************************************/
short   StringsEqual (s1, s2)
char *s1, *s2;
{
 
/* Returns TRUE if uppercase s1==uppercase s2.
   Comparison is based on the underlying order of character codes.
   E.g., for the ASCII code, ' ' < '\0'..'9' < 'A'..'Z'.
*/
 
#define NULLCHAR  '\0'
 
  unsigned int  i;
 
/* SYSDEP: we assume end of string is first NULL, or string is full */
  i = 0;
  for (;;)
  {
    if (CAP (s1[i]) != CAP (s2[i]))
    {
      return (FALSE);
    }
    else
      if (s1[i] == NULLCHAR)
      {				/* = s2[i] */
	return (TRUE);		/* both NULL terminated */
      }
    i++;
    if (i > (strlen (s1) - 1))
    {				/* s1 is full */
      if (i > (strlen (s2) - 1))
	return (TRUE);		/* so is s2 */
      return (s2[i] == NULLCHAR);/* s2 NULL terminated? */
    }
    else
      if (i > (strlen (s2) - 1))
      {				/* s2 is full */
	return (s1[i] == NULLCHAR);/* s1 NULL terminated? */
      }
  }
}
 
/******************************************************************************/
 
void InitVDUInterface ()
{
 
/* We assume DVItoVDU has already called InitSysInterface()to
   initialize the vdu value.
*/
 
  if (StringsEqual (vdu, "AED483"))
  {
    screenht = 483;		/* override initial implementation value of 512 */
    InitAED512 ();		/* uses screenht, so must be called after above line
				   */
  }
  else
    if (StringsEqual (vdu, "AED512"))
    {
      InitAED512 ();
    }
    else
      if (StringsEqual (vdu, "ANSI") ||
	  StringsEqual (vdu, "VT100"))
      {
	InitANSI ();
      }
#ifdef DECCE
      else
      if (StringsEqual (vdu, "DECCE"))
      {
	Initdecce ();
      }
#endif /* DECCE */
      else
	if (StringsEqual (vdu, "REGIS") ||
	    StringsEqual (vdu, "VT240") ||
	    StringsEqual (vdu, "GIGI") ||
	    StringsEqual (vdu, "VK100") ||
	    StringsEqual (vdu, "VT125"))
	{
	  InitREGIS ();
	}
	else
	  if (StringsEqual (vdu, "VT100132"))
	  {
	    InitANSI ();	/* it is up to user to set VDU to 132 columns */
	    windowwd = 132;	/* just increase window width */
	  }
	  else
	    if (StringsEqual (vdu, "VIS240") ||
		StringsEqual (vdu, "VIS241"))
	    {
	      InitREGIS ();
	    /* the VIS240/241 has more text lines and a bigger window region: */
	      bottoml = 29;
	      windowwd = 800;
	      windowht = 580 - windowv;
	    }
	    else
	      if (StringsEqual (vdu, "VIS500"))
	      {
		InitVIS500 ();
	      }
	      else
		if (StringsEqual (vdu, "VIS550"))
		{
		  InitVIS550 ();
		}
		else
		  if (StringsEqual (vdu, "VT220"))
		  {
		    InitVT220 ();
		  }
		  else
		    if (StringsEqual (vdu, "VT640"))
		    {
		      InitVT640 ();
		    }
		    else
		      if (StringsEqual (vdu, "5220e") ||
			  StringsEqual (vdu, "falco") ||
			  StringsEqual (vdu, "falco-5220e"))
		      {
			InitFalco ();
		      }
		      else
			if (StringsEqual (vdu, "TEK4010") ||
			    StringsEqual (vdu, "EmuTeK") ||
			    StringsEqual (vdu, "Kermit"))
			{
			  InitTEK4010 ();
			}
/* add a new VDU here (keep order alphabetical)
else
if(StringsEqual(vdu,"XXX"))
{
   InitXXX;
}*/
			else
			{
			  WriteString ("Bad -v value! (=");
			  WriteString (vdu);
			  Write (')');
			  WriteLn ();
			  WriteString ("Specify one of the following:");
			  WriteLn ();
			  WriteString ("   AED483    (AED 512 with 512 by 483 screen)");
			  WriteLn ();
			  WriteString ("   AED512    (AED 512 with 512 by 512 screen)");
			  WriteLn ();
			  WriteString ("   ANSI      (any ANSI compatible VDU; synonym = VT100)");
			  WriteLn ();
			  WriteString ("   REGIS     (any ReGIS compatible VDU; ");
			  WriteString ("synonyms = GIGI, VK100, VT125, VT240)");
			  WriteLn ();
			  WriteString ("   TEK4010   (any Tektronix 40xx emulator; synonyms = EmuTek, Kermit)");
			  WriteLn ();
			  WriteString ("   VIS240    (VISUAL 240; synonym = VIS241)");
			  WriteLn ();
			  WriteString ("   VIS500    (VISUAL 500)");
			  WriteLn ();
			  WriteString ("   VIS550    (VISUAL 550)");
			  WriteLn ();
			  WriteString ("   VT100132  (any VT100 compatible VDU in 132 column mode)");
			  WriteLn ();
			  WriteString ("   VT220     (VT220 using down-loaded chunky graphics)");
			  WriteLn ();
			  WriteString ("   VT640     (VT100 with Retro-Graphics)");
			  WriteLn ();
			  WriteString ("   5220e     (Synonyms = Falco-5220e)");
			  WriteLn ();
			/* add a new VDU here (keep order alphabetical)
			   WriteString('   XXX'); WriteLn(); */
			  RestoreTerminal ();
			  exitprog (1);
			}
}
 
 
 
