/*
 * make vf which simulates vert-ASCII-dvi by NTT-dvi
 * mkvfp2n dm 10 tmin10 /.../tmin10.tfm vchs [-tdm] vchr [VFDIR]
 *	tmin10.vf
 */
#include	<stdio.h>
#include	"defs.h"
#include	"vfcodes.h"
#include	"bifont.h"
#include	"jsub.h"

#define	UNIT	1048576		/* 1 fixpoint real = 2^20 */

/* hard coded data */

int an_ratio = 1102180;		/* (ASC(1008957)/NTT(959887)) UNIT */
/*unsigned int vfcs = 0xe99fd0f6;*/

struct specchar {
    int ct, gl;
} scdata[] = {
    {3, 112608},
    {6, 504478},
    {7, 252239},
    {0, 0},
};

#define	DEPTHRATIO	165565
int rdisp = UNIT-DEPTHRATIO;
int ddisp = UNIT/2;
int vdisp = (UNIT/2)-DEPTHRATIO;

/* end of hard coded data */

#define	LEN	256

#define	VCHS	24
#define	VCHR	29
struct vcharshift {
    int cc;
    int r, d;
} vcharshift[VCHS+1];
struct vcharrot {
    int cc;
} vcharrot[VCHR+1];

char *ntt1, *ntt2;
char *ascfont;
int vfds;
BOOLEAN usevfont;
char *vfont;
int vff;
char *vfdir;
FILE *jfm, *vf;

/* set by readjfm */
extern char header[];
extern char width[];
extern int nt, lh, bc, ec, nw, ds;
extern struct jfmfntinfo *jfmfi;

main(ac, av)
int ac;
char *av[];
{
    int vac;
    char name[64];

    ntt1 = av[1];
    ntt2 = av[2];
    vfds = atoi(ntt2)<<20;
    ascfont = av[3];
    if ((jfm = fopen(av[4], "r")) == NULL) {
	fprintf(stderr, "cannot read %s\n", av[4]);
	exit(1);
    }
    if (!readjfm(jfm)) {
	fprintf(stderr, "%s is not jfm\n", av[4]);
	exit(1);
    }

    readvchshift(av[5]);
    if (av[6][0] == '-') {
	usevfont = TRUE;
	vfont = av[6]+1;
	vac = 7;
    } else {
	usevfont = FALSE;
	vac = 6;
    }
    readvchrot(av[vac]);

    vfdir = (ac > vac+1) ? av[vac+1] : "";
    sprintf(name, "%s%s.vf", vfdir, ascfont);
    if ((vf = fopen(name, "w")) == NULL) {
	fprintf(stderr, "cannot write %s\n", name);
	exit(1);
    }
    ascvf();
    fclose(vf);

    exit(0);
}

readvchshift(fn)
char *fn;
{
    FILE *f;
    char buf[LEN], *p;
    int i;

    f = fopen(fn, "r");
    for (i = 0; fgets(buf, LEN, f) != NULL && i < VCHS; i++) {
	(vcharshift+i)->cc = ((buf[0]&0x7f)<<8)|(buf[1]&0x7f);
	(vcharshift+i)->d = -(strtol(buf+3, &p, 10)*UNIT)/1000;
	(vcharshift+i)->r = -(strtol(p, &p, 10)*UNIT)/1000;
    }
    (vcharshift+i)->cc = 0;
}

readvchrot(fn)
char *fn;
{
    FILE *f;
    char buf[LEN], *p;
    int i;

    f = fopen(fn, "r");
    for (i = 0; fgets(buf, LEN, f) != NULL && i < VCHR; i++) {
	(vcharrot+i)->cc = ((buf[0]&0x7f)<<8)|(buf[1]&0x7f);
    }
    (vcharrot+i)->cc = 0;
}

#define	makejis(k,t)	((k+0x20)*256+t+0x20)

ascvf()
{
    int f, c, ku, ten;
    char jsubname[64];
    long len;
    int i;

    putuint(vf, VF_PRE, 1);
    putuint(vf, VF_ID, 1);
    putuint(vf, 0, 1);	/* no comment */
    putbytes(vf, header, 2*4);	/* check sum & design size */

    for (f = 1; f <= NJSUBS; f++) {
	sprintf(jsubname, "%s%s%s", ntt1, jsubfontname(f), ntt2);
	fontdef(f, jsubname);
    }
    if (usevfont) {
	sprintf(jsubname, "%s%s%s", vfont, jsubfontname(1), ntt2);
	fontdef(vff = NJSUBS+1, jsubname);
    }

    vfspace();
    for (ku = 1, ten = 2; ten <= 94; ten++)
	if (compute_fc(ku, ten, &f, &c))
	    vfchar(makejis(ku, ten), f, c);
    for (ku = 2; ku <= 84; ku++)
	for (ten = 1; ten <= 94; ten++)
	    if (compute_fc(ku, ten, &f, &c))
		vfchar(makejis(ku, ten), f, c);

    len = ftell(vf);
    for (i = 0; i < 4 - len%4; i++)
	putuint(vf, VF_POST, 1);
}

fontdef(f, fn)
int f;
char *fn;
{
    putuint(vf, FNT_DEF1, 1);
    putuint(vf, f, 1);
    putuint(vf, 0, 4);
    putuint(vf, an_ratio, 4);
    putuint(vf, vfds, 4);
    putuint(vf, 0, 1);
    putuint(vf, strlen(fn), 1);
    putbytes(vf, fn, strlen(fn));
}

vfspace()
{
    putuint(vf, VF_LONG_CHAR, 1);
    putuint(vf, 0, 4);
    putuint(vf, 0x2121, 4);
    putuint(vf, jfmfi->ch[0].tfmw, 4);
}

vfchar(jis, f, c)
int jis, f, c;
{
    int pl;
    int ct, n;
    int rd, dd;
    int rn, dn;
    byte rb[sizeof(int)], db[sizeof(int)];
    struct specchar *sd;
    struct vcharshift *vs;
    struct vcharrot *vr;

    pl = (c <= SETC_127) ? 1 : 2;
    ct = getctype(jis, jfmfi);
    for (sd = scdata; sd->ct != 0; sd++)
	if (sd->ct == ct)
	    break;
    for (vs = vcharshift; vs->cc != 0; vs++)
	if (vs->cc == jis)
	    break;
    for (vr = vcharrot; vr->cc != 0; vr++)
	if (vr->cc == jis)
	    break;
    if (vr->cc == 0) {
	pl += 2;	/* DIR 3 */
	rd = rdisp - sd->gl + vs->r;
    } else if (usevfont) {
	pl += 2;	/* DIR 3 */
	f = vff;
	rd = - sd->gl;
    } else
	rd = - sd->gl + vs->r;
    if (rd != 0) {
	rn = inttob(rb, rd, TRUE);
	pl += 1+rn;
    }
    if (vr->cc == 0)
	dd = ddisp + vs->d;
    else if (usevfont)
	dd = vdisp;
    else
	dd = vdisp + vs->d;
    if (dd != 0) {
	dn = inttob(db, dd, TRUE);
	pl += 1+dn;
    }
    pl += (f == 1) ? 0 : 1;
    
    putuint(vf, VF_LONG_CHAR, 1);
    putuint(vf, pl, 4);
    putuint(vf, jis, 4);
    putuint(vf, jfmfi->ch[ct].tfmw, 4);
    if (rd != 0) {
	putuint(vf, RIGHT1+rn-1, 1);
	putbytes(vf, rb, rn);
    }
    if (dd != 0) {
	putuint(vf, DOWN1+dn-1, 1);
	putbytes(vf, db, dn);
    }
    if (f != 1)
	putuint(vf, FONT_00+f, 1);
    if (vr->cc == 0 || usevfont) {
	putuint(vf, DIR, 1);
	putuint(vf, 3, 1);
    }
    if (c <= SETC_127)
	putuint(vf, c, 1);
    else {
	putuint(vf, SET1, 1);
	putuint(vf, c, 1);
    }
}
