/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: dvi_public.h,v 1.9 1994/03/29 08:55:50 kakiuchi Exp $
 */

#ifndef _DVI_PUBLIC_
#define _DVI_PUBLIC_

/*
 * type definitions for handling DVI file.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include "types.h"
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif
typedef struct {
  char *fontdesc;
  void (*error_handler)();
  bool (*init_dvi)(), (*check_sheet)(), (*bop)(), (*eop)();
  void (*set_fnt_num)(), (*set_char)(), (*set_rule)(), (*do_special)();
} AppInfo;

typedef struct {
  i32 sheet_page;	/* Page number of each sheet. */
  long sheet_table;	/* pointers to start of each page in file */
} DVIPages;

typedef struct {
  char filename[MAXPATHLEN], directory[MAXPATHLEN];
  FILE *dvifp;	/* File pointer */
  time_t mtime;
  u32 num;	/* numerator specified in preamble          */
  u32 den;	/* denominator specified in preamble        */
  u32 mag;	/* magnification specified in preamble      */
  u32 hpd;
  u32 wpw;
  u16 stack_size;	/* stack size */
  u16 NumberOfPage;
  u16 last_known_sheet;	/* Points to table at next unread sheet */
  DVIPages *pages, *curPage;
  struct font_entry *curFont;	/* defined in fonts/font.h */
} DVI;

extern bool InitDVIFile(
#if NeedFunctionPrototypes
    char*	/* filename */,
    int		/* resolution */,
    u32		/* user_mag */,
    char*	/* font_path */,
    char*	/* tfm_path */,
    AppInfo*	/* appinfo */
#endif
);
extern bool ProcessPage(
#if NeedFunctionPrototypes
    int		/* new_sheet */
#endif
);
extern DVI dvi_info;

#endif /* _DVI_PUBLIC_ */
