/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: common.h,v 1.9 1994/03/29 08:56:10 kakiuchi Exp $
 */

#ifndef _COMMON_
#define _COMMON_

#include "tfm.h"

/*
 * Some type definitions for font libraries
 */

/*
 * public data structures to each font functions
 */
typedef struct k_char_entry {
  CharEntry ch;
  u16 code;
  struct k_char_entry *left, *right;
} KCharEntry;

/*
 * public functions to each font functions
 */
extern FILE *open_file(
#if NeedFunctionPrototypes
    FontEntry*	/* fe */
#endif
);
extern void close_file(
#if NeedFunctionPrototypes
    FontEntry*	/* fe */
#endif
);
extern int search_font_file(
#if NeedFunctionPrototypes
    FontEntry*	/* fe */
#endif
);
extern int search_tfm_file(
#if NeedFunctionPrototypes
    char*	/* fn */,
    char**	/* tfmname */
#endif
);
extern char *AllocMemory(
#if NeedFunctionPrototypes
    size_t	/* size */
#endif
);
extern int get_kchar_entry(
#if NeedFunctionPrototypes
    KCharEntry**/* top */,
    u32		/* c */,
    CharEntry**	/* ret */
#endif
);
extern double GetJfmDotSize(
#if NeedFunctionPrototypes
    FontEntry*	/* fe */,
    JFM*	/* jfm */
#endif
);
extern double GetTfmDotSize(
#if NeedFunctionPrototypes
    FontEntry*	/* fe */,
    TFM*	/* tfm */
#endif
);
#endif /* _COMMON_ */
