/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: fmmtrc.h,v 1.4 1994/03/24 13:19:22 kakiuchi Exp $
 */

#ifndef _FMMTRC_
#define _FMMTRC_

/*
 * Metric Adjustment Tables for MOTOYA Font/JFM
 *
 * Date:    10 Feb, 1991
 * Author:  Y. Kusumi
 * Version: 1.2
 *
 * Date:    7 Dec, 1990 
 * Author:  Y. Kusumi
 * Version  1.1
 *
 * Date:    14 Sep, 1990
 * Author:  Y. Kusumi
 * Version: alpha
 *
 *
 * 
 */

typedef struct{
  u32 code;              /* jis code */
  float Xadj, Yadj;      /* coefficient for adjustment */
} AdjustRatioRecord;


static AdjustRatioRecord minadj[] = {
  { 0x2122,	0.061,	0.0	}, /*-11*/
  { 0x2123,	0.071,	0.0	}, /*-11*/
  { 0x2124,	0.141,	0.0	}, /*-10*/
  { 0x2125,	0.141,	0.0	}, /*-10*/
  { 0x2126,	-0.927,	0.0	}, /*-4*/
  { 0x2127,	-0.927,	0.0	}, /*-4*/
  { 0x2128,	-0.927,	0.0	}, /*-4*/
  { 0x2129,	-0.455,	0.0	}, /*-5*/
  { 0x212a,	-0.927,	0.0	}, /*-4*/
  { 0x212b,	0.0,	0.057	}, /*-2*/
  { 0x212c,	0.0,	0.057	}, /*-2*/
  { 0x212d,	-1.102,	0.056	}, /*-4*/
  { 0x212e,	-0.882,	0.056	}, /*-4*/
  { 0x212f,	-0.508,	0.0	}, /*-5*/
  { 0x2130,	-0.508,	0.0	}, /*-5*/
  { 0x2133,	-0.413,	0.0	}, /*-5*/
  { 0x2135,	-0.521,	0.0	}, /*-5*/
  { 0x2136,	-0.263,	0.0	}, /*-3*/
  { 0x2137,	-0.158,	0.0	}, /*-3*/
  { 0x2139,	-0.143,	0.0	}, /*-3*/
  { 0x213e,	-0.882,	0.0	}, /*-4*/
  { 0x2142,	-0.941,	0.0	}, /*-4*/
  { 0x2143,	-0.824,	0.0	}, /*-4*/
  { 0x2146,	-2.125,	0.056	}, /*-4*/
  { 0x2147,	0.055,	0.056	}, /*-4*/
  { 0x2148,	-1.181,	0.056	}, /*-5*/
  { 0x2149,	0.054,	0.056	}, /*-5*/
  { 0x214a,	-1.083,	0.0	}, /*-6*/
  { 0x214b,	0.125,	0.0	}, /*-1*/
  { 0x214c,	-1.167,	0.0	}, /*-6*/
  { 0x214d,	0.125,	0.0	}, /*-1*/
  { 0x214e,	-1.083,	0.0	}, /*-6*/
  { 0x214f,	0.125,	0.0	}, /*-1*/
  { 0x2150,	-1.083,	0.0	}, /*-6*/
  { 0x2151,	0.125,	0.0	}, /*-1*/
  { 0x2152,	-1.083,	0.0	}, /*-6*/
  { 0x2153,	0.125,	0.0	}, /*-1*/
  { 0x2154,	-1.083,	0.0	}, /*-6*/
  { 0x2155,	0.125,	0.0	}, /*-1*/
  { 0x2156,	-0.997,	0.0	}, /*-6*/
  { 0x2157,	0.083,	0.0	}, /*-1*/
  { 0x2158,	-0.997,	0.0	}, /*-6*/
  { 0x2159,	0.083,	0.0	}, /*-1*/
  { 0x215a,	-1.041,	0.0	}, /*-6*/
  { 0x215b,	0.083,	0.0	}, /*-1*/
  { 0x2168,	-0.15,	0.0	}, /*-3*/
  { 0x2169,	-0.135,	0.0	}, /*-3*/
  { 0x216a,	-0.157,	0.0	}, /*-3*/
  { 0x216b,	0.084,	0.0	}, /*-5*/
  { 0x216c,	0.125,	0.0	}, /*-5*/
  { 0x216d,	0.085,	0.0	}, /*-5*/
  { 0x2170,	-0.167,	0.0	}, /*-3*/
  { 0x2171,	-0.167,	0.0	}, /*-3*/
  { 0x2172,	-0.157,	0.0	}, /*-3*/
  { 0x2178,	-0.437,	0.0	}, /*-5*/
  { 0x2421,	-0.194,	0.0	}, /*-3*/
  { 0x2423,	-0.157,	0.0	}, /*-3*/
  { 0x2425,	-0.194,	0.0	}, /*-3*/
  { 0x2426,	0.0,	0.0	}, /*-7*/
  { 0x2427,	-0.174,	0.0	}, /*-3*/
  { 0x2429,	-0.167,	0.0	}, /*-3*/
  { 0x242f,	0.0,	0.0	}, /*-7*/
  { 0x2430,	-0.062,	0.0	}, /*-7*/
  { 0x2431,	0.0,	0.0	}, /*-7*/
  { 0x2432,	-0.035,	0.0	}, /*-7*/
  { 0x2439,	0.0,	0.0	}, /*-7*/
  { 0x243a,	-0.020,	0.0	}, /*-7*/
  { 0x2443,	-0.184,	0.0	}, /*-3*/
  { 0x2463,	-0.131,	0.0	}, /*-3*/
  { 0x2465,	-0.184,	0.0	}, /*-3*/
  { 0x2467,	-0.194,	0.0	}, /*-3*/
  { 0x246a,	0.0,	0.0	}, /*-7*/
  { 0x246e,	-0.184,	0.0	}, /*-3*/
  { 0x2521,	-0.157,	0.0	}, /*-3*/
  { 0x2522,	0.0,	0.0	}, /*-12*/
  { 0x2523,	-0.184,	0.0	}, /*-3*/
  { 0x2524,	0.0,	0.0	}, /*-12*/
  { 0x2525,	-0.157,	0.0	}, /*-3*/
  { 0x2526,	0.0,	0.0	}, /*-12*/
  { 0x2527,	-0.184,	0.0	}, /*-3*/
  { 0x2529,	-0.157,	0.0	}, /*-3*/
  { 0x252a,	0.0,	0.0	}, /*-12*/
  { 0x252f,	0.0,	0.0	}, /*-13*/
  { 0x2530,	-0.083,	0.0	}, /*-13*/
  { 0x2531,	0.0,	0.0	}, /*-12*/
  { 0x2532,	-0.042,	0.0	}, /*-12*/
  { 0x2535,	0.0,	0.0	}, /*-12*/
  { 0x2536,	-0.008,	0.0	}, /*-12*/
  { 0x253d,	0.0,	0.0	}, /*-12*/
  { 0x253e,	0.0,	0.0	}, /*-12*/
  { 0x253f,	0.0,	0.0	}, /*-13*/
  { 0x2540,	-0.083,	0.0	}, /*-13*/
  { 0x2541,	0.0,	0.0	}, /*-12*/
  { 0x2542,	-0.028,	0.0	}, /*-12*/
  { 0x2543,	-0.184,	0.0	}, /*-3*/
  { 0x2544,	0.0,	0.0	}, /*-12*/
  { 0x2545,	-0.042,	0.0	}, /*-12*/
  { 0x2546,	0.0,	0.0	}, /*-7*/
  { 0x2547,	-0.008,	0.0	}, /*-7*/
  { 0x2548,	-0.083,	0.0	}, /*-12*/
  { 0x2549,	-0.083,	0.0	}, /*-12*/
  { 0x254a,	0.0,	0.0	}, /*-12*/
  { 0x254e,	0.0,	0.0	}, /*-14*/
  { 0x2555,	0.0,	0.0	}, /*-12*/
  { 0x2556,	-0.062,	0.0	}, /*-12*/
  { 0x2557,	-0.062,	0.0	}, /*-12*/
  { 0x255f,	0.0,	0.0	}, /*-12*/
  { 0x2561,	0.0,	0.0	}, /*-12*/
  { 0x2563,	-0.179,	0.0	}, /*-3*/
  { 0x2564,	-0.025,	0.0	}, /*-7*/
  { 0x2565,	-0.162,	0.0	}, /*-4*/
  { 0x2567,	-0.187,	0.0	}, /*-4*/
  { 0x2569,	0.0,	0.0	}, /*-12*/
  { 0x256a,	0.0,	0.0	}, /*-12*/
  { 0x256e,	-0.187,	0.0	}, /*-3*/
  { 0x256f,	0.0,	0.0	}, /*-12*/
  { 0x2572,	0.0,	0.0	}, /*-12*/
  { 0x2575,	-0.187,	0.0	}, /*-3*/
  { 0x2576,	-0.187,	0.0	}, /*-3*/
  { 0,		0,	0	}, /* END MARK */
};


static AdjustRatioRecord gothadj[] = {
  { 0x2122,	0.067,	0.0	}, /*-11*/
  { 0x2123,	0.067,	0.0	}, /*-11*/
  { 0x2124,	0.141,	0.0	}, /*-10*/
  { 0x2125,	0.141,	0.0	}, /*-10*/
  { 0x2126,	-0.987,	0.0	}, /*-4*/
  { 0x2127,	-0.987,	0.0	}, /*-4*/
  { 0x2128,	-0.987,	0.0	}, /*-4*/
  { 0x2129,	-0.505,	0.0	}, /*-5*/
  { 0x212a,	-0.987,	0.0	}, /*-4*/
  { 0x212b,	0.0,	0.057	}, /*-2*/
  { 0x212c,	0.0,	0.057	}, /*-2*/
  { 0x212d,	-1.102,	0.046	}, /*-4*/
  { 0x212e,	-0.882,	0.046	}, /*-4*/
  { 0x212f,	-0.508,	0.0	}, /*-5*/
  { 0x2130,	-0.508,	0.0	}, /*-5*/
  { 0x2133,	-0.413,	0.0	}, /*-5*/
  { 0x2135,	-0.521,	0.0	}, /*-5*/
  { 0x2136,	-0.263,	0.0	}, /*-3*/
  { 0x2137,	-0.158,	0.0	}, /*-3*/
  { 0x2139,	-0.153,	0.0	}, /*-3*/
  { 0x213e,	-0.882,	0.0	}, /*-4*/
  { 0x2142,	-0.941,	0.0	}, /*-4*/
  { 0x2143,	-0.824,	0.0	}, /*-4*/
  { 0x2146,	-2.125,	0.056	}, /*-4*/
  { 0x2147,	0.055,	0.056	}, /*-4*/
  { 0x2148,	-1.181,	0.056	}, /*-5*/
  { 0x2149,	0.057,	0.056	}, /*-5*/
  { 0x214a,	-1.083,	0.0	}, /*-6*/
  { 0x214b,	0.125,	0.0	}, /*-1*/
  { 0x214c,	-1.167,	0.0	}, /*-6*/
  { 0x214d,	0.125,	0.0	}, /*-1*/
  { 0x214e,	-1.083,	0.0	}, /*-6*/
  { 0x214f,	0.125,	0.0	}, /*-1*/
  { 0x2150,	-1.083,	0.0	}, /*-6*/
  { 0x2151,	0.125,	0.0	}, /*-1*/
  { 0x2152,	-1.083,	0.0	}, /*-6*/
  { 0x2153,	0.125,	0.0	}, /*-1*/
  { 0x2154,	-1.083,	0.0	}, /*-6*/
  { 0x2155,	0.125,	0.0	}, /*-1*/
  { 0x2156,	-0.997,	0.0	}, /*-6*/
  { 0x2157,	0.083,	0.0	}, /*-1*/
  { 0x2158,	-0.997,	0.0	}, /*-6*/
  { 0x2159,	0.083,	0.0	}, /*-1*/
  { 0x215a,	-1.041,	0.0	}, /*-6*/
  { 0x215b,	0.083,	0.0	}, /*-1*/
  { 0x2168,	-0.175,	0.0	}, /*-3*/
  { 0x2169,	-0.135,	0.0	}, /*-3*/
  { 0x216a,	-0.157,	0.0	}, /*-3*/
  { 0x216b,	0.08,	0.0	}, /*-5*/
  { 0x216c,	0.12,	0.0	}, /*-5*/
  { 0x216d,	0.08,	0.0	}, /*-5*/
  { 0x2170,	-0.167,	0.0	}, /*-3*/
  { 0x2171,	-0.167,	0.0	}, /*-3*/
  { 0x2172,	-0.157,	0.0	}, /*-3*/
  { 0x2178,	-0.497,	0.0	}, /*-5*/
  { 0x2421,	-0.214,	0.0	}, /*-3*/
  { 0x2423,	-0.192,	0.0	}, /*-3*/
  { 0x2425,	-0.214,	0.0	}, /*-3*/
  { 0x2426,	0.0,	0.0	}, /*-7*/
  { 0x2427,	-0.184,	0.0	}, /*-3*/
  { 0x2429,	-0.192,	0.0	}, /*-3*/
  { 0x242f,	0.0,	0.0	}, /*-7*/
  { 0x2430,	-0.062,	0.0	}, /*-7*/
  { 0x2431,	0.0,	0.0	}, /*-7*/
  { 0x2432,	-0.055,	0.0	}, /*-7*/
  { 0x2439,	0.0,	0.0	}, /*-7*/
  { 0x243a,	-0.020,	0.0	}, /*-7*/
  { 0x2443,	-0.209,	0.0	}, /*-3*/
  { 0x2463,	-0.163,	0.0	}, /*-3*/
  { 0x2465,	-0.214,	0.0	}, /*-3*/
  { 0x2467,	-0.219,	0.0	}, /*-3*/
  { 0x246a,	0.0,	0.0	}, /*-7*/
  { 0x246e,	-0.184,	0.0	}, /*-3*/
  { 0x2521,	-0.167,	0.0	}, /*-3*/
  { 0x2522,	0.0,	0.0	}, /*-12*/
  { 0x2523,	-0.194,	0.0	}, /*-3*/
  { 0x2524,	0.0,	0.0	}, /*-12*/
  { 0x2525,	-0.167,	0.0	}, /*-3*/
  { 0x2526,	0.0,	0.0	}, /*-12*/
  { 0x2527,	-0.194,	0.0	}, /*-3*/
  { 0x2529,	-0.167,	0.0	}, /*-3*/
  { 0x252a,	0.0,	0.0	}, /*-12*/
  { 0x252f,	0.0,	0.0	}, /*-13*/
  { 0x2530,	-0.023,	0.0	}, /*-13*/
  { 0x2531,	0.0,	0.0	}, /*-12*/
  { 0x2532,	-0.042,	0.0	}, /*-12*/
  { 0x2535,	0.0,	0.0	}, /*-12*/
  { 0x2536,	-0.008,	0.0	}, /*-12*/
  { 0x253d,	0.0,	0.0	}, /*-12*/
  { 0x253e,	0.0,	0.0	}, /*-12*/
  { 0x253f,	0.0,	0.0	}, /*-13*/
  { 0x2540,	-0.053,	0.0	}, /*-13*/
  { 0x2541,	0.0,	0.0	}, /*-12*/
  { 0x2542,	-0.028,	0.0	}, /*-12*/
  { 0x2543,	-0.184,	0.0	}, /*-3*/
  { 0x2544,	0.0,	0.0	}, /*-12*/
  { 0x2545,	-0.042,	0.0	}, /*-12*/
  { 0x2546,	0.0,	0.0	}, /*-7*/
  { 0x2547,	-0.008,	0.0	}, /*-7*/
  { 0x2548,	-0.083,	0.0	}, /*-12*/
  { 0x2549,	-0.083,	0.0	}, /*-12*/
  { 0x254a,	0.0,	0.0	}, /*-12*/
  { 0x254e,	0.0,	0.0	}, /*-14*/
  { 0x2555,	0.0,	0.0	}, /*-14*/
  { 0x2556,	-0.062,	0.0	}, /*-12*/
  { 0x2557,	-0.062,	0.0	}, /*-12*/
  { 0x255f,	0.0,	0.0	}, /*-12*/
  { 0x2561,	0.0,	0.0	}, /*-12*/
  { 0x2563,	-0.207,	0.0	}, /*-3*/
  { 0x2564,	-0.013,	0.0	}, /*-7*/
  { 0x2565,	-0.177,	0.0	}, /*-3*/
  { 0x2567,	-0.187,	0.0	}, /*-3*/
  { 0x2569,	0.0,	0.0	}, /*-12*/
  { 0x256a,	0.0,	0.0	}, /*-12*/
  { 0x256e,	-0.217,	0.0	}, /*-3*/
  { 0x256f,	0.0,	0.0	}, /*-12*/
  { 0x2572,	0.0,	0.0	}, /*-12*/
  { 0x2575,	-0.177,	0.0	}, /*-3*/
  { 0x2576,	-0.167,	0.0	}, /*-3*/
  { 0, 		0, 	0	}, /* END MARK */
};

#endif /* _FMMTRC_ */
