/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: font.h,v 1.10 1994/03/29 08:56:10 kakiuchi Exp $
 */

#ifndef _FONT_
#define _FONT_

/*
 * This is a common header file for font manipulation program.
*/
#include <stdio.h>
#include <sys/param.h>		/* For MAXPATHLEN */
#include "types.h"

/*
 * Constants.
 * =========
 */

/*
 * Max number of open font files.
 * MAXOPEN must be less than NOPEN defined sys/param.h.  But it is not sure
 * that NOFILE is REALLY the 'maximum number of open files per process'.
 * This is because the maximum number of open files is dependent on the
 * configuration of OS.
 * Furthermore, we must not exhaust all file descriptors, because applications
 * would open files for another purpose, for example dvi file descriptor, and
 * we will open tfm files for extracting metrics information.
 * But normally, maximum number of open files is larger than 20.
 */
#define MAXOPEN (NOFILE-10)

/* Bitmap construction */
#define ONEBYTES
#undef TWOBYTES
#undef FOURBYTES

#ifdef ONEBYTES
#define UTYPE unsigned char
#define USHIFT 3
#endif
#ifdef TWOBYTES
#define UTYPE unsigned short
#define USHIFT 4
#endif
#ifdef FOURBYTES
#define UTYPE unsigned int
#define USHIFT 5
#endif

#define BITMAPUNIT (0x1 << USHIFT)
#define UBYTES (BITMAPUNIT / 8)
#define UMASK (BITMAPUNIT - 1)
#define UWIDTH(w) (((w) + UMASK) >> USHIFT)
#define BYTEOFFSET(x) ((x) >> USHIFT)

/*
 * Macro functions
 */
/* pix_round(x,conv): return rounded number of pixels */
/*           x: in DVI units                          */
/*           conv: conversion factor                  */
#ifndef fix
#define fix(x) (int)(x + 0.5)
#endif
#define pix_round(x,conv) ((i32) fix((double) (x) / (double) conv))
#define HConv(x) pix_round(x,hconv)
#define VConv(x) pix_round(x,vconv)

#define get_unsigned1(fp)	((u8) getc(fp))
#define get_unsigned2(fp)	((u16) get_unsigned(fp,2))
#define get_unsigned3(fp)	((u32) get_unsigned(fp,3))
#define get_unsigned4(fp)	((u32) get_unsigned(fp,4))
#define get_signed1(fp)		((i8)  getc(fp))
#define get_signed2(fp)		((i16) get_signed(fp,2))
#define get_signed3(fp)		((i32) get_signed(fp,3))
#define get_signed4(fp)		((i32) get_signed(fp,4))

extern double hconv, vconv;

/*
 * Font information for common area of different font file formats.
 */
typedef struct {
  char *name, *extension;
  double multiplier;
  int (*init_font)();
  int (*open_font)();
  struct char_entry *(*get_glyph)();
  int (*free_font)();
} FontOpStruct;

typedef struct font_ops {
  FontOpStruct op;
  struct font_ops *next;
} FontOps;

typedef struct {
  u32 k;			/* font number */
  u32 c;			/* check_sum of font file */
  u32 s;			/* space size */
  u32 d;			/* designsize */
  u8 a;				/* font area length */
  u8 l;				/* font name length */
  char *n;			/* FNT_DEF command parameters  */
  double font_mag;		/* computed from s and d parameters */
  char *name;			/* full name of font file */
  FILE *font_file_fd;		/* file identifier (0 if none) */
  FontOpStruct *font_ops;	/* font file operations */
  struct font_entry *next;
  u32 access_count;		/* count of file access */
  long app_attribute;		/* field for an application specific use */
} CommonEntry;

typedef struct char_entry {
  struct where_is {
    int isloaded;	/* whether glyph is already loaded on memory */
    union {
      long fileOffset;	/* offset to position in glyph file */
      char *bitmap;	/* pointer to the bitmap */
    } address;
  } where;
  u16 width;		/* width in pixels */
  u16 height;		/* height in pixels */
  i16 xOffset;		/* x-offset in pixels */
  i16 yOffset;		/* y-offset in pixels */
  u32 tfmw;		/* character width in sp */
  long glyph_attribute;	/* field for an application specific use */
} CharEntry;

#endif /* _FONT_ */
