/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: font_public.h,v 1.5 1994/03/29 08:56:10 kakiuchi Exp $
 */

#ifndef _FONT_PUBLIC_
#define _FONT_PUBLIC_

#include "font.h"
#include "tfm.h"

typedef struct font_entry {
  CommonEntry common;
  char *specific;
} FontEntry;

/*
 * public functions to applications
 */
extern void InitFont(
#if NeedFunctionPrototypes
    u32		/* num */,
    u32		/* den */,
    u32		/* mag */,
    int		/* resolution */,
    char*	/* fpath */,
    char*	/* tpath */,
    char*	/* fontdesc */
#endif
);
extern void OpenFont(
#if NeedFunctionPrototypes
    FontEntry*	/* fe */,
    u32		/* c */,
    u32		/* s */,
    u32		/* d */,
    u8		/* a */,
    u8		/* l */,
    char*	/* n */
#endif
);
extern void CloseFonts(
#if NeedFunctionPrototypes
#endif
);
extern FontEntry *GetFont(
#if NeedFunctionPrototypes
    u32		/* k */,
    int		/* flag */
#endif
);
extern CharEntry *GetGlyph(
#if NeedFunctionPrototypes
    FontEntry*	/* fe */,
    u32		/* c */
#endif
);
extern void FontsForAll(
#if NeedFunctionPrototypes
    void (*) (
#if NeedNestedPrototypes
	FontEntry*	/* f */
#endif
	)		/* func */
#endif
);
extern char *GetJfmHandle(
#if NeedFunctionPrototypes
    FontEntry*		/* fe */
#endif
);
extern char *GetTfmHandle(
#if NeedFunctionPrototypes
    FontEntry*		/* fe */
#endif
);
extern double GetJfmDotSize(
#if NeedFunctionPrototypes
    FontEntry*		/* fe */,
    JFM*		/* jfm */
#endif
);
extern double GetTfmDotSize(
#if NeedFunctionPrototypes
    FontEntry*		/* fe */,
    TFM*		/* tfm */
#endif
);

/*
 * public utility functions
 */
extern void FillRectangle(
#if NeedFunctionPrototypes
    u8*		/* dp */,
    int		/* dwidth */,
    int		/* dheight */,
    int		/* bytes_per_line */,
    int		/* x */,
    int		/* y */,
    int		/* width */,
    int		/* height */
#endif
);
extern void DrawRectangle(
#if NeedFunctionPrototypes
    u8*		/* dp */,
    int		/* dwidth */,
    int		/* dheight */,
    int		/* bytes_per_line */,
    int		/* x */,
    int		/* y */,
    int		/* width */,
    int		/* height */,
    int		/* border */
#endif
);
extern i32 get_signed(
#if NeedFunctionPrototypes
    FILE*	/* fp */,
    int		/* n */
#endif
);
extern u32 get_unsigned(
#if NeedFunctionPrototypes
    FILE*	/* fp */,
    int		/* n */
#endif
);
extern void prerror(
#if NeedVarargsPrototypes
    char*	/* fmt */,
    ...
#endif
);
extern FILE *fopenp(
#if NeedFunctionPrototypes
    char*	/* dir */,
    char*	/* suff */,
    char*	/* name */,
    char*	/* fullname */,
    char*	/* mode */,
    char*	/* path */
#endif
);

/*
 * Macro functions
 */
#define GetFontAttribute(fe)		(fe->common.app_attribute)
#define PutFontAttribute(fe,att)	(GetFontAttribute(fe)=(long)(att))
#define GetGlyphAttribute(fe,c)		(GetGlyph(fe,c)->glyph_attribute)
#define PutGlyphAttribute(fe,c,att)	(GetGlyphAttribute(fe,c)=(long)(att))
#define GetGlyphAttribute2(ce)		(ce->glyph_attribute)
#define PutGlyphAttribute2(ce,att)	(GetGlyphAttribute2(ce)=(long)(att))

#endif /* _FONT_PUBLIC_ */
