/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: gf.c,v 1.11 1994/03/25 09:47:20 kakiuchi Exp $
 */

static char rcsid[] = "$Id: gf.c,v 1.11 1994/03/25 09:47:20 kakiuchi Exp $";

/*
 * gf font file functions.
 * =======================
 */

#include "gf.h"

static int gf_init(), gf_open(), gf_free();
static CharEntry *gf_get_glyph();

static void gf_beginc(), gf_paint(), gf_skip();

static FILE	*gffp;
static i32	min_m,max_m,min_n,max_n;
static int	rowbytes, gf_m0, gf_m, gf_n, paint_switch;
static u8	*row_ptr;
static u8	*raster;

#define row_start(n) (&(raster[n*rowbytes]))
#define m_byte(m) ((m)>>3)
#define m_bit(m) (7-(m)&07)

FontOps gfops = {
  {"gf", "gf", 1.0, gf_init, gf_open, gf_get_glyph, gf_free},
  NULL
};

static int
gf_init()
{
  return(True);
}

static int
gf_open(fe)
register FontEntry *fe;
{
  register u8 t;

  if (search_font_file(fe)) {
    if (!(gffp = open_file(fe)))
      return(False);
    fseek(gffp, 1L, 0);
    if ((t = get_unsigned1(gffp)) != gf_version) goto bad_version;
    return(True);
  }
  return(False);
 bad_version:
  close_file(fe);
  prerror("Bad GF file version %d\n", (int) t);
  return(False);
}

/* All gf file input goes through the following routines */

#define skip1byte()   getc(gffp)
#define skip_bytes(n) fseek(gffp,(long)(n),1)

static int
gettochar(ptr)
register CharEntry *ptr;
{
  register u8 cmd;
  register u32 c;		/* the character code to be returned */
  register u32 x;		/* temporary */

  for(;;) switch(cmd = get_unsigned1(gffp)) {
  case yyy: skip1byte();	/* intended to fall through 3 times */
  case paint3: case skip3: skip1byte();
  case paint2: case skip2: skip1byte();
  case paint1: case skip1: skip1byte(); continue;

  case boc:			/* set bitmap width,height,offset */
    c = get_unsigned4(gffp);
    get_unsigned4(gffp);	/* backpointer */
    min_m = get_signed4(gffp);
    max_m = get_signed4(gffp);
    min_n = get_signed4(gffp);
    max_n = get_signed4(gffp);
    ptr->width = (u16) (max_m - min_m + 1);
    ptr->height = (u16) (max_n - min_n + 1);
    ptr->xOffset = (i16) (- min_m);
    ptr->yOffset = (i16) (max_n);
    return(c & 0377);

  case boc1:			/* set bitmap width,height,offset */
    c = get_unsigned1(gffp);
    x = get_unsigned1(gffp);	/* del_m */
    max_m = get_unsigned1(gffp);
    min_m = max_m - x;
    x = get_unsigned1(gffp);		/* del_n */
    max_n = get_unsigned1(gffp);
    min_n = max_n - x;
    ptr->width = (u16) (max_m - min_m + 1);
    ptr->height = (u16) (max_n - min_n + 1);
    ptr->xOffset = (i16) (- min_m);
    ptr->yOffset = (i16) max_n;
    return(c);

  case pre:
    if (get_unsigned1(gffp) != gf_version) {
      prerror("gf : file version error\n");
      exit(1);
    }
    skip_bytes(get_unsigned1(gffp));
    continue;

  case xxx1: case xxx2: case xxx3: case xxx4:
    skip_bytes(get_unsigned(gffp, cmd - xxx1 + 1)); continue;

  case post: return(-1);

  case char_loc: case char_loc0: case postpost: case undefined_cases:
    prerror("gf : file command error\n");
    exit(1);

  default: /* do nothing */;
  }
}

/* readbits reads a raster description from the gf file and uses the external
   routines to actually process the raster information.
*/

static void
readbits()
{
  register u8 b;

  gf_beginc();
  for (;;) {
    b = get_unsigned1(gffp);
    if (b <= last_paint) gf_paint((int) (b - paint_0));
    if (b < new_row_0) {
      switch(b) {
      case paint1: case paint2: case paint3:
	gf_paint(get_unsigned(gffp, b - paint1 + 1)); continue;
      case boc: case boc1: prerror("gf : bad gf format [boc,boc1]\n"); exit(1);
      case eoc: return;
      case skip0: gf_skip(0); continue;
      case skip1: case skip2: case skip3:
      	gf_skip(get_unsigned(gffp, b - skip0)); continue;
      }
    } else if (b <= last_new_row) {
      gf_skip(0);
      gf_paint((int) (b - new_row_0));
    } else {
      switch(b) {
      case xxx1: case xxx2: case xxx3: case xxx4:
      	skip_bytes(get_unsigned(gffp, b - xxx1 + 1)); continue;
      case yyy: get_unsigned4(gffp); continue;
      case no_op: continue;
      default: prerror("gf : bad command\n"); exit(1);
      }
    }
  }
}

static void
gf_beginc()
{
  register int num_bytes;

  rowbytes = UWIDTH(max_m - min_m + 1) * UBYTES;
  num_bytes=(max_n - min_n + 1) * rowbytes;	/* bitmap used size */
  /*	gf_m = gf_m0 = min_m;*/
  gf_m = gf_m0 = 0;
  /*	gf_n = min_n;*/
  gf_n = 0;
  row_ptr = row_start(gf_n);	/* set bitmap area top address */
  bzero((char *) raster, num_bytes);	/* bitmap area clear */
  paint_switch = 0;
}

static void
gf_paint(d)
register int d;
{
  if (d > 0) {
    if (paint_switch) {
      while (d-- > 0) {
	row_ptr[m_byte(gf_m)] |= 1 << m_bit(gf_m);
	gf_m++;
      }
    } else {
      gf_m += d;
    }
  }
  paint_switch ^= 1;
}

static void
gf_skip(d)
register int d;
{
  gf_n += d+1;
  gf_m = gf_m0;
  row_ptr = row_start(gf_n);
  paint_switch = 0;
}

static int
read_gf_header(fe)
register FontEntry *fe;
{
  register u32 c;
  register CharEntry *ptr;

  if (!(gffp = open_file(fe))) return(False);

  /* Seek postamble */
  fseek(gffp, -5L, 2);		/* skip four 223's */
  do {
    c = get_unsigned1(gffp);
    fseek(gffp, -2L, 1);
  } while (c == 223);
  if (c != gf_version) {
    prerror("gf : bad gf version\n");	/* check version number */
    return(False);
  }
  fseek(gffp, -3L, 1);		/* back up to the pointer */
  if (fseek(gffp, (long) get_unsigned4(gffp), 0) < 0) {
    prerror("gf : bad postamble point\n");
    return(False);
  }
  if (get_unsigned1(gffp) != post) {
    prerror("gf : bad postamble\n");
    return(False);
  }

  /* Allocate memory for gf entries */
  fe->gf = (GfEntry *) AllocMemory(sizeof(GfEntry));
  ptr = fe->gf->ch;
  for (c = FIRSTGFCHAR; c <= LASTGFCHAR; ++c) {
    ptr[c].where.isloaded = False;
    ptr[c].where.address.fileOffset = 0;
    ptr[c].glyph_attribute = 0;
  }

  /* read postamble of font file */
  get_unsigned4(gffp);	/* ignore back pointer to font-wide xxx commands */
  fe->gf->designsize = get_unsigned4(gffp);
  fe->gf->checksum = get_unsigned4(gffp);
  fe->gf->hppp = get_unsigned4(gffp);
  fe->gf->vppp = get_unsigned4(gffp);
  fe->gf->font_min_m = get_unsigned4(gffp);
  fe->gf->font_max_m = get_unsigned4(gffp);
  fe->gf->font_min_n = get_unsigned4(gffp);
  fe->gf->font_max_n = get_unsigned4(gffp);

  for (;;) {
    switch (get_unsigned1(gffp)) {
    case char_loc0:
      if ((c = get_unsigned1(gffp)) < FIRSTGFCHAR || LASTGFCHAR < c) {
	prerror("gf font bad charcter data\n");
	return(False);
      }
      get_unsigned1(gffp); /* character width in pixels, rounded if necessary */
      ptr[c].tfmw = fix(((float) get_unsigned4(gffp) * (float) fe->common.s)
			/ (float)(1 << 20));	/* advance width */
      /* bitmap offset address of font file */
      ptr[c].where.address.fileOffset = get_unsigned4(gffp);
      ptr[c].where.isloaded = False;
      continue;
    case char_loc:
      if ((c = get_unsigned1(gffp)) < FIRSTGFCHAR || LASTGFCHAR < c) {
	prerror("gf font bad charcter data\n");
	return(False);
      }
      get_unsigned4(gffp); /* character width in pixels, rounded if necessary */
      get_unsigned4(gffp); /* skip dy */
      ptr[c].tfmw = fix(((float) get_unsigned4(gffp) * (float) fe->common.s)
			/ (float)(1 << 20));	/* advance width */
      /* bitmap offset address of font file */
      ptr[c].where.address.fileOffset = get_unsigned4(gffp);
      ptr[c].where.isloaded = False;
      continue;
    case postpost:
      break;
    }
    break;
  }

  return(True);
}

static CharEntry *
gf_get_glyph(fe,c)
register FontEntry *fe;
register u32 c;
{
  register CharEntry *ptr;
  register int	nchars;

  if (c < FIRSTGFCHAR || LASTGFCHAR < c) {
    prerror("gf font bad charcter data\n");
    return(NULL);
  }
  /* If gf header is not loaded, then load header */
  if (!fe->gf && !read_gf_header(fe)) return(NULL);

  ptr = &fe->gf->ch[c];
  /* If bad character is specified ,then return NULL */
  if (ptr->where.address.fileOffset == 0) {
    ptr->where.address.bitmap = NULL;
    return(NULL);
  }

  /* If the bitmap is alread loaded on memory, then simply return. */
  if (ptr->where.isloaded) return(ptr);

  if (!(gffp = open_file(fe))) return(NULL);
  fseek(gffp, ptr->where.address.fileOffset, 0);

  gettochar(ptr);			/* read bitmap infomation */

  nchars = UWIDTH((int) ptr->width) * UBYTES;
  raster = (u8 *) AllocMemory((size_t) (nchars * ptr->height)); /* keep bitmap area */

  readbits();			/* make bitmap */

  ptr->where.address.bitmap = (char *) raster; /* bitmap address set */
  ptr->where.isloaded = True;
  fe->common.access_count++;

  return(ptr);
}

static gf_free(fe)
FontEntry *fe;
{
  return(True);
}
