/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: jfmfont.c,v 1.9 1994/03/24 13:19:22 kakiuchi Exp $
 */

static char rcsid[] = "$Id: jfmfont.c,v 1.9 1994/03/24 13:19:22 kakiuchi Exp $";

/*
 * jfm font file functions.
 * ========================
 */

#include "jfmfont.h"


static int jfm_init(), jfm_blank_open(), jfm_box_open(), jfm_free();
static CharEntry *box_get_glyph(), *blank_get_glyph();

/* magnifications are unused in jfm fonts */
FontOps jfmboxops = {
  {"jfmbox", "jfm", 0.0, jfm_init, jfm_box_open, box_get_glyph, jfm_free},
  NULL};
FontOps jfmblankops = {
  {"jfmblank", "jfm", 0.0, jfm_init, jfm_blank_open, blank_get_glyph, jfm_free},
  NULL};


static int
jfm_init()
{
  return(True);
}

static int
jfm_blank_open(fe)
register FontEntry *fe;
{
  register JfmEntry *jfmfont;
  register TFMTable *tp;

  /* allocate memory for JfmEntry */
  fe->jfmfont = jfmfont = (JfmEntry *) AllocMemory(sizeof(JfmEntry));

  if (!(tp = read_tfm(fe->common.n, &fe->common.name)))
    return(False);

  if (!tp->is_jfm) return(False);

  jfmfont->jfm = tp->data.jfm;
  jfmfont->width = jfmfont->height = (u16) fix(GetJfmDotSize(fe, jfmfont->jfm));
  jfmfont->bitmap = (char *) NULL;
  jfmfont->ch = (KCharEntry *) NULL;
/*
 * Do not output warning messages because this blank font will be often
 * used as dummy kanji font.
 *
 * prerror("Font %s [%d] not found: Using dummy blank font.\n",
 *         fe->common.n, fix(fe->common.font_mag));
 */
  return(True);
}

static int
jfm_box_open(fe)
register FontEntry *fe;
{
  register JfmEntry *jfmfont;
  register TFMTable *tp;
  register u16 dot;
  register int size;

  /* allocate memory for JfmEntry */
  fe->jfmfont = jfmfont = (JfmEntry *) AllocMemory(sizeof(JfmEntry));

  if (!(tp = read_tfm(fe->common.n, &fe->common.name)))
    return(False);

  if (!tp->is_jfm) return(False);

  jfmfont->jfm = tp->data.jfm;
  dot = (u16) fix(GetJfmDotSize(fe, jfmfont->jfm));
  jfmfont->width = dot;
  jfmfont->height = dot;
  size = UWIDTH((int) dot) * UBYTES * dot;
  jfmfont->bitmap = (char *) AllocMemory((size_t) size);
  jfmfont->ch = (KCharEntry *) NULL;
  bzero(jfmfont->bitmap, size);

  DrawRectangle(jfmfont->bitmap, (int) jfmfont->width, (int) jfmfont->height,
		(int) (UWIDTH((int) jfmfont->width) * UBYTES),
		0, 0, (int) jfmfont->width, (int) jfmfont->height, 2);
  prerror("Font %s [%d] not found: Using dummy box font.\n",
	  fe->common.n, fix(fe->common.font_mag));

  return(True);
}

/*
 * Read a Blank font.
 */
static CharEntry *
blank_get_glyph(fe, c)
register FontEntry *fe;
register u32 c;
{
  CharEntry *ch;
  register JFM *jfm;

  if (get_kchar_entry(&fe->jfmfont->ch, c, &ch)) goto found;

  jfm = fe->jfmfont->jfm;
  ch->where.isloaded = True;
  ch->where.address.bitmap = (char *) NULL;
  ch->width = (u16) 0;
  ch->height = (u16) 0;
  ch->xOffset = (i16) 0;
  ch->yOffset = (i16) 0;
  ch->tfmw = (double) fe->common.s *
    jfm->width[jfm->info[find_type(jfm, c)].width_ix] / (0x1 << 20);
  ch->glyph_attribute = 0;
  fe->common.access_count++;

 found:
  return(ch);
}

/*
 * Read a Box font.
 */
static CharEntry *
box_get_glyph(fe, c)
register FontEntry *fe;
register u32 c;
{
  CharEntry *ch;
  register JFM *jfm;
  register u16 type;

  if (get_kchar_entry(&fe->jfmfont->ch, c, &ch)) goto found;

  jfm = fe->jfmfont->jfm;
  type = find_type(jfm, c);
  ch->where.isloaded = True;
  ch->where.address.bitmap = fe->jfmfont->bitmap;
  ch->width = fe->jfmfont->width;
  ch->height = fe->jfmfont->height;
  ch->xOffset = (i16) 0;
  ch->yOffset = (i16)
    VConv((int) ((double) fe->common.s *
		 (double)jfm->height[INFO_HEIGHT(jfm->info[type].height_depth_ix)] /
		 (double) (0x1 << 20)));
  ch->tfmw = (double) fe->common.s *
    jfm->width[jfm->info[type].width_ix] / (0x1 << 20);
  ch->glyph_attribute = 0;
  fe->common.access_count++;

 found:
  return(ch);
}

static int
jfm_free(fe)
register FontEntry *fe;
{
  free_tfm();
  return(True);
}

#if NeedFunctionPrototypes
char *
GetJfmHandle(
    register FontEntry *fe
)
#else
char *
GetJfmHandle(fe)
register FontEntry *fe;
#endif
{
  return((char *) fe->jfmfont->jfm);
}

#if NeedFunctionPrototypes
double
GetJfmDotSize(
    register FontEntry *fe,
    register JFM *jfm
)
#else
double
GetJfmDotSize(fe, jfm)
register FontEntry *fe;
register JFM *jfm;
#endif
{
  register double dot;

  dot = ((fe->common.font_mag / 72.27) *		/* scale [dot/pt] */
	 (double)jfm->design_size / (double)(0x1<<20) *	/* design_size[pt] */
	 jfm->width[jfm->info[0].width_ix] / (0x1 << 20));
  return(dot);
}
