/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: jxl4.c,v 1.6 1994/03/24 13:19:22 kakiuchi Exp $
 */

static char rcsid[] = "$Id: jxl4.c,v 1.6 1994/03/24 13:19:22 kakiuchi Exp $";

/*
 * jxl4 font file functions.
 * =========================
 */

#include "jxl4.h"

static int jxl4_init(), jxl4_open(), jxl4_free();
static CharEntry *jxl4_get_glyph();

static FILE *jxlfp;
static u8	pat[] = {0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01};

FontOps jxl4ops = {
  {"jxl4", "pxl", 5.0, jxl4_init, jxl4_open, jxl4_get_glyph, jxl4_free},
  NULL
};

static int
jxl4_init()
{
  return(True);
}

static int
jxl4_open(fe)
register FontEntry *fe;
{
  register u32 t;

  if (search_font_file(fe)) {
    if (!(jxlfp = open_file(fe)))
      return(False);
    fseek(jxlfp, 0L, 0);
    if ((t = get_unsigned4(jxlfp)) != JXLID) goto bad_version;
    fseek(jxlfp, -4L, 2);
    if ((t = get_unsigned4(jxlfp)) != JXLID) goto bad_version;
    return(True);
  }
  return(False);
 bad_version:
  close_file(fe);
/*
 * Although Jxl4 and pxl font file have different font IDs, they have same
 * file name syntax.  So, this routine confuses when reading non-Japanese
 * fonts.  That is, this routine will be always executed when opening
 * non-Japanese fonts, and file id will be checked and then this test will
 * always be failed.  In such circumstances, we do not like to see warning
 * messages.  So, we commented out the following statement.
 *
 * prerror("Bad JXL file version %d\n", t);
 */
  return(False);
}

static int
read_jxl4_header(fe)
register FontEntry *fe;
{
  register u32 i;
  register u32 t;
  register JxlEntry *jxl4;
  register X_INFO *x_info;
  register Y_INFO *y_info;
  register i32 *tfmtable;

  if (!(jxlfp = open_file(fe)))
    return(False);
  fseek(jxlfp, -64L, 2);
  t = get_unsigned4(jxlfp);
  if ((fe->common.c != 0) && (t != 0) && (fe->common.c != t))
    prerror("Bad JXL checksum %s\n", fe->common.name);

  /* allocate memory for JxlEntry */
  fe->jxl4 = jxl4 = (JxlEntry *) AllocMemory(sizeof(JxlEntry));

  jxl4->magnification = get_unsigned4(jxlfp);
  jxl4->designsize = get_unsigned4(jxlfp);
  jxl4->fixed_pxl_size = get_unsigned4(jxlfp);
  jxl4->fixed_tfm_size = get_unsigned4(jxlfp);
  jxl4->tfm_ptr = get_signed4(jxlfp);
  jxl4->tfm_size = get_unsigned4(jxlfp);
  jxl4->x_info_ptr = get_signed4(jxlfp);
  jxl4->x_info_size = get_unsigned4(jxlfp);
  jxl4->y_info_ptr = get_signed4(jxlfp);
  jxl4->y_info_size = get_unsigned4(jxlfp);
  jxl4->dir_size = get_unsigned4(jxlfp);
  jxl4->dir_ptr0 = get_signed4(jxlfp);
  jxl4->dir_ptr1 = get_signed4(jxlfp);
  jxl4->dir_ptr2 = get_signed4(jxlfp);

  /* allocate memory for X_INFO */
  x_info = jxl4->x_info = (X_INFO *) AllocMemory((size_t) (sizeof(X_INFO) * jxl4->x_info_size));
  fseek(jxlfp, (long) jxl4->x_info_ptr, 0);
  for (i = 0; i < jxl4->x_info_size; ++i) {
    x_info[i].x_offset = get_signed2(jxlfp);
    x_info[i].x_pix = get_unsigned2(jxlfp);
    /* x_info[i].x_offset_p = get_signed2(jxlfp); */
    fseek(jxlfp, 2L, 1);
  }

  /* allocate memory for Y_INFO */
  y_info = jxl4->y_info = (Y_INFO *) AllocMemory((size_t) (sizeof(Y_INFO) * jxl4->y_info_size));
  fseek(jxlfp, (long) jxl4->y_info_ptr, 0);
  for (i = 0; i < jxl4->y_info_size; ++i) {
    y_info[i].y_offset = get_signed2(jxlfp);
    y_info[i].y_pix = get_unsigned2(jxlfp);
    /* y_info[i].y_offset_p = get_signed2(jxlfp); */
    fseek(jxlfp, 2L, 1);
  }

  /* allocate memory for tfmtable */
  tfmtable = jxl4->tfmtable = (i32 *) AllocMemory((size_t) (sizeof(i32) * jxl4->tfm_size));
  jxl4->ch = (KCharEntry *) NULL;
  fseek(jxlfp, (long) jxl4->tfm_ptr, 0);
  for (i = 0; i < jxl4->tfm_size; ++i)
    tfmtable[i] = get_signed4(jxlfp);

  return(True);
}

#define min(x,y)        ((x)<=(y) ? (x) : (y))

/*      unpack raster packet    */

static void
unpack_raster(p, width, height, b_width)
register u8 *p;
register int width, height, b_width;
{
  register n, m, t, h, v;

  n = 0;
  for (v = height; v-- > 0; ) {
    for (h = 0; h < width; h += m) {
      if (n == 0) {
	t = get_unsigned1(jxlfp);
	n = 8;
      }
      m = min(n, 8 - (h & 7));
      m = min(m, width - h);
      p[h >> 3] |= t >> (h & 7);
      t <<= m; n -= m;
    }
    if (width & 7) p[width >> 3] &= ~pat[width & 7];
    p += b_width;
  }
}

/*      get nybble      */

/*
#define get_nyb()  ((nyb_f^=1)? ((nyb_w=get_unsigned1(pkfp))>>4): nyb_w&0x0f)
*/

#define get_next_byte() ((nyb_w = get_unsigned1(jxlfp)) >> 4)
#define get_next() ((raster_size-- > 0) ? get_next_byte() : -1)
#define get_nyb()  ((nyb_f ^= 1) ? get_next() : nyb_w & 0x0f)

/*      unpack run_encoded packet       */

static int repeat_count, dyn_f, nyb_f, nyb_w;
static int expf, last_repeat_count;
static u32 raster_size;

static int
pk_packed_num()
{
  register int i, j;

  if ((i = get_nyb()) < 0)
    return (-1);
  if (i == 0) {
    do {
      j = get_nyb(); i++;
    } while (j == 0);
    while (i > 0) {
      j = (j << 4) + get_nyb(); i--;
    }
    return (j - 15 + ((13 - dyn_f) << 4) + dyn_f);
  } else if (i <= dyn_f) return(i);
  else if (i < 14)
    return(((i - dyn_f - 1) << 4) + get_nyb() + dyn_f + 1);
  else {
    if (repeat_count != 0) {
      prerror("Second repeat count for this row!\n");
      return(-1);
    }
    /* Following codes are different from one defined in file pk.c. */
    if (i == 14) last_repeat_count = repeat_count = pk_packed_num();
    else {
      if (expf) repeat_count = last_repeat_count;
      else repeat_count = 1;
    }
    return (pk_packed_num());
  }
}

static void
unpack_run(p, black, width, height, b_width)
register u8 *p;
register int black, width, height, b_width;
{
  register u8 *q;
  register int run = 0, h, h1, v;

  nyb_f = 0;
  black ^= 1;
  for (v = 0; v < height; v += repeat_count + 1) {
    repeat_count = 0;
    for (h = 0; h < width; h = h1) {
      if (run == 0) {
	/* get run_count/repeat_count */
	if ((run = pk_packed_num()) < 0) return;
	black ^= 1;
      }
      h1 = min(h + run, width);
      if (black) {
	h1 = min(h1, (h + 8) & ~7);
	p[h >> 3] |= pat[h & 7];
	if (h1 & 7) p[h1 >> 3] &= ~pat[h1 & 7];
      }
      run -= h1 - h;
    }
    q = p;  p += b_width;
    for (h = repeat_count * b_width; --h >= 0; ) {
      *p++ = *q++;
    }
  }
}

/*      unpack run_encoded packet       */

static void
unpack_run2(p, width, height, b_width)
register u8 *p;
register int width, height, b_width;
{
  register u8 *q = p;
  register int i, run;
  register int hpos = -1;
  static u8 bitset[] = {128, 64, 32, 16, 8, 4, 2, 1};

  nyb_f = 0;
  while (height > 0) {
    repeat_count = 0;
    /* get run_count/repeat_count */
    /* run:            length same as the previous line.
       repeat_count+1: length different from the previous line. */

    run = pk_packed_num();
    repeat_count++;

    if (run < 0) {
      p = q + b_width;
      for (i = (height - 1) * b_width; --i > 0; ) *p++ = *q++;
      return;
    }

    while (run--) {
      if (hpos == width - 1) {
	if (!(--height)) return;
	p++;

	for (i = b_width; i-- > 0; ) *p++ = *q++;

	p = q;
	hpos = 0;
      } else {
	++hpos;
	if (!(hpos & 7) && hpos) p++;
      }
    }

    while (repeat_count--) {
      *p ^= bitset[hpos & 7];

      if (hpos == width - 1) {
	if (!(--height)) return;
	p++;

	for (i = b_width; i-- > 0; ) *p++ = *q++;

	p = q;
	hpos = 0;
      } else {
	++hpos;
	if (!(hpos & 7) && hpos) p++;
      }
    }
  }
}

static int
jxlexp(fp, raster, b_width, width, height)
register FILE *fp;
register u8 *raster;
register int b_width;
register u16 width, height;
{
  register int flag = get_signed1(fp);

  if ((flag & 0x0f) == 14)
    unpack_raster(raster, width, height, b_width);
  else {
    /* size of raster block */
    raster_size = get_unsigned(fp, ((flag >> 4) & 3) + 1);
    dyn_f = flag & 0x0f;
    repeat_count = 0;
    if ((flag & 0x40) == 0) {
      expf = 0;
      unpack_run(raster, (flag & 0x80) >> 7, width, height, b_width);
    } else {
      expf = 1;
      unpack_run2(raster, width, height, b_width);
    }
  }
}

#define CharMask(c) ((c) & 0377)

static CharEntry *
jxl4_get_glyph(fe, c)
register FontEntry *fe;
register u32 c;
{
  CharEntry *ch;
  register char tfm_index;
  register long rat_index, long_ptr;
  register u16 x_info_index, y_info_index;
  register int uwidth;

  /* If jxl4 header is not loaded, then load header */
  if (!fe->jxl4 && !read_jxl4_header(fe)) return(NULL);

  if (get_kchar_entry(&fe->jxl4->ch, c, &ch)) goto found;

  /* determine file offset of pxl_dir from char code c. */
  c -= 0x2121;
  c = (CharMask(c >> 8) * 94) + CharMask(c);
  if (c < 1410) /* non kanji */
    long_ptr = fe->jxl4->dir_ptr0 + 8 * c;
  else if (c < 4418) /* level-1 kanji */
    long_ptr = fe->jxl4->dir_ptr1 + 8 * (c - 1410);
  else /* level-2 kanji */
    long_ptr = fe->jxl4->dir_ptr2 + 8 * (c - 4418);

  /* seek and get pxl_dir data. */
  if (!(jxlfp = open_file(fe))) return(NULL);
  fseek(jxlfp, long_ptr, 0);
  tfm_index = get_unsigned1(jxlfp);
  rat_index = get_unsigned3(jxlfp);
  x_info_index = get_unsigned2(jxlfp);
  y_info_index = get_unsigned2(jxlfp);

  ch->width = fe->jxl4->x_info[x_info_index].x_pix;
  ch->xOffset = fe->jxl4->x_info[x_info_index].x_offset;
  ch->height = fe->jxl4->y_info[y_info_index].y_pix;
  ch->yOffset = fe->jxl4->y_info[y_info_index].y_offset;
  ch->tfmw = (float) fe->common.s * (float) fe->jxl4->tfmtable[tfm_index] / (float) (0x1 << 20);

  uwidth = UWIDTH((int) ch->width) * UBYTES;
  ch->where.address.bitmap = AllocMemory((size_t)(uwidth * ch->height));
  bzero(ch->where.address.bitmap, uwidth * ch->height);
  fseek(jxlfp, rat_index, 0);
  jxlexp(jxlfp, (u8 *) ch->where.address.bitmap, uwidth, ch->width, ch->height);
  ch->where.isloaded = True;
  ch->glyph_attribute = 0;
  fe->common.access_count++;

 found:
  return(ch);
}

static int
jxl4_free(fe)
FontEntry *fe;
{
  return(True);
}
