/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: jxl4.h,v 1.5 1994/03/24 13:19:22 kakiuchi Exp $
 */

#ifndef _JXL4_
#define _JXL4_

/* This is a header file for pxl font file. */
#include "font.h"

/*
 * pxl file constants
 */
#define  FIRSTPXLCHAR     0
#define  LASTPXLCHAR    127
#define  JXLID       101157

/*
 * Data Structures
 * ===============
 */

/*
 * Font information.
 */

typedef struct x_info {
  i16 x_offset;
  u16 x_pix;
/*  short x_offset_p; */
} X_INFO;

typedef struct y_info {
  i16 y_offset;
  u16 y_pix;
/*  short y_offset_p; */
} Y_INFO;

typedef struct font_entry
{
  /* common fields (defined in font.h) */
  CommonEntry common;
  /* pxl file specific fields */
  struct jxl_entry *jxl4;
} FontEntry;

#include "common.h"

typedef struct jxl_entry {
  u32 magnification;	/* magnification read from JXL file */
  u32 designsize;	/* design size read from JXL file */
  u32 fixed_pxl_size;
  u32 fixed_tfm_size;
  i32 tfm_ptr;
  u32 tfm_size;
  i32 x_info_ptr;
  u32 x_info_size;
  i32 y_info_ptr;
  u32 y_info_size;
  u32 dir_size;
  i32 dir_ptr0, dir_ptr1, dir_ptr2;
  X_INFO *x_info;
  Y_INFO *y_info;
  i32 *tfmtable;
  KCharEntry *ch;     /* character information */
} JxlEntry;

#endif /* _JXL4_ */
