/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: kfont.c,v 1.16 1994/03/25 02:07:08 kakiuchi Exp $
 */

static char rcsid[] = "$Id: kfont.c,v 1.16 1994/03/25 02:07:08 kakiuchi Exp $";

/*
 * kanji font functions.
 * =====================
 */

#include "kfont.h"


static int kfont_init(), kfont_open(), kfont_free();
static CharEntry *kfont_get_glyph();

FontOps kfontops = {
  {"kfont", "tfm", 0.0, kfont_init, kfont_open, kfont_get_glyph, kfont_free},
  NULL
};

static int nopen = 0;
static FontEntry *OpenedFonts[MAX_OPEN_FONT];


static void
remove_from_openedlist(fd)
FILE *fd;
{
  int i;

  for (i=0; i<nopen; i++) {
    if (OpenedFonts[i]->common.font_file_fd == fd) {
#ifdef DEBUG
      prerror("%s is also closed\n", OpenedFonts[i]->common.name);
#endif
      OpenedFonts[i]->common.font_file_fd = (FILE *) -1;
      OpenedFonts[i] = OpenedFonts[--nopen];
      OpenedFonts[nopen] = (FontEntry *) NULL;
      i--;
    }
  }
}


static void
unregister_fm_font(i)
register int i;
{
  FILE *fd;

  if (!OpenedFonts[i]) return;
  fd = OpenedFonts[i]->common.font_file_fd;
#ifdef DEBUG
  prerror("Closing font '%s' (fp:%x, idx:%d, used:%d)\n",
	  OpenedFonts[i]->common.name, OpenedFonts[i]->common.font_file_fd,
	  i, OpenedFonts[i]->common.access_count);
#endif
  if (((int)OpenedFonts[i]->common.font_file_fd) >= 0)
    if (FMCloseFont(OpenedFonts[i]->common.font_file_fd) < 0) {
#ifdef DEBUG
      prerror("Failed to close fm font '%s'.\n", OpenedFonts[i]->common.name);
#endif
    }
  remove_from_openedlist(OpenedFonts[i]->common.font_file_fd);
}

static int
open_fm_font(fe, fontname)
register FontEntry *fe;
register char *fontname;
{
  /* If file is alread opened, then return it. */
  if ((int) fe->common.font_file_fd >= 0) return((int) fe->common.font_file_fd);
  /* If less than MAX_OPEN_FONT, then just open it. */
  /* Else, close the least used file. */
  else if (nopen >= MAX_OPEN_FONT) {
    register int i, least_used;

  close_one:
    for (i = least_used = 0; i < nopen; ++i)
      if (OpenedFonts[least_used]->common.access_count >
	  OpenedFonts[i]->common.access_count)
	least_used = i;

    unregister_fm_font(least_used);
  }

  /* Open the file.  If cannot be opened, then close one more file. */
  /* Y.Kusumi changed on 7 Oct 1992, to make it possible to open same FMfont
     for different TeX font. */
  if ((int) (fe->common.font_file_fd = (FILE *) FMIsFtOpen(fontname)) == FM_CLOSE) {
    if ((int) (fe->common.font_file_fd = (FILE *) FMOpenFont(fontname)) == FM_FONT_FULL)
      goto close_one;
    else if (((int)fe->common.font_file_fd) < 0)
      return(-1);
  }
#ifdef DEBUG
  prerror("Opened (%d, %d) font '%s'\n", fe->common.k, nopen, fontname);
#endif

  OpenedFonts[nopen++] = fe;

  return((int) fe->common.font_file_fd);
}

static int
kfont_init()
{
  register FontName *fn = FontNameTable;
  AdjustRatioRecord *table;
  int key;

  if (FMClose()) return(False);
  if (FMOpen()) return(False);
  while (fn->tex_name) {
    fn->len = strlen(fn->tex_name);
    table = fn->adj_table;
    for (key=0; (table[key].code != 0); key++);
    fn->size_of_adj_table = --key;
#if DEBUG 
    prerror("Init Adj Table for %s, num of rec = %d\n", fn->tex_name, 
	                                              fn->size_of_adj_table);
#endif
    ++fn;
  }
  return(True);
}

static int
kfont_open(fe)
register FontEntry *fe;
{
  register u16 dot;
  register KFontEntry *kfont;
  register FontName *fn = FontNameTable;
  register TFMTable *tp;
  char *tfmname, real_name[MAXPATHLEN];

  static AdjustRatioRecord *top_of_table;
  static int table_size;

/*  FMFontInfo fontinfo; */

  fe->common.font_file_fd = (FILE *) -1;
  while (fn->tex_name) {
    if (!strncmp(fe->common.n, fn->tex_name, fn->len)) {
      register JFM *jfm;

      if (!(tp = read_tfm(fe->common.n, &tfmname)) || !tp->is_jfm)
	goto not_found;
      jfm = tp->data.jfm;
      dot = (u16) fix(GetJfmDotSize(fe, jfm));
      sprintf(real_name, fn->real_name, (int) dot);

      top_of_table = fn->adj_table;	/* added by Y. Kusumi, Sept 1990 */
      table_size = fn->size_of_adj_table;

      if (open_fm_font(fe, real_name) < 0) {
#ifdef DEBUG
	prerror("%s [not found]\n", real_name);
#endif
	goto not_found;
      }
      goto found;
    } else ++fn;
  }

 not_found:
  fe->common.font_file_fd = (FILE *) NULL;
  return(False);

 found:
  fe->common.name = AllocMemory((size_t) (strlen(real_name) + 1));
  strcpy(fe->common.name, real_name);

  /* allocate memory for KFontEntry */
  fe->kfont = kfont = (KFontEntry *) AllocMemory(sizeof(KFontEntry));
  kfont->width = dot;
  kfont->height = dot;
  kfont->jfm = tp->data.jfm;
  kfont->ch = (KCharEntry *) NULL;
  kfont->adj_table = top_of_table;	/* added by Y. Kusumi Sept 1990 */
  kfont->size_of_adj_table = table_size;
/*
  if (FMQueryFont(fe->common.name, &fontinfo) < 0) {
    prerror("%s [not found]\n", fe->common.name);
    return(False);
  }
  kfont->width = charinfo.width;
  kfont->height = charinfo.height;
  kfont->size = charinfo.sizePerChar;
*/

  return(True);
}  

static CharEntry *
kfont_get_glyph(fe, c)
register FontEntry *fe;
register u32 c;
{
  CharEntry *ch;
  register JFM *jfm;
  register u16 type;
  register size_t size;

  register AdjustRatioRecord  *ar ;
  register FontName *fn = FontNameTable;
  register int lower, upper, key, exists;

  int tfmh;

  if (get_kchar_entry(&fe->kfont->ch, c, &ch)) goto found;
  if (open_fm_font(fe, fe->common.name) < 0) return(NULL);

  size = UWIDTH((int) fe->kfont->width) * UBYTES * fe->kfont->height;
  ch->where.address.bitmap = AllocMemory(size);
  if (FMGetBitmap(fe->common.font_file_fd, c, ch->where.address.bitmap, size) < 0) {
    prerror("glyph not found [%d]\n", c);
    ch->where.isloaded = False;
    return(NULL);
  }
  jfm = fe->kfont->jfm;
  type = find_type(jfm, c);

  tfmh =   (double) fe->common.s *
    jfm->height[INFO_HEIGHT(jfm->info[type].height_depth_ix)] / (0x1 << 20);


  ch->width = fe->kfont->width;
  ch->height = fe->kfont->height;
  ch->xOffset = (i16) 0;
  ch->yOffset = (i16) VConv(tfmh);

/*  ch->yOffset = (i16)
    VConv((int)
	  ((double) fe->common.s *
	   (double) jfm->height[INFO_HEIGHT(jfm->info[type].height_depth_ix)] /
	   (double) (0x1 << 20)));*/

  ch->tfmw = (double) fe->common.s *
    jfm->width[jfm->info[type].width_ix] / (0x1 << 20);

  if(type != 0) {
    ar = fe->kfont->adj_table;
    lower = 0;
    upper = fe->kfont->size_of_adj_table;
    exists = False;
    while ( !exists && (lower <= upper) ) {
	    key = ( lower + upper ) / 2;
	    if ( c == ar[key].code ) {
		    exists = True;
	    } else if ( c < ar[key].code ) {
		    upper = --key;
	    } else {
		    lower = ++key;
	    }
    }  
    if (exists) {
	    ar += key;
#if DEBUG
	    prerror("Adjustment for %x is executed!\n", ar->code );
#endif
	    ch->xOffset += VConv((double) ch->tfmw * (-(ar->Xadj)));
	    ch->yOffset += HConv(tfmh * (ar->Yadj));
    }
  }

  ch->where.isloaded = True;
  ch->glyph_attribute = 0;
  fe->common.access_count++;

found:
  return(ch);
}

static int
kfont_free(fe)
register FontEntry *fe;
{
  register int i;

  /* reset least used file pointer to NULL */
  for (i = 0; i < nopen; ++i)
    if (OpenedFonts[i] == fe) {
      unregister_fm_font(i);
      break;
    }
  free_tfm();
  return(True);
}
