/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: kfont.h,v 1.14 1994/03/24 13:19:22 kakiuchi Exp $
 */

#ifndef _KFONT_
#define _KFONT_

/* This is a header file for kanji font. */
#include "font.h"
#include "FM.h"
#include "fmmtrc.h"


typedef struct {
  char *tex_name;  		/* name in TeX */
  char *real_name; 		/* real font name */
  AdjustRatioRecord *adj_table;	/* ptr to Adjustment Table */
  int len;         		/* length of the name in TeX */
  int size_of_adj_table;	/* number of records in adjustment table */
} FontName;

#ifndef SON
static FontName FontNameTable[] = {
  { "min", "motoyam%d", minadj},
  { "goth", "motoyag%d", gothadj },
  { "fmin", "motoyam%d", minadj},
  { "fgoth", "motoyag%d", gothadj },
  { "mgoth", "motoyag%d", gothadj },
#ifdef PTEX
  { "tmin", "motoyam%d", minadj},
  { "tgoth", "motoyag%d", gothadj },
  { "tfmin", "motoyam%d", minadj},
  { "tfgoth", "motoyag%d", gothadj },
  { "tmgoth", "motoyag%d", gothadj },
#endif /* PTEX */
  { NULL, NULL, NULL },
};
#else
static FontName FontNameTable[] = {
  { "min", "Mincho%d", minadj },
  { "goth", "Gothic%d", gothadj },
  { "fmin", "motoyam%d", minadj},
  { "fgoth", "motoyag%d", gothadj },
  { "mgoth", "motoyag%d", gothadj },
#ifdef PTEX
  { "tmin", "Mincho%d", minadj },
  { "tgoth", "Gothic%d", gothadj },
  { "tfmin", "motoyam%d", minadj},
  { "tfgoth", "motoyag%d", gothadj },
  { "tmgoth", "motoyag%d", gothadj },
#endif /* PTEX */
  { NULL, NULL, NULL },
};
#endif
  
  
/*
 * Data Structures
 * ===============
 */

/*
 * Font information.
 */

typedef struct font_entry {
  /* common fields (defined in font.h) */
  CommonEntry common;
  /* kfont specific fields */
  struct kfont_entry *kfont;
} FontEntry;

#include "common.h"

typedef struct kfont_entry {
  u16 width, height;
  JFM *jfm;
  KCharEntry *ch;
  AdjustRatioRecord *adj_table;
  int size_of_adj_table;
} KFontEntry;

#endif /* _KFONT_ */
